/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.commands;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.EVStore;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class PokeReset
extends CommandBase {
    private static final List<String> aliases = new ArrayList<String>();
    private static final List<String> slots = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6"});

    public String func_71517_b() {
        return "pokereset";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/pokereset <player> <slot> [lvl] - resets the pokemon in <slot> of <player> to lvl 5 and 0 EVs";
    }

    public List<String> func_71514_a() {
        return aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 2 || args.length == 3) {
            try {
                EntityPlayerMP player = PokeReset.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
                if (BattleRegistry.getBattle((EntityPlayer)player) != null) {
                    return;
                }
                int slot = Integer.parseInt(args[1]) - 1;
                PlayerPartyStorage storage = Pixelmon.storageManager.getParty(player);
                if (storage == null) {
                    return;
                }
                Pokemon pokemon = storage.get(slot);
                if (pokemon == null) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"There is no Pokemon in that slot!", (Object[])new Object[0]);
                    return;
                }
                storage.retrieveAll();
                if (args.length == 3) {
                    int lvl = Integer.parseInt(args[2]);
                    pokemon.getLevelContainer().setLevel(lvl);
                } else {
                    pokemon.getLevelContainer().setLevel(5);
                }
                pokemon.getStats().evs = new EVStore();
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.WHITE, (String)"%s's %s was reset!", (Object[])new Object[]{player.getDisplayNameString(), pokemon.getDisplayName()});
            }
            catch (NumberFormatException nfe) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)this.func_71518_a(sender), (Object[])new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (args.length == 1) {
            try {
                EntityPlayerMP player = PokeReset.func_71521_c((ICommandSender)sender);
                if (BattleRegistry.getBattle((EntityPlayer)player) != null) {
                    return;
                }
                int intPartySlot = Integer.parseInt(args[0]);
                PlayerPartyStorage storage = Pixelmon.storageManager.getParty(player);
                if (storage == null) {
                    return;
                }
                Pokemon pokemon = storage.get(intPartySlot - 1);
                if (pokemon == null) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"There is no Pokemon in that slot!", (Object[])new Object[0]);
                    return;
                }
                pokemon.getLevelContainer().setLevel(5);
                pokemon.getStats().evs = new EVStore();
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.WHITE, (String)"%s's %s was reset!", (Object[])new Object[]{player.getDisplayNameString(), pokemon.getDisplayName()});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.WHITE, (String)"Incorrect usage. %s", (Object[])new Object[]{this.func_71518_a(sender)});
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 2) {
            return PokeReset.func_175762_a((String[])args, slots);
        }
        return PokeReset.func_71530_a((String[])args, (String[])server.func_71213_z());
    }

    static {
        aliases.add("preset");
    }
}

