/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.commands;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class RandomPokeType
extends CommandBase
implements ICommand {
    private final List<String> aliases = Lists.newArrayList((Object[])new String[]{"pgt"});

    @Nonnull
    public String func_71517_b() {
        return "pokegivetype";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return TextFormatting.RED + "/pokegivetype <player> <type> [spec] [-l] [-ub]";
    }

    @Nonnull
    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length == 0) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)this.func_71518_a(sender), (Object[])new Object[0]);
        } else if (args.length >= 2) {
            EnumType type = EnumType.parseType((String)args[1]);
            if (type == null || type.equals((Object)EnumType.Mystery)) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Incorrect type provided!", (Object[])new Object[0]);
                return;
            }
            EntityPlayerMP player = RandomPokeType.func_184888_a((MinecraftServer)server, (ICommandSender)server, (String)args[0]);
            boolean legendary = false;
            boolean ultrabeast = false;
            for (String arg : args) {
                if (arg.contains("-l")) {
                    legendary = true;
                }
                if (!arg.contains("-ub")) continue;
                ultrabeast = true;
            }
            Pokemon p = Pixelmon.pokemonFactory.create(EnumSpecies.randomPoke((boolean)legendary));
            if (ultrabeast) {
                while (!this.checkType(p, type)) {
                    p = Pixelmon.pokemonFactory.create(EnumSpecies.randomPoke((boolean)legendary));
                }
            } else {
                while (this.checkBeast(p) || !this.checkType(p, type)) {
                    p = Pixelmon.pokemonFactory.create(EnumSpecies.randomPoke((boolean)legendary));
                }
            }
            ArrayList speclist = Lists.newArrayList((Object[])args);
            speclist.remove(0);
            PokemonSpec spec = PokemonSpec.from((String[])speclist.toArray(new String[0]));
            p.setCaughtBall(EnumPokeballs.PokeBall);
            spec.apply(p);
            PlayerPartyStorage storage = Pixelmon.storageManager.getParty(player);
            if (BattleRegistry.getBattle((EntityPlayer)player) == null) {
                storage.add(p);
            } else {
                PCStorage pcStorage = Pixelmon.storageManager.getPCForPlayer(player);
                pcStorage.add(p);
            }
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.GREEN, (String)("You've sent a " + TextFormatting.YELLOW + p.getDisplayName() + TextFormatting.GREEN + " to " + TextFormatting.GOLD + player.func_70005_c_() + TextFormatting.GREEN + "."), (Object[])new Object[0]);
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.GREEN, (String)("You've been given a " + TextFormatting.YELLOW + p.getDisplayName() + TextFormatting.GREEN + "."), (Object[])new Object[0]);
        } else {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Error!", (Object[])new Object[0]);
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)this.func_71518_a(sender), (Object[])new Object[0]);
        }
    }

    private boolean checkType(Pokemon pokemon, EnumType type) {
        return pokemon.getBaseStats().types.contains(type);
    }

    private boolean checkBeast(Pokemon pokemon) {
        return EnumSpecies.ultrabeasts.contains(pokemon.getSpecies());
    }

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            return RandomPokeType.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2) {
            ArrayList list = new ArrayList(EnumType.getAllTypes());
            list.remove(EnumType.Mystery);
            return RandomPokeType.func_175762_a((String[])args, list);
        }
        return Collections.emptyList();
    }

    public boolean func_82358_a(String[] astring, int i) {
        return false;
    }
}

