/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.commands;

import com.pixelextras.PermUtils;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class TradeSim
extends CommandBase {
    public String func_71517_b() {
        return "tradesim";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender var1) {
        return "/tradesim <slot> [simulated] - simulates a trade of <slot> with [simulated]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)this.func_71518_a(sender), (Object[])new Object[0]);
            return;
        }
        try {
            EntityPlayerMP player = TradeSim.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)sender.func_70005_c_());
            PlayerPartyStorage storage = Pixelmon.storageManager.getParty(player);
            if (storage == null) {
                return;
            }
            int slot = Integer.parseInt(args[0].replaceAll("[^0-9]", ""));
            if (slot < 1 || slot > 6) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Slot number must be between 1 and 6.", (Object[])new Object[0]);
                return;
            }
            String name = "Magikarp";
            if (args.length > 1 && !EnumSpecies.hasPokemonAnyCase((String)(name = args[1]))) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)("Unknown Pok\u00e9mon that the trade is simulating with: " + args[1]), (Object[])new Object[0]);
                return;
            }
            Pokemon pokemon = storage.get(slot - 1);
            if (pokemon == null) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Nothing exists in that slot.", (Object[])new Object[0]);
                return;
            }
            if (pokemon.isEgg()) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Simulation failed! Eggs cannot evolve via trade!", (Object[])new Object[0]);
                return;
            }
            if (pokemon.hasSpecFlag("untradeable") && !PermUtils.hasPermission("pixelextras.tradesim.bypass.untradeable", player)) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"This Pok\u00e9mon cannot be traded.", (Object[])new Object[0]);
                return;
            }
            EntityPixelmon pixelmon = pokemon.getOrSpawnPixelmon(player.field_70170_p, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p());
            pixelmon.testTradeEvolution(EnumSpecies.getFromNameAnyCase((String)name));
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.GREEN, (String)"Simulation complete!", (Object[])new Object[0]);
        }
        catch (NumberFormatException e) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Please provide a slot!", (Object[])new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return TradeSim.func_71530_a((String[])args, (String[])new String[]{"1", "2", "3", "4", "5", "6"});
        }
        if (args.length == 2) {
            return TradeSim.func_175762_a((String[])args, (Collection)EnumSpecies.getNameList());
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

