/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.config;

import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class PixelExtrasConfig {
    public static Configuration config;
    public static long hatchCooldown;
    public static long breedCooldown;
    public static boolean allowRandomLegendaries;
    public static boolean allowRandomUltraBeasts;
    public static boolean allowNotifications;
    public static double expConversionRate;
    public static boolean checkEggIVs;
    public static boolean notifyOPs;
    public static boolean allowOfflineCheck;

    public static void loadConfig(Configuration configuration) {
        config = configuration;
        config.addCustomCategoryComment("general", "General settings for Pixel Extras");
        Property propHatchCooldown = config.get("general", "Hatch Command Cooldown (in seconds)", 600);
        hatchCooldown = propHatchCooldown.getInt(600) * 1000;
        propHatchCooldown.setComment("Sets how long the time will be until the user can use /hatch again");
        Property propBreedCooldown = config.get("general", "Breed Command Cooldown (in seconds)", 600);
        breedCooldown = propBreedCooldown.getInt(600) * 1000;
        propBreedCooldown.setComment("Sets how long the time will be until the user can use /breed again");
        allowRandomLegendaries = config.get("general", "Allows legendaries via /pokerandom", false, "If true then /pokerandom can potentially select legendaries").getBoolean();
        allowRandomUltraBeasts = config.get("general", "Allows ultra beasts via /pokerandom", false, "If true then /pokerandom can potentially select Ultra Beasts").getBoolean();
        allowNotifications = config.get("general", "Allow /breed cooldown notifications", false, "If true then players can use /breeding true/false to enable/disable a cooldown message").getBoolean();
        notifyOPs = config.get("general", "Notify OPs", true, "Notify OPs when players run certain commands").getBoolean();
        checkEggIVs = config.get("general", "Check Egg IVs", true, "Whether or not /ivs will work on eggs").getBoolean();
        allowOfflineCheck = config.get("general", "Allow offline player via /pokesee etc", true, "If true then /pokesee, /poketake, /compsee, /compsearch, /comptake etc can be use on an offline player").getBoolean();
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void readConfig() {
        Configuration cfg = config;
        try {
            cfg.load();
        }
        catch (Exception e1) {
            System.out.println("Problem loading config file!");
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
    }

    static {
        hatchCooldown = 600L;
        breedCooldown = 600L;
        allowRandomLegendaries = false;
        allowRandomUltraBeasts = false;
        allowNotifications = false;
        expConversionRate = 1.0;
        checkEggIVs = true;
        notifyOPs = true;
        allowOfflineCheck = true;
    }
}

