/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.specs;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.ISpecType;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.SpecValue;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class FriendshipSpec
extends SpecValue<Integer>
implements ISpecType {
    public FriendshipSpec(Integer value) {
        super("friendship", (Object)value);
    }

    public List<String> getKeys() {
        return Lists.newArrayList((Object[])new String[]{"fr", "friend", "friendship"});
    }

    public Class<Integer> getValueClass() {
        return Integer.class;
    }

    public void apply(EntityPixelmon pokemon) {
        pokemon.getPokemonData().setFriendship(((Integer)this.value).intValue());
    }

    public void apply(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74768_a("Friendship", ((Integer)this.value).intValue());
    }

    public void apply(Pokemon pokemon) {
        pokemon.setFriendship(((Integer)this.value).intValue());
    }

    public boolean matches(EntityPixelmon entityPixelmon) {
        return this.matches(entityPixelmon.getPokemonData());
    }

    public boolean matches(NBTTagCompound nbtTagCompound) {
        return nbtTagCompound.func_74762_e("Friendship") == ((Integer)this.value).intValue();
    }

    public boolean matches(Pokemon pokemon) {
        return pokemon.getFriendship() == ((Integer)this.value).intValue();
    }

    public SpecValue<Integer> clone() {
        return new FriendshipSpec((Integer)this.value);
    }

    public SpecValue<?> parse(@Nullable String s) {
        if (s == null) {
            return new FriendshipSpec(70);
        }
        try {
            return new FriendshipSpec(Integer.parseInt(s));
        }
        catch (NumberFormatException e) {
            return new FriendshipSpec(70);
        }
    }

    public SpecValue<?> readFromNBT(NBTTagCompound nbtTagCompound) {
        return new FriendshipSpec(nbtTagCompound.func_74762_e("Friendship"));
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound, SpecValue<?> specValue) {
        nbtTagCompound.func_74768_a("Friendship", ((Integer)specValue.value).intValue());
    }

    public Class<? extends SpecValue<?>> getSpecClass() {
        return FriendshipSpec.class;
    }

    public String toParameterForm(SpecValue<?> value) {
        return value.key + ":" + value.value.toString();
    }
}

