/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.util;

import com.pixelextras.util.TextUtil;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.HiddenPower;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.IVStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.items.EnumFossils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;

public class PixelmonHelper {
    public static boolean canLearnAbility(Pokemon p, String ability) {
        String[] abil;
        for (String s : abil = p.getBaseStats().abilities) {
            if (s == null || !s.equals(ability)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHidden(Pokemon p, String ability) {
        return p.getBaseStats().abilities[2] != null && p.getBaseStats().abilities[2].equalsIgnoreCase(ability);
    }

    @Deprecated
    public static ITextComponent getHoverText(Pokemon pokemon, int ... args) {
        NBTTagCompound nbt = new NBTTagCompound();
        pokemon.writeToNBT(nbt);
        return PixelmonHelper.getHoverText(nbt, args);
    }

    @Deprecated
    private static ITextComponent getHoverText(NBTTagCompound nbt, int ... args) {
        TextComponentString statString = new TextComponentString("[Stats]");
        statString.func_150256_b().func_150238_a(TextFormatting.RED);
        TextComponentString boxString = new TextComponentString("[Box Info]");
        boxString.func_150256_b().func_150238_a(TextFormatting.YELLOW);
        if (args != null) {
            boxString.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("" + TextFormatting.YELLOW + "Box: " + args[0] + " Slot: " + args[1])));
        }
        String itemText = "None";
        if (nbt.func_74764_b("HeldItemStack") && !new ItemStack(nbt.func_74775_l("HeldItemStack")).func_190926_b()) {
            itemText = new ItemStack(nbt.func_74775_l("HeldItemStack")).func_82833_r();
        }
        statString.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("" + TextFormatting.DARK_GREEN + TextFormatting.UNDERLINE + (nbt.func_74779_i("Nickname").equals("") ? nbt.func_74779_i("Name") : nbt.func_74779_i("Nickname")) + (nbt.func_74771_c("IsShiny") == 1 ? TextFormatting.YELLOW + "\u2605" : "") + "\n" + TextFormatting.AQUA + "Level: " + nbt.func_74762_e("Level") + "\n" + TextFormatting.YELLOW + "Nature: " + EnumNature.getNatureFromIndex((int)nbt.func_74765_d("Nature")).toString() + "\n" + TextFormatting.GREEN + "Growth: " + EnumGrowth.getGrowthFromIndex((int)nbt.func_74765_d("Growth")).toString() + "\n" + TextFormatting.GOLD + "Ability: " + (nbt.func_74762_e("AbilitySlot") != 2 ? TextFormatting.GOLD : TextFormatting.GRAY) + nbt.func_74779_i("Ability") + "\n" + TextFormatting.LIGHT_PURPLE + "Gender: " + Gender.getGender((short)nbt.func_74771_c("Gender")).name() + "\n" + TextFormatting.DARK_PURPLE + "OT: " + nbt.func_74779_i("originalTrainer") + "\n" + TextFormatting.RED + "Item: " + itemText)));
        TextComponentString evString = new TextComponentString("[EVs]");
        evString.func_150256_b().func_150238_a(TextFormatting.GOLD);
        evString.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("" + TextFormatting.GOLD + TextFormatting.UNDERLINE + "EVs\n" + TextFormatting.GOLD + "HP: " + nbt.func_74765_d("EVHP") + "\n" + TextFormatting.GOLD + "Attack: " + nbt.func_74765_d("EVAttack") + "\n" + TextFormatting.GOLD + "Defence: " + nbt.func_74765_d("EVDefence") + "\n" + TextFormatting.GOLD + "Sp. Attack: " + nbt.func_74765_d("EVSpecialAttack") + "\n" + TextFormatting.GOLD + "Sp. Defence: " + nbt.func_74765_d("EVSpecialDefence") + "\n" + TextFormatting.GOLD + "Speed: " + nbt.func_74765_d("EVSpeed"))));
        TextComponentString ivString = new TextComponentString("[IVs]");
        ivString.func_150256_b().func_150238_a(TextFormatting.LIGHT_PURPLE);
        ivString.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("" + TextFormatting.LIGHT_PURPLE + TextFormatting.UNDERLINE + "IVs\n" + TextFormatting.LIGHT_PURPLE + "HP: " + nbt.func_74771_c("IVHP") + "\n" + TextFormatting.LIGHT_PURPLE + "Attack: " + nbt.func_74771_c("IVAttack") + "\n" + TextFormatting.LIGHT_PURPLE + "Defence: " + nbt.func_74771_c("IVDefence") + "\n" + TextFormatting.LIGHT_PURPLE + "Sp. Attack: " + nbt.func_74771_c("IVSpAtt") + "\n" + TextFormatting.LIGHT_PURPLE + "Sp. Defence: " + nbt.func_74771_c("IVSpDef") + "\n" + TextFormatting.LIGHT_PURPLE + "Speed: " + nbt.func_74771_c("IVSpeed"))));
        TextComponentString movesString = new TextComponentString("[Moves]");
        movesString.func_150256_b().func_150238_a(TextFormatting.BLUE);
        movesString.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("" + TextFormatting.BLUE + TextFormatting.UNDERLINE + "Moves\n" + TextFormatting.BLUE + "Move 1: " + (nbt.func_74764_b("PixelmonMoveID0") ? ((AttackBase)AttackBase.getAttackBase((int)nbt.func_74765_d("PixelmonMoveID0")).get()).getLocalizedName() : "None") + "\n" + TextFormatting.BLUE + "Move 2: " + (nbt.func_74764_b("PixelmonMoveID1") ? ((AttackBase)AttackBase.getAttackBase((int)nbt.func_74765_d("PixelmonMoveID1")).get()).getLocalizedName() : "None") + "\n" + TextFormatting.BLUE + "Move 3: " + (nbt.func_74764_b("PixelmonMoveID2") ? ((AttackBase)AttackBase.getAttackBase((int)nbt.func_74765_d("PixelmonMoveID2")).get()).getLocalizedName() : "None") + "\n" + TextFormatting.BLUE + "Move 4: " + (nbt.func_74764_b("PixelmonMoveID3") ? ((AttackBase)AttackBase.getAttackBase((int)nbt.func_74765_d("PixelmonMoveID3")).get()).getLocalizedName() : "None"))));
        TextComponentTranslation baseString = args != null ? new TextComponentTranslation((nbt.func_74771_c("IsShiny") == 1 ? TextFormatting.YELLOW : "") + nbt.func_74779_i("Name") + " %s %s %s %s %s", new Object[]{boxString, statString, evString, ivString, movesString}) : new TextComponentTranslation((nbt.func_74771_c("IsShiny") == 1 ? TextFormatting.YELLOW : "") + nbt.func_74779_i("Name") + " %s %s %s %s", new Object[]{statString, evString, ivString, movesString});
        baseString.func_150256_b().func_150238_a(TextFormatting.GREEN);
        return baseString;
    }

    public static ITextComponent getHoverTextPokemon(Pokemon pokemon, int ... args) {
        TextComponentString statString = new TextComponentString("[Stats]");
        statString.func_150256_b().func_150238_a(TextFormatting.RED);
        TextComponentString boxString = new TextComponentString("[Box Info]");
        boxString.func_150256_b().func_150238_a(TextFormatting.YELLOW);
        if (args != null && args.length > 0) {
            boxString.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("" + TextFormatting.YELLOW + "Box: " + args[0] + " Slot: " + args[1])));
        }
        String itemText = "None";
        if (!pokemon.getHeldItem().func_190926_b()) {
            itemText = pokemon.getHeldItem().func_82833_r();
        }
        statString.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("" + TextFormatting.DARK_GREEN + TextFormatting.UNDERLINE + (pokemon.getSpecies().name != null ? pokemon.getSpecies().name : pokemon.getNickname()) + (pokemon.isShiny() ? TextFormatting.YELLOW + "\u2605" : "") + "\n" + TextFormatting.AQUA + "Level: " + pokemon.getLevel() + "\n" + TextFormatting.YELLOW + "Nature: " + pokemon.getNature().toString() + "\n" + TextFormatting.GREEN + "Growth: " + pokemon.getGrowth().toString() + "\n" + TextFormatting.GOLD + "Ability: %s\n" + TextFormatting.LIGHT_PURPLE + "Gender: " + pokemon.getGender().name() + "\n" + TextFormatting.DARK_PURPLE + "OT: " + pokemon.getOriginalTrainer() + "\n" + TextFormatting.RED + "Item: " + itemText, new Object[]{TextUtil.applyColour((ITextComponent)new TextComponentTranslation(pokemon.getAbility().getUnlocalizedName(), new Object[0]), pokemon.getAbilitySlot() == 2 ? TextFormatting.GRAY : TextFormatting.GOLD)})));
        TextComponentString evString = new TextComponentString("[EVs]");
        evString.func_150256_b().func_150238_a(TextFormatting.GOLD);
        evString.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("" + TextFormatting.GOLD + TextFormatting.UNDERLINE + "EVs\n" + TextFormatting.GOLD + "HP: " + pokemon.getEVs().get(StatsType.HP) + "\n" + TextFormatting.GOLD + "Attack: " + pokemon.getEVs().get(StatsType.Attack) + "\n" + TextFormatting.GOLD + "Defence: " + pokemon.getEVs().get(StatsType.Defence) + "\n" + TextFormatting.GOLD + "Sp. Attack: " + pokemon.getEVs().get(StatsType.SpecialAttack) + "\n" + TextFormatting.GOLD + "Sp. Defence: " + pokemon.getEVs().get(StatsType.SpecialDefence) + "\n" + TextFormatting.GOLD + "Speed: " + pokemon.getEVs().get(StatsType.Speed))));
        TextComponentString ivString = new TextComponentString("[IVs]");
        ivString.func_150256_b().func_150238_a(TextFormatting.LIGHT_PURPLE);
        ivString.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("" + TextFormatting.LIGHT_PURPLE + TextFormatting.UNDERLINE + "IVs\n" + TextFormatting.LIGHT_PURPLE + "HP: " + (pokemon.getIVs().isHyperTrained(StatsType.HP) ? pokemon.getIVs().get(StatsType.HP) + " \u00a7b(31 HyperTrained)" : Integer.valueOf(pokemon.getIVs().get(StatsType.HP))) + "\n" + TextFormatting.LIGHT_PURPLE + "Attack: " + (pokemon.getIVs().isHyperTrained(StatsType.Attack) ? pokemon.getIVs().get(StatsType.Attack) + " \u00a7b(31 HyperTrained)" : Integer.valueOf(pokemon.getIVs().get(StatsType.Attack))) + "\n" + TextFormatting.LIGHT_PURPLE + "Defence: " + (pokemon.getIVs().isHyperTrained(StatsType.Defence) ? pokemon.getIVs().get(StatsType.Defence) + " \u00a7b(31 HyperTrained)" : Integer.valueOf(pokemon.getIVs().get(StatsType.Defence))) + "\n" + TextFormatting.LIGHT_PURPLE + "Sp. Attack: " + (pokemon.getIVs().isHyperTrained(StatsType.SpecialAttack) ? pokemon.getIVs().get(StatsType.SpecialAttack) + " \u00a7b(31 HyperTrained)" : Integer.valueOf(pokemon.getIVs().get(StatsType.SpecialAttack))) + "\n" + TextFormatting.LIGHT_PURPLE + "Sp. Defence: " + (pokemon.getIVs().isHyperTrained(StatsType.SpecialDefence) ? pokemon.getIVs().get(StatsType.SpecialDefence) + " \u00a7b(31 HyperTrained)" : Integer.valueOf(pokemon.getIVs().get(StatsType.SpecialDefence))) + "\n" + TextFormatting.LIGHT_PURPLE + "Speed: " + (pokemon.getIVs().isHyperTrained(StatsType.Speed) ? pokemon.getIVs().get(StatsType.Speed) + " \u00a7b(31 HyperTrained)" : Integer.valueOf(pokemon.getIVs().get(StatsType.Speed))))));
        TextComponentString movesString = new TextComponentString("[Moves]");
        movesString.func_150256_b().func_150238_a(TextFormatting.BLUE);
        movesString.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("" + TextFormatting.BLUE + TextFormatting.UNDERLINE + "Moves\n" + TextFormatting.BLUE + "Move 1: %s\n" + TextFormatting.BLUE + "Move 2: %s\n" + TextFormatting.BLUE + "Move 3: %s\n" + TextFormatting.BLUE + "Move 4: %s", new Object[]{TextUtil.applyColour((ITextComponent)new TextComponentTranslation(pokemon.getMoveset().get(0) != null ? pokemon.getMoveset().get(0).getMove().getUnlocalizedName() : "None", new Object[0]), TextFormatting.BLUE), TextUtil.applyColour((ITextComponent)new TextComponentTranslation(pokemon.getMoveset().get(1) != null ? pokemon.getMoveset().get(1).getMove().getUnlocalizedName() : "None", new Object[0]), TextFormatting.BLUE), TextUtil.applyColour((ITextComponent)new TextComponentTranslation(pokemon.getMoveset().get(2) != null ? pokemon.getMoveset().get(2).getMove().getUnlocalizedName() : "None", new Object[0]), TextFormatting.BLUE), TextUtil.applyColour((ITextComponent)new TextComponentTranslation(pokemon.getMoveset().get(3) != null ? pokemon.getMoveset().get(3).getMove().getUnlocalizedName() : "None", new Object[0]), TextFormatting.BLUE)})));
        TextComponentTranslation baseString = args != null && args.length > 0 ? new TextComponentTranslation((pokemon.isShiny() ? TextFormatting.YELLOW : "") + pokemon.getSpecies().name + " %s %s %s %s %s", new Object[]{boxString, statString, evString, ivString, movesString}) : new TextComponentTranslation((pokemon.isShiny() ? TextFormatting.YELLOW : "") + pokemon.getSpecies().name + " %s %s %s %s", new Object[]{statString, evString, ivString, movesString});
        baseString.func_150256_b().func_150238_a(TextFormatting.GREEN);
        return baseString;
    }

    public static EnumType checkStats(Pokemon p) {
        return HiddenPower.getHiddenPowerType((IVStore)p.getIVs());
    }

    public static EnumSpecies getPokemon(EnumFossils fossil1, EnumFossils fossil2) {
        if (fossil1.equals((Object)EnumFossils.BIRD) && fossil2.equals((Object)EnumFossils.DRAKE) || fossil1.equals((Object)EnumFossils.DRAKE) && fossil2.equals((Object)EnumFossils.BIRD)) {
            return EnumSpecies.Dracozolt;
        }
        if (fossil1.equals((Object)EnumFossils.BIRD) && fossil2.equals((Object)EnumFossils.DINO) || fossil1.equals((Object)EnumFossils.DINO) && fossil2.equals((Object)EnumFossils.BIRD)) {
            return EnumSpecies.Arctozolt;
        }
        if (fossil1.equals((Object)EnumFossils.FISH) && fossil2.equals((Object)EnumFossils.DRAKE) || fossil1.equals((Object)EnumFossils.DRAKE) && fossil2.equals((Object)EnumFossils.FISH)) {
            return EnumSpecies.Dracovish;
        }
        if (fossil1.equals((Object)EnumFossils.FISH) && fossil2.equals((Object)EnumFossils.DINO) || fossil1.equals((Object)EnumFossils.DINO) && fossil2.equals((Object)EnumFossils.FISH)) {
            return EnumSpecies.Arctovish;
        }
        return null;
    }
}

