/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.util;

import com.google.common.collect.Lists;
import com.pixelextras.PixelExtras;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class SpawnDetails {
    public static TextComponentString createPokeDetails(SpawnInfoPokemon spawnInfo) {
        TextComponentString txt = new TextComponentString("\u00a7bSpecies spawn info:\n");
        Pokemon pokemon = Pixelmon.pokemonFactory.create(spawnInfo.getPokemonSpec());
        String form = "";
        if (pokemon.getForm() > 0) {
            form = " " + form.concat(pokemon.getSpecies().getFormEnum(pokemon.getForm()).getLocalizedName());
        }
        txt.func_150258_a("Type of spawn location: " + String.join((CharSequence)", ", spawnInfo.stringLocationTypes) + "\n");
        txt.func_150258_a("Minimum level: " + spawnInfo.minLevel + "\n");
        txt.func_150258_a("Maximum level: " + spawnInfo.maxLevel + "\n");
        if (spawnInfo.heldItems != null) {
            ArrayList itemName = Lists.newArrayList();
            spawnInfo.heldItems.forEach(jsonItemStack -> itemName.add(TextFormatting.DARK_AQUA + jsonItemStack.getItemStack().func_82833_r()));
            txt.func_150258_a("HeldItems: " + String.join((CharSequence)(TextFormatting.YELLOW + ", "), itemName) + "\n");
        }
        txt.func_150258_a("Biomes: " + SpawnDetails.getBiomeSpawns(spawnInfo) + "\n");
        txt.func_150258_a("Rarity: " + spawnInfo.rarity);
        TextComponentString pokeHover = new TextComponentString(TextFormatting.DARK_AQUA + pokemon.getLocalizedName() + form);
        pokeHover.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)txt));
        return pokeHover;
    }

    public static String getBiomeSpawns(SpawnInfoPokemon info) {
        ArrayList<Biome> allBiomes = new ArrayList<Biome>();
        for (Biome biome2 : GameRegistry.findRegistry(Biome.class)) {
            allBiomes.add(biome2);
        }
        if (info.condition != null && info.condition.biomes != null && !info.condition.biomes.isEmpty()) {
            allBiomes.removeIf(biome -> !info.condition.biomes.contains(biome));
        }
        if (info.anticondition != null && info.anticondition.biomes != null && !info.anticondition.biomes.isEmpty()) {
            allBiomes.removeIf(biome -> info.anticondition.biomes.contains(biome));
        }
        if (info.compositeCondition != null) {
            if (info.compositeCondition.conditions != null) {
                info.compositeCondition.conditions.forEach(condition -> {
                    if (condition.biomes != null && !condition.biomes.isEmpty()) {
                        allBiomes.removeIf(biome -> !condition.biomes.contains(biome));
                    }
                });
            }
            if (info.compositeCondition.anticonditions != null) {
                info.compositeCondition.anticonditions.forEach(anticondition -> {
                    if (anticondition.biomes != null && anticondition.biomes.isEmpty()) {
                        allBiomes.removeIf(biome -> anticondition.biomes.contains(biome));
                    }
                });
            }
        }
        HashSet avail = new HashSet(allBiomes);
        ArrayList<String> biomeNames = new ArrayList<String>();
        for (Biome biome3 : avail) {
            biomeNames.add(TextFormatting.DARK_AQUA + biome3.field_76791_y);
        }
        return String.join((CharSequence)(TextFormatting.YELLOW + ", "), biomeNames);
    }

    public static String getWorldSpawn(SpawnInfoPokemon info) {
        ArrayList<Integer> allDims = new ArrayList<Integer>();
        for (WorldServer world : PixelExtras.getServer().field_71305_c) {
            allDims.add(world.field_73011_w.getDimension());
        }
        if (info.condition != null && info.condition.dimensions != null && !info.condition.dimensions.isEmpty()) {
            allDims.removeIf(id -> !info.condition.dimensions.contains(id));
        }
        if (info.anticondition != null && info.anticondition.dimensions != null && !info.anticondition.dimensions.isEmpty()) {
            allDims.removeIf(id -> info.anticondition.dimensions.contains(id));
        }
        if (info.compositeCondition != null) {
            if (info.compositeCondition.conditions != null) {
                info.compositeCondition.conditions.forEach(condition -> {
                    if (condition.dimensions != null && !condition.dimensions.isEmpty()) {
                        allDims.removeIf(id -> !condition.dimensions.contains(id));
                    }
                });
            }
            if (info.compositeCondition.anticonditions != null) {
                info.compositeCondition.anticonditions.forEach(anticondition -> {
                    if (anticondition.dimensions != null && anticondition.dimensions.isEmpty()) {
                        allDims.removeIf(id -> anticondition.dimensions.contains(id));
                    }
                });
            }
        }
        HashSet avail = new HashSet(allDims);
        ArrayList<String> dimNames = new ArrayList<String>();
        for (Integer id2 : avail) {
            dimNames.add(TextFormatting.DARK_AQUA + PixelExtras.getServer().func_71218_a(id2.intValue()).func_72912_H().func_76065_j());
        }
        return String.join((CharSequence)(TextFormatting.YELLOW + ", "), dimNames);
    }
}

