/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu;

import de.keksuccino.fancymenu.keybinding.Keybinding;
import de.keksuccino.fancymenu.mainwindow.MainWindowHandler;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.button.ButtonScriptEngine;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.gameintro.GameIntroHandler;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiLoader;
import de.keksuccino.fancymenu.menu.fancy.music.GameMusicHandler;
import de.keksuccino.fancymenu.menu.guiconstruction.GuiConstructor;
import de.keksuccino.konkrete.Konkrete;
import de.keksuccino.konkrete.config.Config;
import de.keksuccino.konkrete.config.exceptions.InvalidValueException;
import de.keksuccino.konkrete.localization.Locals;
import java.io.File;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="fancymenu", acceptedMinecraftVersions="[1.12,1.12.2]", dependencies="after:findme;required-after:konkrete@[1.0.3,]")
public class FancyMenu {
    public static final String VERSION = "1.5.2";
    public static Config config;
    private static File animationsPath;
    private static File customizationPath;
    private static File customGuiPath;
    private static File buttonscriptPath;

    public FancyMenu() {
        try {
            if (FMLClientHandler.instance().getSide() == Side.CLIENT) {
                animationsPath.mkdirs();
                customizationPath.mkdirs();
                customGuiPath.mkdirs();
                buttonscriptPath.mkdirs();
                FancyMenu.updateConfig();
                AnimationHandler.init();
                AnimationHandler.loadCustomAnimations();
                CustomGuiLoader.loadCustomGuis();
                GameIntroHandler.init();
                MenuCustomization.init();
                if (((Boolean)config.getOrDefault("enablehotkeys", (Object)true)).booleanValue()) {
                    Keybinding.init();
                }
                ButtonScriptEngine.init();
                Konkrete.addPostLoadingEvent((String)"fancymenu", this::onClientSetup);
            } else {
                System.out.println("## WARNING ## 'FancyMenu' is a client mod and has no effect when loaded on a server!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onClientSetup() {
        try {
            if (FMLClientHandler.instance().getSide() == Side.CLIENT) {
                FancyMenu.initLocals();
                GameMusicHandler.init();
                MainWindowHandler.init();
                MainWindowHandler.updateWindowIcon();
                MainWindowHandler.updateWindowTitle();
                GuiConstructor.init();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void initLocals() {
        String baseresdir = "fmlocals/";
        File f = new File("config/fancymenu/locals");
        if (!f.exists()) {
            f.mkdirs();
        }
        Locals.copyLocalsFileToDir((ResourceLocation)new ResourceLocation("keksuccino", baseresdir + "en_us.local"), (String)"en_us", (String)f.getPath());
        Locals.copyLocalsFileToDir((ResourceLocation)new ResourceLocation("keksuccino", baseresdir + "de_de.local"), (String)"de_de", (String)f.getPath());
        Locals.copyLocalsFileToDir((ResourceLocation)new ResourceLocation("keksuccino", baseresdir + "pl_pl.local"), (String)"pl_pl", (String)f.getPath());
        Locals.copyLocalsFileToDir((ResourceLocation)new ResourceLocation("keksuccino", baseresdir + "pt_br.local"), (String)"pt_br", (String)f.getPath());
        Locals.getLocalsFromDir((String)f.getPath());
    }

    public static void updateConfig() {
        try {
            config = new Config("config/fancymenu/config.txt");
            config.registerValue("enablehotkeys", Boolean.valueOf(true), "general", "A minecraft restart is required after changing this value.");
            config.registerValue("playmenumusic", Boolean.valueOf(true), "general");
            config.registerValue("playbackgroundsounds", Boolean.valueOf(true), "general", "If menu background sounds added by FancyMenu should be played or not.");
            config.registerValue("showcustomizationbuttons", Boolean.valueOf(true), "customization");
            config.registerValue("softmode", Boolean.valueOf(false), "customization", "Maximizes mod compatibility. Disables background customization support for scrollable menu screens. Restart is needed after changing this value.");
            config.registerValue("legacybuttonids", Boolean.valueOf(false), "customization");
            config.registerValue("hidebranding", Boolean.valueOf(true), "mainmenu");
            config.registerValue("hidelogo", Boolean.valueOf(false), "mainmenu");
            config.registerValue("showmainmenufooter", Boolean.valueOf(false), "mainmenu");
            config.registerValue("hiderealmsnotifications", Boolean.valueOf(false), "mainmenu");
            config.registerValue("copyrightposition", "bottom-right", "mainmenu");
            config.registerValue("hideforgenotifications", Boolean.valueOf(false), "mainmenu");
            config.registerValue("hidesplashtext", Boolean.valueOf(false), "mainmenu_splash");
            config.registerValue("splashoffsetx", Integer.valueOf(0), "mainmenu_splash");
            config.registerValue("splashoffsety", Integer.valueOf(0), "mainmenu_splash");
            config.registerValue("splashrotation", Integer.valueOf(-20), "mainmenu_splash");
            config.registerValue("gameintroanimation", "", "loading");
            config.registerValue("showanimationloadingstatus", Boolean.valueOf(true), "loading");
            config.registerValue("allowgameintroskip", Boolean.valueOf(true), "loading");
            config.registerValue("customgameintroskiptext", "", "loading");
            config.registerValue("customwindowicon", Boolean.valueOf(false), "minecraftwindow", "A minecraft restart is required after changing this value.");
            config.registerValue("customwindowtitle", "", "minecraftwindow", "A minecraft restart is required after changing this value.");
            config.registerValue("showundoredocontrols", Boolean.valueOf(false), "layouteditor", "If the undo/redo control buttons of the layout editor should be visible or not.");
            config.registerValue("showvanillamovewarning", Boolean.valueOf(true), "layouteditor", "If the warning when trying to move an vanilla button without an orientation should be displayed or not.");
            config.syncConfig();
            config.setCategory("enablehotkeys", "general");
            config.setCategory("playmenumusic", "general");
            config.setCategory("playbackgroundsounds", "general");
            config.setCategory("showcustomizationbuttons", "customization");
            config.setCategory("softmode", "customization");
            config.setCategory("legacybuttonids", "customization");
            config.setCategory("hidebranding", "mainmenu");
            config.setCategory("hidelogo", "mainmenu");
            config.setCategory("showmainmenufooter", "mainmenu");
            config.setCategory("hiderealmsnotifications", "mainmenu");
            config.setCategory("copyrightposition", "mainmenu");
            config.setCategory("hideforgenotifications", "mainmenu");
            config.setCategory("hidesplashtext", "mainmenu_splash");
            config.setCategory("splashoffsetx", "mainmenu_splash");
            config.setCategory("splashoffsety", "mainmenu_splash");
            config.setCategory("splashrotation", "mainmenu_splash");
            config.setCategory("gameintroanimation", "loading");
            config.setCategory("showanimationloadingstatus", "loading");
            config.setCategory("allowgameintroskip", "loading");
            config.setCategory("customgameintroskiptext", "loading");
            config.setCategory("customwindowicon", "minecraftwindow");
            config.setCategory("customwindowtitle", "minecraftwindow");
            config.setCategory("showundoredocontrols", "layouteditor");
            config.setCategory("showvanillamovewarning", "layouteditor");
            config.clearUnusedValues();
        }
        catch (InvalidValueException e) {
            e.printStackTrace();
        }
    }

    public static File getAnimationPath() {
        if (!animationsPath.exists()) {
            animationsPath.mkdirs();
        }
        return animationsPath;
    }

    public static File getCustomizationPath() {
        if (!customizationPath.exists()) {
            customizationPath.mkdirs();
        }
        return customizationPath;
    }

    public static File getCustomGuiPath() {
        if (!customGuiPath.exists()) {
            customGuiPath.mkdirs();
        }
        return customGuiPath;
    }

    public static File getButtonScriptPath() {
        if (!buttonscriptPath.exists()) {
            buttonscriptPath.mkdirs();
        }
        return buttonscriptPath;
    }

    static {
        animationsPath = new File("config/fancymenu/animations");
        customizationPath = new File("config/fancymenu/customization");
        customGuiPath = new File("config/fancymenu/customguis");
        buttonscriptPath = new File("config/fancymenu/buttonscripts");
    }
}

