/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.animation;

import de.keksuccino.fancymenu.menu.animation.exceptions.AnimationNotFoundException;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import de.keksuccino.konkrete.sound.SoundHandler;
import java.io.File;
import javax.annotation.Nullable;

public class AdvancedAnimation
implements IAnimationRenderer {
    private IAnimationRenderer introRenderer;
    private IAnimationRenderer animationRenderer;
    private boolean started = false;
    private String mainAudioPath;
    private String introAudioPath;
    private boolean muted = false;
    private boolean replayIntro = false;

    public AdvancedAnimation(@Nullable IAnimationRenderer introAnimation, IAnimationRenderer mainAnimation, @Nullable String introAudioPath, @Nullable String mainAudioPath, boolean replayIntro) throws AnimationNotFoundException {
        if (mainAnimation == null) {
            throw new AnimationNotFoundException("Animation cannot be null!");
        }
        this.animationRenderer = mainAnimation;
        this.introRenderer = introAnimation;
        this.mainAudioPath = mainAudioPath;
        this.introAudioPath = introAudioPath;
        this.replayIntro = replayIntro;
    }

    public boolean hasIntro() {
        return this.introRenderer != null;
    }

    public boolean isReady() {
        if (this.animationRenderer != null && this.hasIntro()) {
            if (this.animationRenderer.isReady() && this.introRenderer.isReady()) {
                return true;
            }
        } else if (this.animationRenderer != null) {
            return this.animationRenderer.isReady();
        }
        return false;
    }

    public void prepareAnimation() {
        if (this.mainAudioPath != null) {
            SoundHandler.registerSound((String)this.animationRenderer.getPath(), (String)this.mainAudioPath);
        }
        if (this.introAudioPath != null && this.hasIntro()) {
            SoundHandler.registerSound((String)this.introRenderer.getPath(), (String)this.introAudioPath);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.prepareAnimation();
        }
        if (this.hasIntro()) {
            this.introRenderer.prepareAnimation();
        }
    }

    public void resetAnimation() {
        if (this.animationRenderer != null) {
            this.animationRenderer.resetAnimation();
        }
        if (this.hasIntro()) {
            this.introRenderer.resetAnimation();
        }
        this.started = false;
    }

    public boolean hasStarted() {
        return this.started;
    }

    public void render() {
        if (this.isReady()) {
            this.started = true;
            if (!this.muted) {
                if (this.hasIntroAudio() && !this.introRenderer.isFinished() && (this.introRenderer.currentFrame() == 1 || this.introRenderer.currentFrame() > 1 && !SoundHandler.isPlaying((String)this.introRenderer.getPath()))) {
                    SoundHandler.stopSound((String)this.animationRenderer.getPath());
                    SoundHandler.resetSound((String)this.introRenderer.getPath());
                    SoundHandler.playSound((String)this.introRenderer.getPath());
                }
                if (this.hasIntroAudio() && this.introRenderer.isFinished()) {
                    SoundHandler.stopSound((String)this.introRenderer.getPath());
                }
                if (this.hasMainAudio() && !this.animationRenderer.isFinished() && (this.animationRenderer.currentFrame() == 1 || this.animationRenderer.currentFrame() > 1 && !SoundHandler.isPlaying((String)this.animationRenderer.getPath()))) {
                    if (this.hasIntroAudio()) {
                        SoundHandler.stopSound((String)this.introRenderer.getPath());
                    }
                    SoundHandler.resetSound((String)this.animationRenderer.getPath());
                    SoundHandler.playSound((String)this.animationRenderer.getPath());
                    SoundHandler.setLooped((String)this.animationRenderer.getPath(), (boolean)true);
                }
            }
            if (this.hasIntro()) {
                this.introRenderer.setFPS(this.animationRenderer.getFPS());
                this.introRenderer.setWidth(this.animationRenderer.getWidth());
                this.introRenderer.setHeight(this.animationRenderer.getHeight());
                this.introRenderer.setPosX(this.animationRenderer.getPosX());
                this.introRenderer.setPosY(this.animationRenderer.getPosY());
                this.introRenderer.setLooped(false);
                if (!this.introRenderer.isFinished()) {
                    this.introRenderer.render();
                } else {
                    this.animationRenderer.render();
                }
            } else {
                this.animationRenderer.render();
            }
        }
        if (this.isFinished() || this.muted) {
            this.stopAudio();
        }
    }

    public void setStretchImageToScreensize(boolean b) {
        if (this.hasIntro()) {
            this.introRenderer.setStretchImageToScreensize(b);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setStretchImageToScreensize(b);
        }
    }

    public void setHideAfterLastFrame(boolean b) {
        if (this.hasIntro()) {
            this.introRenderer.setHideAfterLastFrame(b);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setHideAfterLastFrame(b);
        }
    }

    public boolean isFinished() {
        if (this.hasIntro() && this.animationRenderer != null) {
            if (this.introRenderer.isFinished() && this.animationRenderer.isFinished()) {
                return true;
            }
        } else if (this.animationRenderer != null) {
            return this.animationRenderer.isFinished();
        }
        return false;
    }

    public void setWidth(int width) {
        if (this.hasIntro()) {
            this.introRenderer.setWidth(width);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setWidth(width);
        }
    }

    public void setHeight(int height) {
        if (this.hasIntro()) {
            this.introRenderer.setHeight(height);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setHeight(height);
        }
    }

    public void setPosX(int x) {
        if (this.hasIntro()) {
            this.introRenderer.setPosX(x);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setPosX(x);
        }
    }

    public void setPosY(int y) {
        if (this.hasIntro()) {
            this.introRenderer.setPosY(y);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setPosY(y);
        }
    }

    public int currentFrame() {
        int i = 0;
        if (this.hasIntro()) {
            i = this.introRenderer.currentFrame();
        }
        if (this.animationRenderer != null) {
            i += this.animationRenderer.currentFrame();
        }
        return i;
    }

    public int animationFrames() {
        int i = 0;
        if (this.hasIntro()) {
            i = this.introRenderer.animationFrames();
        }
        if (this.animationRenderer != null) {
            i += this.animationRenderer.animationFrames();
        }
        return i;
    }

    public String getPath() {
        if (this.animationRenderer != null) {
            return new File(this.animationRenderer.getPath()).toPath().getParent().toString();
        }
        return null;
    }

    public void setFPS(int fps) {
        if (this.hasIntro()) {
            this.introRenderer.setFPS(fps);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setFPS(fps);
        }
    }

    public void setLooped(boolean b) {
        if (this.animationRenderer != null) {
            this.animationRenderer.setLooped(b);
        }
    }

    public int getFPS() {
        if (this.animationRenderer != null) {
            return this.animationRenderer.getFPS();
        }
        return 0;
    }

    public boolean isGettingLooped() {
        return this.animationRenderer.isGettingLooped();
    }

    public boolean isStretchedToStreensize() {
        if (this.animationRenderer != null) {
            return this.animationRenderer.isStretchedToStreensize();
        }
        return false;
    }

    public int getWidth() {
        return this.animationRenderer.getWidth();
    }

    public int getHeight() {
        return this.animationRenderer.getHeight();
    }

    public int getPosX() {
        return this.animationRenderer.getPosX();
    }

    public int getPosY() {
        return this.animationRenderer.getPosY();
    }

    public void setMuteAudio(boolean b) {
        this.muted = b;
    }

    public boolean hasMainAudio() {
        return this.mainAudioPath != null && SoundHandler.soundExists((String)this.animationRenderer.getPath());
    }

    public boolean hasIntroAudio() {
        return this.hasIntro() && this.introAudioPath != null && SoundHandler.soundExists((String)this.introRenderer.getPath());
    }

    public void stopAudio() {
        SoundHandler.stopSound((String)this.animationRenderer.getPath());
        if (this.hasIntro()) {
            SoundHandler.stopSound((String)this.introRenderer.getPath());
        }
    }

    public void resetAudio() {
        SoundHandler.resetSound((String)this.animationRenderer.getPath());
        if (this.hasIntro()) {
            SoundHandler.resetSound((String)this.introRenderer.getPath());
        }
    }

    public boolean replayIntro() {
        return this.replayIntro;
    }
}

