/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.animation;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.menu.animation.AnimationData;
import de.keksuccino.fancymenu.menu.animation.AnimationHandlerEvents;
import de.keksuccino.fancymenu.menu.animation.AnimationLoadingScreen;
import de.keksuccino.fancymenu.menu.animation.exceptions.AnimationNotFoundException;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.rendering.animation.ExternalGifAnimationRenderer;
import de.keksuccino.konkrete.rendering.animation.ExternalTextureAnimationRenderer;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.MinecraftForge;

public class AnimationHandler {
    private static Map<String, AnimationData> animations = new HashMap<String, AnimationData>();
    private static List<String> custom = new ArrayList<String>();
    protected static boolean ready = false;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new AnimationHandlerEvents());
    }

    public static void registerAnimation(IAnimationRenderer animation, String name, AnimationData.Type type) {
        if (!animations.containsKey(name)) {
            animations.put(name, new AnimationData(animation, name, type));
            if (type == AnimationData.Type.EXTERNAL) {
                custom.add(name);
            }
        } else {
            System.out.println("######################################");
            System.out.println("[FM AnimationHandler] Animation name '" + name + "' already used!");
            System.out.println("######################################");
        }
    }

    public static void unregisterAnimation(IAnimationRenderer animation) {
        AnimationData d = null;
        for (AnimationData a : animations.values()) {
            if (a.animation != animation) continue;
            d = a;
            break;
        }
        if (d != null) {
            AnimationHandler.unregisterAnimation(d.name);
        }
    }

    public static void unregisterAnimation(String name) {
        if (AnimationHandler.animationExists(name)) {
            animations.remove(name);
            if (custom.contains(name)) {
                custom.remove(name);
            }
        }
    }

    public static void loadCustomAnimations() {
        File f = FancyMenu.getAnimationPath();
        if (!f.exists() || !f.isDirectory()) {
            return;
        }
        ready = false;
        AnimationHandler.clearCustomAnimations();
        for (File a : f.listFiles()) {
            File audio2;
            File audio1;
            String name = null;
            String mainAudio = null;
            String introAudio = null;
            int fps = 0;
            boolean loop = true;
            int width = 0;
            int height = 0;
            int x = 0;
            int y = 0;
            boolean replayIntro = false;
            if (!a.isDirectory()) continue;
            File p = new File(a.getAbsolutePath() + "/properties.txt");
            Map<String, String> props = AnimationHandler.parseProperties(p);
            if (!props.isEmpty()) {
                String s;
                if (props.containsKey("name") && (s = props.get("name")) != null && !s.equals("")) {
                    name = s;
                }
                if (props.containsKey("fps") && (s = props.get("fps")) != null && !s.equals("") && MathUtils.isInteger((String)s)) {
                    fps = Integer.parseInt(s);
                }
                if (props.containsKey("loop") && (s = props.get("loop")) != null && !s.equals("") && s.equalsIgnoreCase("false")) {
                    loop = false;
                }
                if (props.containsKey("width") && (s = props.get("width")) != null && !s.equals("") && MathUtils.isInteger((String)s)) {
                    width = Integer.parseInt(s);
                }
                if (props.containsKey("height") && (s = props.get("height")) != null && !s.equals("") && MathUtils.isInteger((String)s)) {
                    height = Integer.parseInt(s);
                }
                if (props.containsKey("x") && (s = props.get("x")) != null && !s.equals("") && MathUtils.isInteger((String)s)) {
                    x = Integer.parseInt(s);
                }
                if (props.containsKey("y") && (s = props.get("y")) != null && !s.equals("") && MathUtils.isInteger((String)s)) {
                    y = Integer.parseInt(s);
                }
                if (props.containsKey("replayintro") && (s = props.get("replayintro")) != null && s.equalsIgnoreCase("true")) {
                    replayIntro = true;
                }
            }
            if ((audio1 = new File(a.getAbsolutePath() + "/audio/mainaudio.wav")).exists()) {
                mainAudio = audio1.getPath();
            }
            if ((audio2 = new File(a.getAbsolutePath() + "/audio/introaudio.wav")).exists()) {
                introAudio = audio2.getPath();
            }
            if (name == null) continue;
            File gifIntro = new File(a.getPath() + "/intro.gif");
            File gifAni = new File(a.getPath() + "/animation.gif");
            ExternalGifAnimationRenderer in = null;
            ExternalGifAnimationRenderer an = null;
            if (gifAni.exists()) {
                if (gifIntro.exists() && gifAni.exists()) {
                    in = new ExternalGifAnimationRenderer(gifIntro.getPath(), loop, x, y, width, height);
                    an = new ExternalGifAnimationRenderer(gifAni.getPath(), loop, x, y, width, height);
                } else if (gifAni.exists()) {
                    an = new ExternalGifAnimationRenderer(gifAni.getPath(), loop, x, y, width, height);
                }
            } else {
                String intro = AnimationHandler.getIntroPath(a.getPath());
                String ani = AnimationHandler.getAnimationPath(a.getPath());
                if (intro != null && ani != null) {
                    in = new ExternalTextureAnimationRenderer(intro, fps, loop, x, y, width, height);
                    an = new ExternalTextureAnimationRenderer(ani, fps, loop, x, y, width, height);
                } else if (ani != null) {
                    an = new ExternalTextureAnimationRenderer(ani, fps, loop, x, y, width, height);
                }
            }
            try {
                if (in != null && an != null) {
                    AnimationHandler.registerAnimation(new AdvancedAnimation((IAnimationRenderer)in, (IAnimationRenderer)an, introAudio, mainAudio, replayIntro), name, AnimationData.Type.EXTERNAL);
                    System.out.println("[FM AnimationHandler] Custom animation found and registered: " + name + "");
                    continue;
                }
                if (an != null) {
                    AnimationHandler.registerAnimation(new AdvancedAnimation(null, (IAnimationRenderer)an, introAudio, mainAudio, false), name, AnimationData.Type.EXTERNAL);
                    System.out.println("[FM AnimationHandler] Custom animation found and registered: " + name + "");
                    continue;
                }
                System.out.println("[FM AnimationHandler] ### ERROR: This is not a valid animation: " + name);
            }
            catch (AnimationNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<String> getCustomAnimationNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(custom);
        return l;
    }

    private static String getIntroPath(String path) {
        File f = new File(path + "/intro");
        if (f.exists() && f.isDirectory()) {
            return f.getPath();
        }
        return null;
    }

    private static String getAnimationPath(String path) {
        File f = new File(path + "/animation");
        if (f.exists() && f.isDirectory()) {
            return f.getPath();
        }
        return null;
    }

    private static void clearCustomAnimations() {
        for (String s : custom) {
            if (!animations.containsKey(s)) continue;
            animations.remove(s);
        }
    }

    private static Map<String, String> parseProperties(File prop) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (prop.exists() && prop.isFile()) {
            for (String s : FileUtils.getFileLines((File)prop)) {
                if (!s.contains("=")) continue;
                String name = s.split("[=]", 2)[0].replace(" ", "");
                String value = s.split("[=]", 2)[1].replace(" ", "");
                m.put(name, value);
            }
        }
        return m;
    }

    public static void setupAnimations() {
        if (!animations.isEmpty()) {
            Object s = null;
            s = Minecraft.func_71410_x().field_71462_r != null ? Minecraft.func_71410_x().field_71462_r : new GuiMainMenu();
            AnimationLoadingScreen l = new AnimationLoadingScreen((GuiScreen)s, AnimationHandler.getAnimations().toArray(new IAnimationRenderer[0])){

                @Override
                public void onFinished() {
                    ready = true;
                    super.onFinished();
                }
            };
            Minecraft.func_71410_x().func_147108_a((GuiScreen)l);
        } else {
            ready = true;
        }
    }

    public static boolean animationExists(String name) {
        return animations.containsKey(name);
    }

    public static List<IAnimationRenderer> getAnimations() {
        ArrayList<IAnimationRenderer> renderers = new ArrayList<IAnimationRenderer>();
        for (Map.Entry<String, AnimationData> m : animations.entrySet()) {
            renderers.add(m.getValue().animation);
        }
        return renderers;
    }

    public static IAnimationRenderer getAnimation(String name) {
        if (AnimationHandler.animationExists(name)) {
            return AnimationHandler.animations.get((Object)name).animation;
        }
        return null;
    }

    public static boolean isReady() {
        return ready;
    }
}

