/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.animation;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.konkrete.gui.screens.SimpleLoadingScreen;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class AnimationLoadingScreen
extends SimpleLoadingScreen {
    private GuiScreen fallback;
    private List<IAnimationRenderer> renderers = new ArrayList<IAnimationRenderer>();
    private boolean ready = false;
    private int cachedFPS;
    private boolean cachedLoop;
    private boolean done = false;
    private volatile boolean preparing = false;

    public AnimationLoadingScreen(@Nullable GuiScreen fallbackGui, IAnimationRenderer ... renderer) {
        super(Minecraft.func_71410_x());
        this.renderers.addAll(Arrays.asList(renderer));
        this.fallback = fallbackGui;
    }

    public void func_73863_a(int p_render_1_, int p_render_2_, float p_render_3_) {
        IAnimationRenderer current = this.getCurrentRenderer();
        if (current == null) {
            this.done = true;
            this.onFinished();
            if (this.fallback != null) {
                Minecraft.func_71410_x().func_147108_a(this.fallback);
            }
        } else {
            if (!this.ready) {
                this.cachedFPS = current.getFPS();
                this.cachedLoop = current.isGettingLooped();
                current.setFPS(-1);
                current.setLooped(false);
                this.ready = true;
            }
            if (!current.isReady()) {
                if (!this.preparing) {
                    if (((Boolean)FancyMenu.config.getOrDefault("showanimationloadingstatus", (Object)true)).booleanValue()) {
                        this.setStatusText(Locals.localize((String)"loading.animation.loadingframes", (String[])new String[]{current.getPath().replace("/", ".").replace("\\", ".")}));
                    }
                    this.preparing = true;
                } else {
                    current.prepareAnimation();
                    System.gc();
                    this.preparing = false;
                }
            } else if (!current.isFinished()) {
                if (((Boolean)FancyMenu.config.getOrDefault("showanimationloadingstatus", (Object)true)).booleanValue()) {
                    this.setStatusText(Locals.localize((String)"loading.animation.prerendering", (String[])new String[]{current.getPath().replace("/", ".").replace("\\", ".")}));
                }
                if (current instanceof AdvancedAnimation) {
                    ((AdvancedAnimation)current).setMuteAudio(true);
                }
                current.render();
                if (current instanceof AdvancedAnimation) {
                    ((AdvancedAnimation)current).setMuteAudio(false);
                }
            } else {
                current.setFPS(this.cachedFPS);
                current.setLooped(this.cachedLoop);
                current.resetAnimation();
                this.renderers.remove(0);
                this.ready = false;
            }
        }
        super.func_73863_a(p_render_1_, p_render_2_, p_render_3_);
    }

    private IAnimationRenderer getCurrentRenderer() {
        if (!this.renderers.isEmpty()) {
            return this.renderers.get(0);
        }
        return null;
    }

    public void onFinished() {
        this.setStatusText(Locals.localize((String)"loading.animation.done", (String[])new String[0]));
    }

    public boolean loadingFinished() {
        return this.done;
    }
}

