/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.button;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.mainwindow.MainWindowHandler;
import de.keksuccino.fancymenu.menu.button.ButtonCachedEvent;
import de.keksuccino.fancymenu.menu.button.ButtonData;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.helper.CustomizationButton;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutCreatorScreen;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.custom.videosettings.VideoSettingsMenuHandler;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.screens.SimpleLoadingScreen;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.localization.LocaleUtils;
import de.keksuccino.konkrete.math.MathUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiVideoSettings;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ButtonCache {
    private static Map<Long, ButtonData> buttons = new HashMap<Long, ButtonData>();
    private static Map<Long, GuiButton> replaced = new HashMap<Long, GuiButton>();
    private static GuiScreen current = null;
    private static boolean cached = false;
    private static boolean caching = false;

    @SubscribeEvent
    public void updateCache(GuiScreenEvent.InitGuiEvent.Post e) {
        if (!caching) {
            cached = false;
            current = e.getGui();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBackDrawn(GuiScreenEvent.BackgroundDrawnEvent e) {
        ButtonCache.cache(e.getGui());
    }

    @SubscribeEvent
    public void onRenderPre(GuiScreenEvent.DrawScreenEvent.Pre e) {
        ButtonCache.cache(e.getGui());
    }

    private static void cache(GuiScreen s) {
        if (!cached) {
            cached = true;
            boolean cache = true;
            if (MenuCustomization.isExcludedSoft(s.getClass().getName()) || MenuCustomization.isExcludedFull(s.getClass().getName())) {
                replaced.clear();
                buttons.clear();
                MinecraftForge.EVENT_BUS.post((Event)new ButtonCachedEvent(s, new ArrayList<ButtonData>(), false));
                return;
            }
            if (s != null && s instanceof GuiVideoSettings && !VideoSettingsMenuHandler.isScrollable()) {
                replaced.clear();
                buttons.clear();
                MinecraftForge.EVENT_BUS.post((Event)new ButtonCachedEvent(s, new ArrayList<ButtonData>(), false));
                return;
            }
            if (s.getClass().getName().startsWith("slimeknights.")) {
                replaced.clear();
                buttons.clear();
                MinecraftForge.EVENT_BUS.post((Event)new ButtonCachedEvent(s, new ArrayList<ButtonData>(), false));
                return;
            }
            if (s.getClass().getName().startsWith("net.optifine")) {
                replaced.clear();
                buttons.clear();
                MinecraftForge.EVENT_BUS.post((Event)new ButtonCachedEvent(s, new ArrayList<ButtonData>(), false));
                return;
            }
            if (s instanceof LayoutCreatorScreen) {
                cache = false;
            }
            if (s instanceof SimpleLoadingScreen) {
                cache = false;
            }
            if (s == Minecraft.func_71410_x().field_71462_r && cache) {
                ButtonCache.updateButtons(s, ButtonCache.getGuiButtons(s));
            }
            MinecraftForge.EVENT_BUS.post((Event)new ButtonCachedEvent(s, ButtonCache.getButtons(), cache));
        }
    }

    private static void updateButtons(GuiScreen s, @Nullable List<GuiButton> buttonlist) {
        block11: {
            block10: {
                replaced.clear();
                buttons.clear();
                if (MenuCustomization.isExcludedSoft(s.getClass().getName()) || MenuCustomization.isExcludedFull(s.getClass().getName())) {
                    return;
                }
                if (s != null && s instanceof GuiVideoSettings && !VideoSettingsMenuHandler.isScrollable()) {
                    return;
                }
                if (s.getClass().getName().startsWith("slimeknights.")) {
                    return;
                }
                if (s.getClass().getName().startsWith("net.optifine")) {
                    return;
                }
                if (!ButtonCache.useLegacyButtonIds()) break block10;
                if (buttonlist != null) {
                    long i = 1L;
                    for (GuiButton w : ButtonCache.sortButtons(buttonlist)) {
                        buttons.put(i, new ButtonData(w, i, LocaleUtils.getKeyForString((String)w.field_146126_j), s));
                        ++i;
                    }
                } else {
                    System.out.println("#### ERROR [FANCYMENU]: Buttonlist is NULL and ID calculation set to legacy!");
                }
                break block11;
            }
            List<ButtonData> ids = ButtonCache.cacheButtons(s, 1000, 1000);
            List<ButtonData> btns = ButtonCache.cacheButtons(s, MainWindowHandler.getScaledWidth(), MainWindowHandler.getScaledHeight());
            if (btns.size() != ids.size()) break block11;
            int i = 0;
            for (ButtonData id : ids) {
                ButtonData button = btns.get(i);
                if (!buttons.containsKey(id.getId())) {
                    buttons.put(id.getId(), new ButtonData(button.getButton(), id.getId(), LocaleUtils.getKeyForString((String)button.getButton().field_146126_j), s));
                } else {
                    System.out.println("");
                    System.out.println("#### WARNING [FANCYMENU]: Overlapping buttons found!");
                    System.out.println("At: X=" + button.x + " Y=" + button.y + "!");
                    System.out.println("Labels: " + button.label + ", " + ButtonCache.buttons.get((Object)Long.valueOf((long)id.getId())).label);
                    System.out.println("");
                    System.out.println("If one or booth of these buttons are added by a mod, please contact the developer(s) to fix this!");
                    System.out.println("FancyMenu cannot customize overlapping buttons!");
                    System.out.println("#####################################################");
                    System.out.println("");
                }
                ++i;
            }
        }
    }

    private static List<ButtonData> cacheButtons(GuiScreen s, int screenWidth, int screenHeight) {
        caching = true;
        ArrayList<ButtonData> buttonlist = new ArrayList<ButtonData>();
        try {
            Field f0 = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"buttonList", "field_146292_n"});
            ((List)f0.get(s)).clear();
            s.field_146297_k = Minecraft.func_71410_x();
            s.field_146294_l = screenWidth;
            s.field_146295_m = screenHeight;
            Field f1 = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"itemRender", "field_146296_j"});
            f1.set(s, Minecraft.func_71410_x().func_175599_af());
            Field f2 = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"fontRenderer", "field_146289_q"});
            f2.set(s, Minecraft.func_71410_x().field_71466_p);
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.InitGuiEvent.Pre(s, (List)f0.get(s)));
            s.func_73866_w_();
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.InitGuiEvent.Post(s, (List)f0.get(s)));
            Field f = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"buttonList", "field_146292_n"});
            for (GuiButton w : (List)f.get(s)) {
                String idRaw = w.field_146128_h + "" + w.field_146129_i;
                long id = 0L;
                if (MathUtils.isLong((String)idRaw)) {
                    id = Long.parseLong(idRaw);
                }
                buttonlist.add(new ButtonData(w, id, LocaleUtils.getKeyForString((String)w.field_146126_j), s));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        caching = false;
        return buttonlist;
    }

    public static void replaceButton(long id, GuiButton w) {
        ButtonData d = ButtonCache.getButtonForId(id);
        GuiButton ori = null;
        if (d != null && current != null) {
            try {
                Field f = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"buttonList", "field_146292_n"});
                List l = (List)f.get(current);
                ArrayList<GuiButton> l2 = new ArrayList<GuiButton>();
                for (GuiButton b : l) {
                    if (b == d.getButton()) {
                        l2.add(w);
                        ori = b;
                        continue;
                    }
                    l2.add(b);
                }
                f.set(current, l2);
                if (ori != null) {
                    replaced.put(d.getId(), ori);
                }
                d.replaceButton(w);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void replaceButton(String key, GuiButton w) {
        ButtonData d = ButtonCache.getButtonForKey(key);
        if (d != null) {
            ButtonCache.replaceButton(d.getId(), w);
        }
    }

    public static AdvancedButton convertToAdvancedButton(long id, boolean handleClick) {
        ButtonData d = ButtonCache.getButtonForId(id);
        if (d != null && !(d.getButton() instanceof AdvancedButton)) {
            AdvancedButton b = new AdvancedButton(d.getButton().field_146128_h, d.getButton().field_146129_i, d.getButton().field_146120_f, d.getButton().field_146121_g, d.getButton().field_146126_j, handleClick, press -> {
                GuiButton w = replaced.get(d.getId());
                if (w != null) {
                    ButtonCache.clickButton(w);
                }
            });
            b.field_146124_l = d.getButton().field_146124_l;
            b.field_146125_m = d.getButton().field_146125_m;
            d.getButton().field_146125_m = false;
            ButtonCache.replaceButton(id, (GuiButton)b);
            return b;
        }
        return null;
    }

    public static AdvancedButton convertToAdvancedButton(String key, boolean handleClick) {
        ButtonData d = ButtonCache.getButtonForKey(key);
        if (d != null) {
            return ButtonCache.convertToAdvancedButton(d.getId(), handleClick);
        }
        return null;
    }

    public static void addButton(GuiButton w) {
        ArrayList<GuiButton> l = new ArrayList<GuiButton>();
        for (ButtonData d : ButtonCache.getButtons()) {
            l.add(d.getButton());
        }
        l.add(w);
        if (current != null) {
            ButtonCache.updateButtons(current, l);
        }
    }

    private static List<GuiButton> getGuiButtons(GuiScreen s) {
        List<Object> l = new ArrayList<GuiButton>();
        try {
            Field f = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"buttonList", "field_146292_n"});
            l = (List)f.get(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return l;
    }

    public static void cacheFrom(GuiScreen s, int screenWidth, int screenHeight) {
        if (ButtonCache.useLegacyButtonIds()) {
            ArrayList<GuiButton> l = new ArrayList<GuiButton>();
            try {
                Field f0 = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"buttonList", "field_146292_n"});
                f0.set(s, new ArrayList());
                s.field_146297_k = Minecraft.func_71410_x();
                s.field_146294_l = screenWidth;
                s.field_146295_m = screenHeight;
                Field f1 = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"itemRender", "field_146296_j"});
                f1.set(s, Minecraft.func_71410_x().func_175599_af());
                Field f2 = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"fontRenderer", "field_146289_q"});
                f2.set(s, Minecraft.func_71410_x().field_71466_p);
                MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.InitGuiEvent.Pre(s, l));
                s.func_73866_w_();
                Field f = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"buttonList", "field_146292_n"});
                l.addAll((List)f.get(s));
                MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.InitGuiEvent.Post(s, l));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ButtonCache.updateButtons(s, l);
        } else {
            ButtonCache.updateButtons(s, null);
        }
    }

    private static List<GuiButton> sortButtons(List<GuiButton> widgets) {
        ArrayList<GuiButton> l = new ArrayList<GuiButton>();
        HashMap m = new HashMap();
        for (GuiButton w : widgets) {
            if (CustomizationButton.isCustomizationButton(w)) continue;
            if (m.containsKey(w.field_146129_i)) {
                ((List)m.get(w.field_146129_i)).add(w);
                continue;
            }
            m.put(w.field_146129_i, new ArrayList());
            ((List)m.get(w.field_146129_i)).add(w);
        }
        ArrayList ints = new ArrayList();
        ints.addAll(m.keySet());
        Collections.sort(ints, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (o1 > o2) {
                    return 1;
                }
                if (o1 < o2) {
                    return -1;
                }
                return 0;
            }
        });
        for (Integer i : ints) {
            List l2 = (List)m.get(i);
            Collections.sort(l2, new Comparator<GuiButton>(){

                @Override
                public int compare(GuiButton o1, GuiButton o2) {
                    if (o1.field_146120_f > o2.field_146120_f) {
                        return 1;
                    }
                    if (o1.field_146120_f < o2.field_146120_f) {
                        return -1;
                    }
                    return 0;
                }
            });
            l.addAll(l2);
        }
        return l;
    }

    public static long getIdForButton(GuiButton w) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (m.getValue().getButton() != w) continue;
            return m.getValue().getId();
        }
        return -1L;
    }

    public static String getNameForButton(GuiButton w) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (m.getValue().getButton() != w) continue;
            return m.getValue().label;
        }
        return null;
    }

    public static String getKeyForButton(GuiButton w) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (m.getValue().getButton() != w) continue;
            return m.getValue().getKey();
        }
        return null;
    }

    public static ButtonData getButtonForId(long id) {
        return buttons.get(id);
    }

    public static ButtonData getButtonForKey(String key) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (!m.getValue().getKey().equalsIgnoreCase(key)) continue;
            return m.getValue();
        }
        return null;
    }

    public static ButtonData getButtonForName(String name) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (!m.getValue().label.equals(name)) continue;
            return m.getValue();
        }
        return null;
    }

    public static List<ButtonData> getButtons() {
        ArrayList<ButtonData> b = new ArrayList<ButtonData>();
        b.addAll(buttons.values());
        return b;
    }

    public static boolean useLegacyButtonIds() {
        return (Boolean)FancyMenu.config.getOrDefault("legacybuttonids", (Object)false);
    }

    private static void clickButton(GuiButton b) {
        b.func_146116_c(Minecraft.func_71410_x(), MouseInput.getMouseX(), MouseInput.getMouseY());
        try {
            Method m = ReflectionHelper.findMethod(GuiScreen.class, (String)"actionPerformed", (String)"func_146284_a", (Class[])new Class[]{GuiButton.class});
            m.invoke((Object)Minecraft.func_71410_x().field_71462_r, b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isCaching() {
        return caching;
    }
}

