/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.button;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiLoader;
import de.keksuccino.fancymenu.menu.fancy.helper.CustomizationHelper;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerBase;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerRegistry;
import de.keksuccino.fancymenu.menu.guiconstruction.GuiConstructor;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.gui.screens.popup.NotificationPopup;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.GuiConnecting;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ButtonScriptEngine {
    private static Map<String, ButtonScript> scripts = new HashMap<String, ButtonScript>();
    private static boolean init = false;

    public static void init() {
        if (!init) {
            init = true;
            MinecraftForge.EVENT_BUS.register((Object)new ButtonScriptEngine());
            ButtonScriptEngine.updateButtonScripts();
        }
    }

    public static void updateButtonScripts() {
        scripts.clear();
        if (!FancyMenu.getButtonScriptPath().exists()) {
            FancyMenu.getButtonScriptPath().mkdirs();
        }
        for (File f : FancyMenu.getButtonScriptPath().listFiles()) {
            if (!f.isFile() || !f.getPath().toLowerCase().endsWith(".txt")) continue;
            scripts.put(com.google.common.io.Files.getNameWithoutExtension((String)f.getPath()), new ButtonScript(f));
        }
    }

    public static void runButtonScript(String name) {
        if (scripts.containsKey(name)) {
            scripts.get(name).runScript();
        }
    }

    public static Map<String, ButtonScript> getButtonScripts() {
        return scripts;
    }

    public static void runButtonAction(String action, String value) {
        try {
            File f;
            File fromFile;
            File toFile;
            String from;
            int cur;
            MenuHandlerBase handler;
            File f2;
            if (action.equalsIgnoreCase("openlink")) {
                value = CharacterFilter.getUrlCharacterFilter().filterForAllowedChars(value);
                ButtonScriptEngine.openWebLink(value);
            }
            if (action.equalsIgnoreCase("sendmessage") && Minecraft.func_71410_x().field_71441_e != null && !MinecraftForge.EVENT_BUS.post((Event)new ClientChatEvent(value))) {
                Minecraft.func_71410_x().field_71439_g.func_71165_d(value);
            }
            if (action.equalsIgnoreCase("quitgame")) {
                Minecraft.func_71410_x().func_71400_g();
            }
            if (action.equalsIgnoreCase("joinserver")) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiConnecting(Minecraft.func_71410_x().field_71462_r, Minecraft.func_71410_x(), new ServerData("", value, true)));
            }
            if (action.equalsIgnoreCase("loadworld") && Minecraft.func_71410_x().func_71359_d().func_90033_f(value)) {
                Minecraft.func_71410_x().func_71371_a(value, value, (WorldSettings)null);
            }
            if (action.equalsIgnoreCase("openfile") && (f2 = new File(value.replace("\\", "/"))).exists()) {
                ButtonScriptEngine.openFile(f2);
            }
            if (action.equalsIgnoreCase("prevbackground") && (handler = MenuHandlerRegistry.getLastActiveHandler()) != null && (cur = handler.getCurrentBackgroundAnimationId()) > 0) {
                for (IAnimationRenderer an : handler.backgroundAnimations()) {
                    if (!(an instanceof AdvancedAnimation)) continue;
                    ((AdvancedAnimation)an).stopAudio();
                }
                handler.setBackgroundAnimation(cur - 1);
            }
            if (action.equalsIgnoreCase("nextbackground") && (handler = MenuHandlerRegistry.getLastActiveHandler()) != null && (cur = handler.getCurrentBackgroundAnimationId()) < handler.backgroundAnimations().size() - 1) {
                for (IAnimationRenderer an : handler.backgroundAnimations()) {
                    if (!(an instanceof AdvancedAnimation)) continue;
                    ((AdvancedAnimation)an).stopAudio();
                }
                handler.setBackgroundAnimation(cur + 1);
            }
            if (action.equalsIgnoreCase("opencustomgui") && CustomGuiLoader.guiExists(value)) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)CustomGuiLoader.getGui(value, Minecraft.func_71410_x().field_71462_r, null));
            }
            if (action.equalsIgnoreCase("opengui")) {
                GuiScreen s = GuiConstructor.tryToConstruct(value);
                if (s != null) {
                    Minecraft.func_71410_x().func_147108_a(s);
                } else {
                    PopupHandler.displayPopup((Popup)new NotificationPopup(300, new Color(0, 0, 0, 0), 240, null, new String[]{Locals.localize((String)"custombuttons.action.opengui.cannotopengui", (String[])new String[0])}));
                }
            }
            if (action.equalsIgnoreCase("movefile") && value.contains(";")) {
                from = ButtonScriptEngine.cleanPath(value.split("[;]", 2)[0]);
                String to = ButtonScriptEngine.cleanPath(value.split("[;]", 2)[1]);
                toFile = new File(to);
                fromFile = new File(from);
                FileUtils.moveFile((File)fromFile, (File)toFile);
            }
            if (action.equalsIgnoreCase("copyfile") && value.contains(";")) {
                from = ButtonScriptEngine.cleanPath(value.split("[;]", 2)[0]);
                String to = ButtonScriptEngine.cleanPath(value.split("[;]", 2)[1]);
                toFile = new File(to);
                fromFile = new File(from);
                FileUtils.copyFile((File)fromFile, (File)toFile);
            }
            if (action.equalsIgnoreCase("deletefile") && (f2 = new File(ButtonScriptEngine.cleanPath(value))).exists() && f2.delete()) {
                for (int i = 0; f2.exists() && i < 100; ++i) {
                    Thread.sleep(100L);
                }
            }
            if (action.equalsIgnoreCase("renamefile") && value.contains(";")) {
                String path = ButtonScriptEngine.cleanPath(value.split("[;]", 2)[0]);
                String name = value.split("[;]", 2)[1];
                f = new File(path);
                if (f.exists()) {
                    String parent = f.getParent();
                    if (parent != null) {
                        f.renameTo(new File(parent + "/" + name));
                    } else {
                        f.renameTo(new File(name));
                    }
                }
            }
            if (action.equalsIgnoreCase("downloadfile") && value.contains(";")) {
                String url = ButtonScriptEngine.cleanPath(value.split("[;]", 2)[0]);
                String path = ButtonScriptEngine.cleanPath(value.split("[;]", 2)[1]);
                f = new File(path);
                if (!f.exists()) {
                    f.mkdirs();
                }
                InputStream in = new URL(url).openStream();
                Files.copy(in, Paths.get(new File(path).toURI()), StandardCopyOption.REPLACE_EXISTING);
            }
            if (action.equalsIgnoreCase("unpackzip") && value.contains(";")) {
                String zipPath = ButtonScriptEngine.cleanPath(value.split("[;]", 2)[0]);
                String outputDir = ButtonScriptEngine.cleanPath(value.split("[;]", 2)[1]);
                FileUtils.unpackZip((String)zipPath, (String)outputDir);
            }
            if (action.equalsIgnoreCase("reloadmenu")) {
                CustomizationHelper.getInstance().onReloadButtonPress();
            }
            if (action.equalsIgnoreCase("runscript") && scripts.containsKey(value)) {
                ButtonScriptEngine.runButtonScript(value);
            }
            if (action.equalsIgnoreCase("mutebackgroundsounds") && value != null) {
                if (value.equalsIgnoreCase("true")) {
                    FancyMenu.config.setValue("playbackgroundsounds", Boolean.valueOf(false));
                    MenuCustomization.stopSounds();
                }
                if (value.equalsIgnoreCase("false")) {
                    FancyMenu.config.setValue("playbackgroundsounds", Boolean.valueOf(true));
                    CustomizationHelper.getInstance().onReloadButtonPress();
                }
            }
        }
        catch (Exception e) {
            System.out.println("################ ERROR [FANCYMENU] ################");
            System.out.println("An error happened while trying to execute a button action!");
            System.out.println("Action: " + action);
            System.out.println("Value: " + value);
            System.out.println("###################################################");
            e.printStackTrace();
        }
    }

    private static void openWebLink(String url) {
        try {
            String s = System.getProperty("os.name").toLowerCase(Locale.ROOT);
            URL u = new URL(url);
            if (!Minecraft.field_142025_a) {
                if (s.contains("win")) {
                    Runtime.getRuntime().exec(new String[]{"rundll32", "url.dll,FileProtocolHandler", url});
                } else {
                    if (u.getProtocol().equals("file")) {
                        url = url.replace("file:", "file://");
                    }
                    Runtime.getRuntime().exec(new String[]{"xdg-open", url});
                }
            } else {
                Runtime.getRuntime().exec(new String[]{"open", url});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void openFile(File f) {
        try {
            ButtonScriptEngine.openWebLink(f.toURI().toURL().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String cleanPath(String path) {
        int i = 0;
        for (char c : path.toCharArray()) {
            if (c != " ".charAt(0)) break;
            ++i;
        }
        if (i <= path.length()) {
            return path.substring(i).replace("\\", "/");
        }
        return "";
    }

    @SubscribeEvent
    public void onMenuReload(MenuReloadedEvent e) {
        ButtonScriptEngine.updateButtonScripts();
    }

    public static class ButtonScript {
        public final File script;
        public final List<String> actions = new ArrayList<String>();
        public final List<String> values = new ArrayList<String>();

        public ButtonScript(File script) {
            this.script = script;
            for (String s : FileUtils.getFileLines((File)script)) {
                String action = "";
                String value = "";
                if (s.contains(":")) {
                    action = s.split("[:]", 2)[0].replace(" ", "");
                    value = s.split("[:]", 2)[1];
                } else {
                    action = s.replace(" ", "");
                }
                this.actions.add(action);
                this.values.add(value);
            }
        }

        public void runScript() {
            if (!this.actions.isEmpty()) {
                for (int i = 0; i <= this.actions.size() - 1; ++i) {
                    ButtonScriptEngine.runButtonAction(this.actions.get(i), this.values.get(i));
                }
            }
        }
    }
}

