/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.button.ButtonCache;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomizationEvents;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomizationProperties;
import de.keksuccino.fancymenu.menu.fancy.helper.CustomizationHelper;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerEvents;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerRegistry;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.custom.DummyCoreMainHandler;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.custom.LanguageMenuHandler;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.custom.MainMenuHandler;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.custom.MoreRefinedStorageMainHandler;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.custom.controls.ControlsMenuHandler;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.custom.serverselection.ServerSelectionMenuHandler;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.custom.videosettings.VideoSettingsMenuHandler;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.custom.worldselection.WorldSelectionMenuHandler;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSerializer;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.sound.SoundHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenRealmsProxy;
import net.minecraftforge.client.gui.NotificationModUpdateScreen;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class MenuCustomization {
    private static boolean initDone = false;
    private static List<String> sounds = new ArrayList<String>();
    private static Map<String, PropertiesSection> excludedmenus = new HashMap<String, PropertiesSection>();
    public static final File EXCLUDED_MENUS_FILE = new File("config/fancymenu/excludedmenus.txt");

    public static void init() {
        if (!initDone) {
            MinecraftForge.EVENT_BUS.register((Object)new MenuCustomizationEvents());
            MenuHandlerRegistry.registerHandler(new MainMenuHandler());
            MenuHandlerRegistry.registerHandler(new MoreRefinedStorageMainHandler());
            MenuHandlerRegistry.registerHandler(new DummyCoreMainHandler());
            if (!((Boolean)FancyMenu.config.getOrDefault("softmode", (Object)false)).booleanValue()) {
                MenuHandlerRegistry.registerHandler(new WorldSelectionMenuHandler());
                MenuHandlerRegistry.registerHandler(new ServerSelectionMenuHandler());
                MenuHandlerRegistry.registerHandler(new ControlsMenuHandler());
                MenuHandlerRegistry.registerHandler(new LanguageMenuHandler());
                MenuHandlerRegistry.registerHandler(new VideoSettingsMenuHandler());
            }
            MinecraftForge.EVENT_BUS.register((Object)new MenuHandlerEvents());
            CustomizationHelper.init();
            MinecraftForge.EVENT_BUS.register((Object)new ButtonCache());
            MenuCustomizationProperties.loadProperties();
            MenuCustomization.reloadExcludedMenus();
            initDone = true;
        }
    }

    public static void reload() {
        if (initDone) {
            MenuCustomizationProperties.loadProperties();
        }
    }

    public static boolean isValidScreen(GuiScreen screen) {
        if (screen == null) {
            return false;
        }
        if (screen instanceof NotificationModUpdateScreen) {
            return false;
        }
        return !(screen instanceof GuiScreenRealmsProxy);
    }

    public static void registerSound(String key, String path) {
        if (!sounds.contains(key)) {
            sounds.add(key);
        }
        SoundHandler.registerSound((String)key, (String)path);
    }

    public static void unregisterSound(String key) {
        if (sounds.contains(key)) {
            sounds.remove(key);
        }
        SoundHandler.unregisterSound((String)key);
    }

    public static void stopSounds() {
        for (String s : sounds) {
            SoundHandler.stopSound((String)s);
        }
    }

    public static void resetSounds() {
        for (String s : sounds) {
            SoundHandler.resetSound((String)s);
        }
    }

    public static boolean isSoundRegistered(String key) {
        return sounds.contains(key);
    }

    public static List<String> getSounds() {
        return sounds;
    }

    public static boolean containsCalculations(PropertiesSet properties) {
        for (PropertiesSection s : properties.getPropertiesOfType("customization")) {
            String width = s.getEntryValue("width");
            String height = s.getEntryValue("height");
            String x = s.getEntryValue("x");
            String y = s.getEntryValue("y");
            String posX = s.getEntryValue("posX");
            String posY = s.getEntryValue("posY");
            if (width != null && !MathUtils.isInteger((String)width)) {
                return true;
            }
            if (height != null && !MathUtils.isInteger((String)height)) {
                return true;
            }
            if (x != null && !MathUtils.isInteger((String)x)) {
                return true;
            }
            if (y != null && !MathUtils.isInteger((String)y)) {
                return true;
            }
            if (posX != null && !MathUtils.isInteger((String)posX)) {
                return true;
            }
            if (posY == null || MathUtils.isInteger((String)posY)) continue;
            return true;
        }
        return false;
    }

    public static String convertString(String s) {
        int width = 0;
        int height = 0;
        String playername = "";
        String playeruuid = "";
        String mcversion = "1.12.2";
        if (Minecraft.func_71410_x().field_71439_g != null) {
            playername = Minecraft.func_71410_x().field_71439_g.func_70005_c_();
            playeruuid = Minecraft.func_71410_x().field_71439_g.func_110124_au().toString();
        }
        if (Minecraft.func_71410_x().field_71462_r != null) {
            width = Minecraft.func_71410_x().field_71462_r.field_146294_l;
            height = Minecraft.func_71410_x().field_71462_r.field_146295_m;
        }
        s = StringUtils.convertFormatCodes((String)s, (String)"&", (String)"\u00a7");
        s = s.replace("%guiwidth%", "" + width);
        s = s.replace("%guiheight%", "" + height);
        s = s.replace("%playername%", playername);
        s = s.replace("%playeruuid%", playeruuid);
        s = s.replace("%mcversion%", mcversion);
        s = MenuCustomization.replaceModVersionPlaceolder(s);
        s = s.replace("%loadedmods%", "" + MenuCustomization.getLoadedMods());
        s = s.replace("%totalmods%", "" + MenuCustomization.getTotalMods());
        return s;
    }

    private static String replaceModVersionPlaceolder(String in) {
        try {
            if (in.contains("%version:")) {
                ArrayList<String> l = new ArrayList<String>();
                int index = -1;
                for (int i = 0; i < in.length(); ++i) {
                    String s = "" + in.charAt(i);
                    if (!s.equals("%")) continue;
                    if (index == -1) {
                        index = i;
                        continue;
                    }
                    String sub = in.substring(index, i + 1);
                    if (sub.startsWith("%version:") && sub.endsWith("%")) {
                        l.add(sub);
                    }
                    index = -1;
                }
                for (String s : l) {
                    ModContainer c;
                    String blank;
                    String mod;
                    if (!s.contains(":") || !Loader.isModLoaded((String)(mod = (blank = s.substring(1, s.length() - 1)).split(":", 2)[1])) || (c = MenuCustomization.getModContainerById(mod)) == null) continue;
                    String version = c.getVersion();
                    in = in.replace(s, version);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return in;
    }

    private static ModContainer getModContainerById(String modid) {
        try {
            for (ModContainer c : Loader.instance().getActiveModList()) {
                if (!c.getModId().equals(modid)) continue;
                return c;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static int getTotalMods() {
        try {
            return Loader.instance().getModList().size();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private static int getLoadedMods() {
        try {
            return Loader.instance().getActiveModList().size();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static void reloadExcludedMenus() {
        try {
            excludedmenus.clear();
            PropertiesSet s = PropertiesSerializer.getProperties((String)EXCLUDED_MENUS_FILE.getPath());
            if (s == null) {
                s = new PropertiesSet("excludedmenus");
                PropertiesSection sec = new PropertiesSection("some.example.menu.identifier.to.exclude");
                sec.addEntry("mode", "soft");
                sec.addEntry("startswith", "false");
                s.addProperties(sec);
                PropertiesSerializer.writeProperties((PropertiesSet)s, (String)EXCLUDED_MENUS_FILE.getPath());
            }
            for (PropertiesSection ps : s.getProperties()) {
                String excludefrom = ps.getEntryValue("mode");
                if (excludefrom == null || !excludefrom.equalsIgnoreCase("full") && !excludefrom.equalsIgnoreCase("soft")) continue;
                excludedmenus.put(ps.getSectionType(), ps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addExcludedMenu(String menuIdentifier, ExcludeMode mode, boolean startsWith) {
        MenuCustomization.reloadExcludedMenus();
        MenuCustomization.removeExcludedMenu(menuIdentifier);
        PropertiesSet s = new PropertiesSet("excludedmenus");
        for (PropertiesSection ps : excludedmenus.values()) {
            s.addProperties(ps);
        }
        PropertiesSection sec = new PropertiesSection(menuIdentifier);
        sec.addEntry("mode", mode.getMode());
        sec.addEntry("startswith", "" + startsWith);
        s.addProperties(sec);
        excludedmenus.put(menuIdentifier, sec);
        PropertiesSerializer.writeProperties((PropertiesSet)s, (String)EXCLUDED_MENUS_FILE.getPath());
    }

    public static void removeExcludedMenu(String menuIdentifier) {
        MenuCustomization.reloadExcludedMenus();
        if (excludedmenus.containsKey(menuIdentifier)) {
            excludedmenus.remove(menuIdentifier);
            PropertiesSet s = new PropertiesSet("excludedmenus");
            for (PropertiesSection ps : excludedmenus.values()) {
                s.addProperties(ps);
            }
            PropertiesSerializer.writeProperties((PropertiesSet)s, (String)EXCLUDED_MENUS_FILE.getPath());
        }
    }

    public static PropertiesSection getExcludedMenu(String menuIdentifier) {
        for (PropertiesSection sec : excludedmenus.values()) {
            String startswith = sec.getEntryValue("startswith");
            if (startswith == null) {
                startswith = "false";
            }
            if (!(startswith.equalsIgnoreCase("true") ? menuIdentifier.toLowerCase().startsWith(sec.getSectionType().toLowerCase()) : menuIdentifier.equalsIgnoreCase(sec.getSectionType()))) continue;
            return sec;
        }
        return null;
    }

    public static boolean isExcludedSoft(String menuIdentifier) {
        String s;
        PropertiesSection sec = MenuCustomization.getExcludedMenu(menuIdentifier);
        return sec != null && (s = sec.getEntryValue("mode")) != null && s.equalsIgnoreCase("soft");
    }

    public static boolean isExcludedFull(String menuIdentifier) {
        String s;
        PropertiesSection sec = MenuCustomization.getExcludedMenu(menuIdentifier);
        return sec != null && (s = sec.getEntryValue("mode")) != null && s.equalsIgnoreCase("full");
    }

    public static List<String> getExcludedMenus() {
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(excludedmenus.keySet());
        return l;
    }

    public static enum ExcludeMode {
        FULL("full"),
        SOFT("soft");

        private String s;

        private ExcludeMode(String s) {
            this.s = s;
        }

        public String getMode() {
            return this.s;
        }
    }
}

