/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.button.ButtonCache;
import de.keksuccino.fancymenu.menu.button.ButtonCachedEvent;
import de.keksuccino.fancymenu.menu.button.ButtonData;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomizationProperties;
import de.keksuccino.fancymenu.menu.fancy.gameintro.GameIntroScreen;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiBase;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiLoader;
import de.keksuccino.fancymenu.menu.fancy.helper.CustomizationButton;
import de.keksuccino.fancymenu.menu.fancy.helper.EditLayoutPopup;
import de.keksuccino.fancymenu.menu.fancy.helper.ExcludeMenuPopup;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.CreateCustomGuiPopup;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutCreatorScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.PreloadedLayoutCreatorScreen;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerRegistry;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.PopupMenu;
import de.keksuccino.konkrete.gui.screens.SimpleLoadingScreen;
import de.keksuccino.konkrete.gui.screens.popup.NotificationPopup;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.gui.screens.popup.TextInputPopup;
import de.keksuccino.konkrete.gui.screens.popup.YesNoPopup;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSerializer;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenRealmsProxy;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CustomizationHelper {
    private static CustomizationHelper instance;
    private AdvancedButton dropdownButton;
    private PopupMenu dropdown;
    private PopupMenu overridePopup;
    private PopupMenu customGuisPopup;
    private PopupMenu excludePopup;
    private PopupMenu excludeSubPopup;
    private PopupMenu removeExcludedPopup;
    private ManageCustomGuiPopupMenu manageCustomGuiPopup;
    private boolean showButtonInfo = false;
    private boolean showMenuInfo = false;
    private List<ButtonData> buttons = new ArrayList<ButtonData>();
    private AdvancedButton buttonInfoButton;
    private AdvancedButton menuInfoButton;
    private AdvancedButton reloadButton;
    private AdvancedButton overrideButton;
    private AdvancedButton customGuisButton;
    private AdvancedButton excludeButton;
    private AdvancedButton removeExcludedButton;
    private int tick = 0;
    public GuiScreen current;
    private Color menuinfoBackground = new Color(0, 0, 0, 240);

    public static void init() {
        instance = new CustomizationHelper();
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    public static CustomizationHelper getInstance() {
        return instance;
    }

    @SubscribeEvent
    public void onButtonsCached(ButtonCachedEvent e) {
        this.buttons = e.getButtonDataList();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onInitPost(GuiScreenEvent.InitGuiEvent.Post e) {
        if (this.dropdown != null) {
            this.dropdown.closeMenu();
        }
        MouseInput.unblockVanillaInput((String)"customizationhelper");
        if (!CustomizationHelper.isValidScreen(e.getGui())) {
            return;
        }
        this.current = e.getGui();
        String infoLabel = Locals.localize((String)"helper.button.buttoninfo", (String[])new String[0]);
        if (this.showButtonInfo) {
            infoLabel = "\u00a7a" + Locals.localize((String)"helper.button.buttoninfo", (String[])new String[0]);
        }
        CustomizationButton iButton = new CustomizationButton(5, 5, 70, 20, infoLabel, true, onPress -> this.onInfoButtonPress());
        this.buttonInfoButton = iButton;
        String minfoLabel = Locals.localize((String)"helper.button.menuinfo", (String[])new String[0]);
        if (this.showMenuInfo) {
            minfoLabel = "\u00a7a" + Locals.localize((String)"helper.button.menuinfo", (String[])new String[0]);
        }
        CustomizationButton miButton = new CustomizationButton(80, 5, 70, 20, minfoLabel, true, onPress -> this.onMoreInfoButtonPress());
        this.menuInfoButton = miButton;
        this.reloadButton = new CustomizationButton(e.getGui().field_146294_l - 55, 5, 50, 20, Locals.localize((String)"helper.button.reload", (String[])new String[0]), true, onPress -> this.onReloadButtonPress());
        CustomizationButton layoutCreatorButton = new CustomizationButton(e.getGui().field_146294_l - 150, 5, 90, 20, Locals.localize((String)"helper.button.createlayout", (String[])new String[0]), true, onPress -> {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new LayoutCreatorScreen(this.current));
            LayoutCreatorScreen.isActive = true;
            MenuCustomization.stopSounds();
            MenuCustomization.resetSounds();
            for (IAnimationRenderer r : AnimationHandler.getAnimations()) {
                if (!(r instanceof AdvancedAnimation)) continue;
                ((AdvancedAnimation)r).stopAudio();
                if (!((AdvancedAnimation)r).replayIntro()) continue;
                ((AdvancedAnimation)r).resetAnimation();
            }
        });
        CustomizationButton editLayoutButton = new CustomizationButton(e.getGui().field_146294_l - 245, 5, 90, 20, Locals.localize((String)"helper.creator.editlayout", (String[])new String[0]), true, onPress -> {
            List<PropertiesSet> l;
            String identifier = this.current.getClass().getName();
            if (this.current instanceof CustomGuiBase) {
                identifier = ((CustomGuiBase)this.current).getIdentifier();
            }
            if ((l = MenuCustomizationProperties.getPropertiesWithIdentifier(identifier)).isEmpty()) {
                PopupHandler.displayPopup((Popup)new NotificationPopup(300, new Color(0, 0, 0, 0), 240, null, new String[]{Locals.localize((String)"helper.creator.editlayout.nolayouts.msg", (String[])new String[0])}));
            }
            if (l.size() == 1) {
                if (!MenuCustomization.containsCalculations(l.get(0))) {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new PreloadedLayoutCreatorScreen(this.current, l));
                    LayoutCreatorScreen.isActive = true;
                    MenuCustomization.stopSounds();
                    MenuCustomization.resetSounds();
                    for (IAnimationRenderer r : AnimationHandler.getAnimations()) {
                        if (!(r instanceof AdvancedAnimation)) continue;
                        ((AdvancedAnimation)r).stopAudio();
                        if (!((AdvancedAnimation)r).replayIntro()) continue;
                        ((AdvancedAnimation)r).resetAnimation();
                    }
                } else {
                    PopupHandler.displayPopup((Popup)new NotificationPopup(300, new Color(0, 0, 0, 0), 240, null, new String[]{Locals.localize((String)"helper.creator.editlayout.unsupportedvalues", (String[])new String[0])}));
                }
            }
            if (l.size() > 1) {
                PopupHandler.displayPopup((Popup)new EditLayoutPopup(l));
            }
        });
        String overrLabel = Locals.localize((String)"helper.buttons.tools.overridemenu", (String[])new String[0]);
        if (this.isScreenOverridden()) {
            overrLabel = Locals.localize((String)"helper.buttons.tools.resetoverride", (String[])new String[0]);
        }
        this.overrideButton = new CustomizationButton(e.getGui().field_146294_l - 150, 5, 90, 20, overrLabel, true, onPress -> {
            if (!this.isScreenOverridden()) {
                this.overridePopup = new PopupMenu(100, 20, -1);
                List<String> l = CustomGuiLoader.getCustomGuis();
                if (!l.isEmpty()) {
                    this.overridePopup.addContent((AdvancedButton)new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.buttons.tools.customguis.pickbyname", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new TextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"helper.buttons.tools.customguis.pickbyname", (String[])new String[0]), null, 240, call -> {
                        if (call != null) {
                            if (CustomGuiLoader.guiExists(call)) {
                                this.onOverrideWithCustomGui((String)call);
                            } else {
                                PopupHandler.displayPopup((Popup)new NotificationPopup(300, new Color(0, 0, 0, 0), 240, null, new String[]{Locals.localize((String)"helper.buttons.tools.customguis.invalididentifier", (String[])new String[0])}));
                            }
                        }
                    }))));
                    for (String s : l) {
                        String label = s;
                        if (Minecraft.func_71410_x().field_71466_p.func_78256_a(label) > 80) {
                            label = Minecraft.func_71410_x().field_71466_p.func_78269_a(label, 75) + "..";
                        }
                        this.overridePopup.addContent((AdvancedButton)new CustomizationButton(0, 0, 0, 0, label, true, press -> this.onOverrideWithCustomGui(s)));
                    }
                } else {
                    this.overridePopup.addContent((AdvancedButton)new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.empty", (String[])new String[0]), true, press -> {}));
                }
                this.overridePopup.openMenuAt(onPress.field_146128_h - this.overridePopup.getWidth() - 2, onPress.field_146129_i);
            } else {
                for (String s : FileUtils.getFiles((String)FancyMenu.getCustomizationPath().getPath())) {
                    PropertiesSet props = PropertiesSerializer.getProperties((String)s);
                    if (props == null) continue;
                    PropertiesSet props2 = new PropertiesSet(props.getPropertiesType());
                    List l = props.getProperties();
                    ArrayList<PropertiesSection> l2 = new ArrayList<PropertiesSection>();
                    boolean b = false;
                    List metas = props.getPropertiesOfType("customization-meta");
                    if (metas == null || metas.isEmpty()) {
                        metas = props.getPropertiesOfType("type-meta");
                    }
                    if (metas == null || metas.isEmpty()) continue;
                    String identifier = ((PropertiesSection)metas.get(0)).getEntryValue("identifier");
                    GuiScreen overridden = ((CustomGuiBase)this.current).getOverriddenScreen();
                    if (identifier == null || !identifier.equalsIgnoreCase(overridden.getClass().getName())) continue;
                    for (PropertiesSection sec : l) {
                        String action = sec.getEntryValue("action");
                        if (sec.getSectionType().equalsIgnoreCase("customization-meta") || sec.getSectionType().equalsIgnoreCase("type-meta")) {
                            l2.add(sec);
                            continue;
                        }
                        if (action != null && !action.equalsIgnoreCase("overridemenu")) {
                            l2.add(sec);
                        }
                        if (action == null || !action.equalsIgnoreCase("overridemenu")) continue;
                        b = true;
                    }
                    if (!b) continue;
                    File f = new File(s);
                    if (f.exists() && f.isFile()) {
                        f.delete();
                    }
                    if (l2.size() <= 1) continue;
                    for (PropertiesSection sec : l2) {
                        props2.addProperties(sec);
                    }
                    PropertiesSerializer.writeProperties((PropertiesSet)props2, (String)s);
                }
                this.onReloadButtonPress();
                if (this.current instanceof CustomGuiBase) {
                    Minecraft.func_71410_x().func_147108_a(((CustomGuiBase)this.current).getOverriddenScreen());
                }
            }
        });
        CustomizationButton createGuiButton = new CustomizationButton(e.getGui().field_146294_l - 55, 5, 50, 20, Locals.localize((String)"helper.buttons.tools.creategui", (String[])new String[0]), true, onPress -> PopupHandler.displayPopup((Popup)new CreateCustomGuiPopup()));
        this.manageCustomGuiPopup = new ManageCustomGuiPopupMenu(100, 20, -1);
        this.customGuisPopup = new PopupMenu(100, 20, -1);
        List<String> l = CustomGuiLoader.getCustomGuis();
        if (!l.isEmpty()) {
            this.customGuisPopup.addContent((AdvancedButton)new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.buttons.tools.customguis.openbyname", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new TextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"helper.buttons.tools.customguis.openbyname", (String[])new String[0]), null, 240, call -> {
                if (call != null) {
                    if (CustomGuiLoader.guiExists(call)) {
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)CustomGuiLoader.getGui(call, Minecraft.func_71410_x().field_71462_r, null));
                    } else {
                        PopupHandler.displayPopup((Popup)new NotificationPopup(300, new Color(0, 0, 0, 0), 240, null, new String[]{Locals.localize((String)"helper.buttons.tools.customguis.invalididentifier", (String[])new String[0])}));
                    }
                }
            }))));
            this.customGuisPopup.addContent((AdvancedButton)new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.buttons.tools.customguis.deletebyname", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new TextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"helper.buttons.tools.customguis.deletebyname", (String[])new String[0]), null, 240, call -> {
                if (call != null) {
                    if (CustomGuiLoader.guiExists(call)) {
                        CustomizationHelper.getInstance().dropdown.closeMenu();
                        PopupHandler.displayPopup((Popup)new YesNoPopup(300, new Color(0, 0, 0, 0), 240, call2 -> {
                            if (call2.booleanValue() && CustomGuiLoader.guiExists(call)) {
                                ArrayList<File> delete = new ArrayList<File>();
                                for (String s : FileUtils.getFiles((String)FancyMenu.getCustomGuiPath().getPath())) {
                                    File f = new File(s);
                                    for (String s2 : FileUtils.getFileLines((File)f)) {
                                        if (!s2.replace(" ", "").toLowerCase().equals("identifier=" + call)) continue;
                                        delete.add(f);
                                    }
                                }
                                for (File f : delete) {
                                    if (!f.isFile()) continue;
                                    f.delete();
                                }
                                CustomizationHelper.getInstance().onReloadButtonPress();
                            }
                        }, new String[]{Locals.localize((String)"helper.buttons.tools.customguis.sure", (String[])new String[0])}));
                    } else {
                        PopupHandler.displayPopup((Popup)new NotificationPopup(300, new Color(0, 0, 0, 0), 240, null, new String[]{Locals.localize((String)"helper.buttons.tools.customguis.invalididentifier", (String[])new String[0])}));
                    }
                }
            }))));
            for (String s : l) {
                String label = s;
                if (Minecraft.func_71410_x().field_71466_p.func_78256_a(label) > 80) {
                    label = Minecraft.func_71410_x().field_71466_p.func_78269_a(label, 75) + "..";
                }
                this.customGuisPopup.addContent((AdvancedButton)new CustomizationButton(0, 0, 0, 0, label, true, press -> this.manageCustomGuiPopup.openMenuAt(press.field_146128_h - this.manageCustomGuiPopup.getWidth() - 2, press.field_146129_i, s)));
            }
        } else {
            this.customGuisPopup.addContent((AdvancedButton)new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.empty", (String[])new String[0]), true, press -> {}));
        }
        this.customGuisButton = new CustomizationButton(e.getGui().field_146294_l - 55, 5, 50, 20, Locals.localize((String)"helper.buttons.tools.customguis", (String[])new String[0]), true, press -> {
            this.customGuisPopup.openMenuAt(press.field_146128_h - this.customGuisPopup.getWidth() - 2, press.field_146129_i);
            this.excludePopup.closeMenu();
        });
        CustomizationButton closeCustomGuiButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.buttons.tools.closecustomgui", (String[])new String[0]), press -> {
            if (e.getGui() instanceof CustomGuiBase) {
                ((CustomGuiBase)e.getGui()).onClose();
            }
        });
        this.excludePopup = new PopupMenu(120, 20, -1);
        CustomizationButton excludeSoftBtn = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.excludemenu.soft", (String[])new String[0]), true, press -> {
            this.buildSubExcludePopup(MenuCustomization.ExcludeMode.SOFT);
            this.excludeSubPopup.openMenuAt(press.field_146128_h - this.excludeSubPopup.getWidth() - 2, press.field_146129_i);
        });
        this.excludePopup.addContent((AdvancedButton)excludeSoftBtn);
        CustomizationButton excludeFullBtn = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.excludemenu.full", (String[])new String[0]), true, press -> {
            this.buildSubExcludePopup(MenuCustomization.ExcludeMode.FULL);
            this.excludeSubPopup.openMenuAt(press.field_146128_h - this.excludeSubPopup.getWidth() - 2, press.field_146129_i);
        });
        this.excludePopup.addContent((AdvancedButton)excludeFullBtn);
        this.excludeButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.excludemenu", (String[])new String[0]), true, press -> {
            this.excludePopup.openMenuAt(press.field_146128_h - this.excludePopup.getWidth() - 2, press.field_146129_i);
            this.customGuisPopup.closeMenu();
        });
        this.removeExcludedButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.excludemenu.remove", (String[])new String[0]), true, press -> {
            MenuCustomization.reloadExcludedMenus();
            this.buildRemoveExcludedPopup();
            this.removeExcludedPopup.openMenuAt(press.field_146128_h - this.removeExcludedPopup.getWidth() - 2, press.field_146129_i);
        });
        this.dropdown = new PopupMenu(100, 20, -1);
        this.dropdown.addContent((AdvancedButton)iButton);
        this.dropdown.addContent((AdvancedButton)miButton);
        this.dropdown.addContent((AdvancedButton)createGuiButton);
        this.dropdown.addContent(this.customGuisButton);
        this.dropdown.addContent((AdvancedButton)layoutCreatorButton);
        this.dropdown.addContent((AdvancedButton)editLayoutButton);
        this.dropdown.addContent(this.excludeButton);
        this.dropdown.addContent(this.removeExcludedButton);
        if (this.isScreenOverridden()) {
            this.dropdown.addContent(this.overrideButton);
        } else if (!(e.getGui() instanceof CustomGuiBase)) {
            this.dropdown.addContent(this.overrideButton);
        } else {
            this.dropdown.addContent((AdvancedButton)closeCustomGuiButton);
        }
        this.dropdownButton = new CustomizationButton(e.getGui().field_146294_l - 160, 5, 100, 20, Locals.localize((String)"helper.buttons.tools.dropdownlabel", (String[])new String[0]), true, press -> {
            if (!this.dropdown.isOpen()) {
                this.dropdown.openMenuAt(press.field_146128_h, press.field_146129_i + press.field_146121_g - 1);
            } else {
                this.dropdown.closeMenu();
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderPost(GuiScreenEvent.DrawScreenEvent.Post e) {
        if (PopupHandler.isPopupActive()) {
            return;
        }
        if (!CustomizationHelper.isValidScreen(e.getGui())) {
            return;
        }
        if (((Boolean)FancyMenu.config.getOrDefault("showcustomizationbuttons", (Object)true)).booleanValue()) {
            this.dropdownButton.func_191745_a(Minecraft.func_71410_x(), e.getMouseX(), e.getMouseY(), e.getRenderPartialTicks());
            this.reloadButton.func_191745_a(Minecraft.func_71410_x(), e.getMouseX(), e.getMouseY(), e.getRenderPartialTicks());
            this.dropdown.render(e.getMouseX(), e.getMouseY());
            if (this.dropdown.isOpen()) {
                MouseInput.blockVanillaInput((String)"customizationhelper");
            } else {
                MouseInput.unblockVanillaInput((String)"customizationhelper");
            }
            if (!(!this.dropdown.isOpen() || this.customGuisPopup.isHovered() || this.excludePopup.isHovered() || this.dropdownButton.func_146115_a() || this.dropdown.isHovered() || !MouseInput.isLeftMouseDown() && !MouseInput.isRightMouseDown())) {
                this.dropdown.closeMenu();
            }
            if (this.overridePopup != null) {
                this.overridePopup.render(e.getMouseX(), e.getMouseY());
                if (this.overridePopup.isOpen() && !this.overrideButton.func_146115_a() && !this.overridePopup.isHovered() && (MouseInput.isLeftMouseDown() || MouseInput.isRightMouseDown())) {
                    this.overridePopup.closeMenu();
                }
                if (!this.dropdown.isOpen()) {
                    this.overridePopup.closeMenu();
                }
            }
            if (this.customGuisPopup != null) {
                this.customGuisPopup.render(e.getMouseX(), e.getMouseY());
                if (this.customGuisPopup.isOpen() && !this.customGuisButton.func_146115_a() && !this.customGuisPopup.isHovered() && (MouseInput.isLeftMouseDown() || MouseInput.isRightMouseDown())) {
                    this.customGuisPopup.closeMenu();
                }
                if (!this.dropdown.isOpen()) {
                    this.customGuisPopup.closeMenu();
                }
                if (this.manageCustomGuiPopup != null) {
                    this.manageCustomGuiPopup.render(e.getMouseX(), e.getMouseY());
                    if (!this.customGuisPopup.isOpen()) {
                        this.manageCustomGuiPopup.closeMenu();
                    }
                }
            }
            if (this.excludePopup != null) {
                this.excludePopup.render(e.getMouseX(), e.getMouseY());
                if (this.excludePopup.isOpen() && !this.excludePopup.isHovered() && !this.excludeButton.func_146115_a() && (MouseInput.isLeftMouseDown() || MouseInput.isRightMouseDown())) {
                    this.excludePopup.closeMenu();
                }
                if (!this.dropdown.isOpen()) {
                    this.excludePopup.closeMenu();
                }
                if (this.excludeSubPopup != null) {
                    this.excludeSubPopup.render(e.getMouseX(), e.getMouseY());
                    if (!this.excludePopup.isOpen()) {
                        this.excludeSubPopup.closeMenu();
                    }
                }
            }
            if (this.removeExcludedPopup != null) {
                this.removeExcludedPopup.render(e.getMouseX(), e.getMouseY());
                if (this.removeExcludedPopup.isOpen() && !this.removeExcludedPopup.isHovered() && !this.removeExcludedButton.func_146115_a() && (MouseInput.isLeftMouseDown() || MouseInput.isRightMouseDown())) {
                    this.removeExcludedPopup.closeMenu();
                }
                if (!this.dropdown.isOpen()) {
                    this.removeExcludedPopup.closeMenu();
                }
            }
        }
        if (this.showMenuInfo && !(e.getGui() instanceof LayoutCreatorScreen)) {
            String infoTitle = "\u00a7f\u00a7l" + Locals.localize((String)"helper.menuinfo.identifier", (String[])new String[0]) + ":";
            String id = "";
            id = e.getGui() instanceof CustomGuiBase ? ((CustomGuiBase)e.getGui()).getIdentifier() : e.getGui().getClass().getName();
            int w = Minecraft.func_71410_x().field_71466_p.func_78256_a(infoTitle);
            int w2 = Minecraft.func_71410_x().field_71466_p.func_78256_a(id);
            if (w2 > w) {
                w = w2;
            }
            GlStateManager.func_179147_l();
            Gui.func_73734_a((int)3, (int)3, (int)(3 + w + 4), (int)25, (int)this.menuinfoBackground.getRGB());
            e.getGui().func_73731_b(Minecraft.func_71410_x().field_71466_p, infoTitle, 5, 5, 0);
            if (this.tick == 0) {
                e.getGui().func_73731_b(Minecraft.func_71410_x().field_71466_p, "\u00a7f" + id, 5, 15, 0);
            } else {
                e.getGui().func_73731_b(Minecraft.func_71410_x().field_71466_p, "\u00a7a" + Locals.localize((String)"helper.menuinfo.idcopied", (String[])new String[0]), 5, 15, 0);
            }
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            if (mouseX >= 5 && mouseX <= 5 + w2 && mouseY >= 15 && mouseY <= 25 && this.tick == 0) {
                Gui.func_73734_a((int)5, (int)24, (int)(5 + w2), (int)25, (int)-1);
                if (MouseInput.isLeftMouseDown()) {
                    ++this.tick;
                    GuiScreen.func_146275_d((String)id);
                }
            }
            if (this.tick > 0) {
                this.tick = this.tick < 60 ? ++this.tick : 0;
            }
            GlStateManager.func_179084_k();
        }
        if (this.showButtonInfo) {
            for (ButtonData d : this.buttons) {
                int y;
                String key;
                if (!d.getButton().func_146115_a()) continue;
                long id = d.getId();
                String idString = Locals.localize((String)"helper.buttoninfo.idnotfound", (String[])new String[0]);
                if (id >= 0L) {
                    idString = String.valueOf(id);
                }
                if ((key = ButtonCache.getKeyForButton(d.getButton())) == null) {
                    key = Locals.localize((String)"helper.buttoninfo.keynotfound", (String[])new String[0]);
                }
                ArrayList<String> info = new ArrayList<String>();
                int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(Locals.localize((String)"helper.button.buttoninfo", (String[])new String[0])) + 10;
                info.add("\u00a7f" + Locals.localize((String)"helper.buttoninfo.id", (String[])new String[0]) + ": " + idString);
                info.add("\u00a7f" + Locals.localize((String)"helper.buttoninfo.key", (String[])new String[0]) + ": " + key);
                info.add("\u00a7f" + Locals.localize((String)"general.width", (String[])new String[0]) + ": " + d.getButton().field_146120_f);
                info.add("\u00a7f" + Locals.localize((String)"general.height", (String[])new String[0]) + ": " + d.getButton().field_146121_g);
                info.add("\u00a7f" + Locals.localize((String)"helper.buttoninfo.labelwidth", (String[])new String[0]) + ": " + Minecraft.func_71410_x().field_71466_p.func_78256_a(d.getButton().field_146126_j));
                for (String s : info) {
                    int i = Minecraft.func_71410_x().field_71466_p.func_78256_a(s) + 10;
                    if (i <= width) continue;
                    width = i;
                }
                int x = e.getMouseX();
                if (e.getGui().field_146294_l < x + width + 10) {
                    x -= width + 10;
                }
                if (e.getGui().field_146295_m < (y = e.getMouseY()) + 90) {
                    y -= 90;
                }
                CustomizationHelper.drawInfoBackground(x, y, width + 10, 90);
                GlStateManager.func_179147_l();
                e.getGui().func_73731_b(Minecraft.func_71410_x().field_71466_p, "\u00a7f\u00a7l" + Locals.localize((String)"helper.button.buttoninfo", (String[])new String[0]), x + 10, y + 10, 0);
                int i2 = 20;
                for (String s : info) {
                    e.getGui().func_73731_b(Minecraft.func_71410_x().field_71466_p, s, x + 10, y + 10 + i2, 0);
                    i2 += 10;
                }
                GlStateManager.func_179084_k();
                break;
            }
        }
    }

    private void buildSubExcludePopup(MenuCustomization.ExcludeMode m) {
        this.excludeSubPopup = new PopupMenu(120, 20, -1);
        CustomizationButton currentBtn = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.excludemenu.current", (String[])new String[0]), true, press -> {
            MenuCustomization.addExcludedMenu(Minecraft.func_71410_x().field_71462_r.getClass().getName(), m, false);
            this.onReloadButtonPress();
        });
        this.excludeSubPopup.addContent((AdvancedButton)currentBtn);
        CustomizationButton byIdentifierBtn = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.excludemenu.byidentifier", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new ExcludeMenuPopup(m)));
        this.excludeSubPopup.addContent((AdvancedButton)byIdentifierBtn);
    }

    private void buildRemoveExcludedPopup() {
        int i = 120;
        List<String> l = MenuCustomization.getExcludedMenus();
        for (String s : l) {
            int i2 = Minecraft.func_71410_x().field_71466_p.func_78256_a(s);
            if (i2 <= i) continue;
            i = i2;
        }
        this.removeExcludedPopup = new PopupMenu(i + 5, 20, -1);
        if (l.isEmpty()) {
            CustomizationButton b = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.empty", (String[])new String[0]), true, press -> {});
            this.removeExcludedPopup.addContent((AdvancedButton)b);
        } else {
            for (String s : l) {
                CustomizationButton b = new CustomizationButton(0, 0, 0, 0, s, true, press -> {
                    MenuCustomization.removeExcludedMenu(s);
                    this.onReloadButtonPress();
                });
                this.removeExcludedPopup.addContent((AdvancedButton)b);
            }
        }
    }

    private static boolean isValidScreen(GuiScreen s) {
        if (s != Minecraft.func_71410_x().field_71462_r) {
            return false;
        }
        if (s instanceof GuiScreenRealmsProxy) {
            return false;
        }
        if (s instanceof SimpleLoadingScreen) {
            return false;
        }
        if (s instanceof GameIntroScreen) {
            return false;
        }
        return !(s instanceof LayoutCreatorScreen);
    }

    private static void drawInfoBackground(int x, int y, int width, int height) {
        GuiScreen.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)new Color(102, 0, 102, 200).getRGB());
    }

    public void updateCustomizationButtons() {
        GuiScreen current = Minecraft.func_71410_x().field_71462_r;
        if (current != null) {
            Minecraft.func_71410_x().func_147108_a(current);
        }
    }

    public void onInfoButtonPress() {
        if (this.showButtonInfo) {
            this.showButtonInfo = false;
            this.buttonInfoButton.field_146126_j = Locals.localize((String)"helper.button.buttoninfo", (String[])new String[0]);
        } else {
            this.showButtonInfo = true;
            this.buttonInfoButton.field_146126_j = "\u00a7a" + Locals.localize((String)"helper.button.buttoninfo", (String[])new String[0]);
        }
    }

    public void onMoreInfoButtonPress() {
        if (this.showMenuInfo) {
            this.showMenuInfo = false;
            this.menuInfoButton.field_146126_j = Locals.localize((String)"helper.button.menuinfo", (String[])new String[0]);
        } else {
            this.showMenuInfo = true;
            this.menuInfoButton.field_146126_j = "\u00a7a" + Locals.localize((String)"helper.button.menuinfo", (String[])new String[0]);
        }
    }

    public void onReloadButtonPress() {
        FancyMenu.updateConfig();
        MenuCustomization.resetSounds();
        MenuCustomization.reload();
        MenuHandlerRegistry.setActiveHandler(null);
        CustomGuiLoader.loadCustomGuis();
        if (!((Boolean)FancyMenu.config.getOrDefault("showcustomizationbuttons", (Object)true)).booleanValue()) {
            this.showButtonInfo = false;
            this.showMenuInfo = false;
        }
        MinecraftForge.EVENT_BUS.post((Event)new MenuReloadedEvent(Minecraft.func_71410_x().field_71462_r));
        try {
            Minecraft.func_71410_x().func_147108_a(Minecraft.func_71410_x().field_71462_r);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isScreenOverridden() {
        return this.current != null && this.current instanceof CustomGuiBase && ((CustomGuiBase)this.current).getOverriddenScreen() != null;
    }

    private void onOverrideWithCustomGui(String customGuiIdentifier) {
        if (customGuiIdentifier != null && CustomGuiLoader.guiExists(customGuiIdentifier)) {
            PropertiesSection meta = new PropertiesSection("customization-meta");
            meta.addEntry("identifier", this.current.getClass().getName());
            PropertiesSection or = new PropertiesSection("customization");
            or.addEntry("action", "overridemenu");
            or.addEntry("identifier", customGuiIdentifier);
            PropertiesSet props = new PropertiesSet("menu");
            props.addProperties(meta);
            props.addProperties(or);
            String screenname = this.current.getClass().getName();
            if (screenname.contains(".")) {
                screenname = new StringBuilder(new StringBuilder(screenname).reverse().toString().split("[.]", 2)[0]).reverse().toString();
            }
            String filename = FileUtils.generateAvailableFilename((String)FancyMenu.getCustomizationPath().getPath(), (String)("overridemenu_" + screenname), (String)"txt");
            String finalpath = FancyMenu.getCustomizationPath().getPath() + "/" + filename;
            PropertiesSerializer.writeProperties((PropertiesSet)props, (String)finalpath);
            this.onReloadButtonPress();
        }
    }

    private static class ManageCustomGuiPopupMenu
    extends PopupMenu {
        public ManageCustomGuiPopupMenu(int width, int buttonHeight, int space) {
            super(width, buttonHeight, space);
        }

        public void openMenuAt(int x, int y, String customGuiIdentifier) {
            this.content.clear();
            CustomizationButton openMenuButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.buttons.tools.customguis.open", (String[])new String[0]), press -> {
                if (CustomGuiLoader.guiExists(customGuiIdentifier)) {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)CustomGuiLoader.getGui(customGuiIdentifier, Minecraft.func_71410_x().field_71462_r, null));
                }
            });
            this.addContent(openMenuButton);
            CustomizationButton deleteMenuButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.buttons.tools.customguis.delete", (String[])new String[0]), press -> {
                CustomizationHelper.getInstance().dropdown.closeMenu();
                PopupHandler.displayPopup((Popup)new YesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                    if (call.booleanValue() && CustomGuiLoader.guiExists(customGuiIdentifier)) {
                        ArrayList<File> delete = new ArrayList<File>();
                        for (String s : FileUtils.getFiles((String)FancyMenu.getCustomGuiPath().getPath())) {
                            File f = new File(s);
                            for (String s2 : FileUtils.getFileLines((File)f)) {
                                if (!s2.replace(" ", "").toLowerCase().equals("identifier=" + customGuiIdentifier)) continue;
                                delete.add(f);
                            }
                        }
                        for (File f : delete) {
                            if (!f.isFile()) continue;
                            f.delete();
                        }
                        CustomizationHelper.getInstance().onReloadButtonPress();
                    }
                }, new String[]{Locals.localize((String)"helper.buttons.tools.customguis.sure", (String[])new String[0])}));
            });
            this.addContent(deleteMenuButton);
            this.openMenuAt(x, y);
        }
    }
}

