/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutCreatorScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.PreloadedLayoutCreatorScreen;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedImageButton;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;

public class EditHistory {
    private static final ResourceLocation BACK = new ResourceLocation("keksuccino", "arrow_left.png");
    private static final ResourceLocation FORWARD = new ResourceLocation("keksuccino", "arrow_right.png");
    private LayoutCreatorScreen editor;
    private List<Snapshot> history = new ArrayList<Snapshot>();
    private int current = -1;
    private AdvancedButton backBtn;
    private AdvancedButton forwardBtn;

    public EditHistory(LayoutCreatorScreen editor) {
        this.editor = editor;
        this.backBtn = new AdvancedImageButton(10, 10, 20, 20, BACK, true, press -> this.stepBack());
        LayoutCreatorScreen.colorizeCreatorButton(this.backBtn);
        this.forwardBtn = new AdvancedImageButton(35, 10, 20, 20, FORWARD, true, press -> this.stepForward());
        LayoutCreatorScreen.colorizeCreatorButton(this.forwardBtn);
        KeyboardHandler.addKeyPressedListener(this::onCtrlAltZCtrlAltY);
    }

    public void saveSnapshot(Snapshot snap) {
        if (this.current < 0) {
            this.history.clear();
            this.history.add(snap);
            this.current = 0;
        } else if (this.current <= this.history.size() - 1) {
            ArrayList<Snapshot> l = new ArrayList<Snapshot>();
            for (int i = 0; i <= this.current; ++i) {
                l.add(this.history.get(i));
            }
            l.add(snap);
            this.history = l;
            this.current = this.history.size() - 1;
        } else {
            this.current = this.history.size() - 1;
            this.saveSnapshot(snap);
        }
    }

    public Snapshot createSnapshot(Runnable onSnapshotRestore) {
        return new Snapshot(this.editor, onSnapshotRestore);
    }

    public Snapshot createSnapshot() {
        return new Snapshot(this.editor, null);
    }

    public void stepBack() {
        if (this.current > -1 && this.current <= this.history.size() - 1) {
            Snapshot snap = this.history.get(this.current);
            ArrayList<PropertiesSet> l = new ArrayList<PropertiesSet>();
            l.add(snap.snapshot);
            --this.current;
            snap.preSnapshotState = this.createSnapshot();
            PreloadedLayoutCreatorScreen neweditor = new PreloadedLayoutCreatorScreen(this.editor.screen, l);
            neweditor.history = this;
            String single = null;
            if (this.editor instanceof PreloadedLayoutCreatorScreen) {
                single = ((PreloadedLayoutCreatorScreen)this.editor).single;
            }
            neweditor.single = single;
            neweditor.expanded = this.editor.expanded;
            this.editor = neweditor;
            Minecraft.func_71410_x().func_147108_a((GuiScreen)neweditor);
        }
    }

    public void stepForward() {
        if (this.current >= -1 && this.current < this.history.size() - 1) {
            ++this.current;
            Snapshot snap = this.history.get((int)this.current).preSnapshotState;
            if (snap != null) {
                ArrayList<PropertiesSet> l = new ArrayList<PropertiesSet>();
                l.add(snap.snapshot);
                PreloadedLayoutCreatorScreen neweditor = new PreloadedLayoutCreatorScreen(this.editor.screen, l);
                neweditor.history = this;
                String single = null;
                if (this.editor instanceof PreloadedLayoutCreatorScreen) {
                    single = ((PreloadedLayoutCreatorScreen)this.editor).single;
                }
                neweditor.single = single;
                neweditor.expanded = this.editor.expanded;
                this.editor = neweditor;
                Minecraft.func_71410_x().func_147108_a((GuiScreen)neweditor);
            }
        }
    }

    public void render() {
        if (((Boolean)FancyMenu.config.getOrDefault("showundoredocontrols", (Object)false)).booleanValue()) {
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            float partial = Minecraft.func_71410_x().func_184121_ak();
            this.backBtn.func_191745_a(Minecraft.func_71410_x(), mouseX, mouseY, partial);
            this.forwardBtn.func_191745_a(Minecraft.func_71410_x(), mouseX, mouseY, partial);
        }
    }

    private void onCtrlAltZCtrlAltY(KeyboardData d) {
        if (KeyboardHandler.isCtrlPressed() && KeyboardHandler.isAltPressed() && this.editor == Minecraft.func_71410_x().field_71462_r) {
            if (d.keycode == 44) {
                this.stepBack();
            }
            if (d.keycode == 21) {
                this.stepForward();
            }
        }
    }

    public static class Snapshot {
        public PropertiesSet snapshot = new PropertiesSet("menu");
        public Snapshot preSnapshotState = null;
        private Runnable run;

        public Snapshot(LayoutCreatorScreen editor, @Nullable Runnable onSnapshotRestore) {
            this.run = onSnapshotRestore;
            for (PropertiesSection s : editor.getAllProperties()) {
                this.snapshot.addProperties(s);
            }
        }

        public void runSnapshotActions() {
            if (this.run != null) {
                this.run.run();
            }
        }
    }
}

