/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content;

import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.EditHistory;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutCreatorScreen;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.IMenu;
import de.keksuccino.konkrete.gui.content.PopupMenu;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.gui.screens.popup.YesNoPopup;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;

public abstract class LayoutObject
extends Gui {
    public final CustomizationItemBase object;
    protected LayoutCreatorScreen handler;
    protected boolean hovered = false;
    protected boolean dragging = false;
    protected boolean resizing = false;
    protected int activeGrabber = -1;
    protected int lastGrabber;
    protected int startDiffX;
    protected int startDiffY;
    protected int startX;
    protected int startY;
    protected int startWidth;
    protected int startHeight;
    protected int orientationDiffX = 0;
    protected int orientationDiffY = 0;
    protected List<LayoutObject> hoveredLayers = new ArrayList<LayoutObject>();
    protected PopupMenu rightclickMenu;
    protected PopupMenu orientationMenu;
    protected AdvancedButton orientationButton;
    protected PopupMenu layersPopup;
    protected AdvancedButton layersButton;
    protected static boolean isShiftPressed = false;
    private static boolean shiftListener = false;
    private final boolean destroyable;
    public final String objectId = UUID.randomUUID().toString();
    private EditHistory.Snapshot cachedSnapshot;
    private boolean moving = false;

    public LayoutObject(@Nonnull CustomizationItemBase object, boolean destroyable, @Nonnull LayoutCreatorScreen handler) {
        this.handler = handler;
        this.object = object;
        this.destroyable = destroyable;
        if (!shiftListener) {
            KeyboardHandler.addKeyPressedListener((Consumer)new Consumer<KeyboardData>(){

                @Override
                public void accept(KeyboardData t) {
                    if (t.keycode == 42 || t.keycode == 54) {
                        isShiftPressed = true;
                    }
                }
            });
            KeyboardHandler.addKeyReleasedListener((Consumer)new Consumer<KeyboardData>(){

                @Override
                public void accept(KeyboardData t) {
                    if (t.keycode == 42 || t.keycode == 54) {
                        isShiftPressed = false;
                    }
                }
            });
            shiftListener = true;
        }
        this.init();
    }

    protected void init() {
        AdvancedButton o1 = new AdvancedButton(0, 0, 0, 16, "top-left", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("top-left");
            this.orientationMenu.closeMenu();
        });
        LayoutCreatorScreen.colorizeCreatorButton(o1);
        AdvancedButton o2 = new AdvancedButton(0, 0, 0, 16, "mid-left", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("mid-left");
            this.orientationMenu.closeMenu();
        });
        LayoutCreatorScreen.colorizeCreatorButton(o2);
        AdvancedButton o3 = new AdvancedButton(0, 0, 0, 16, "bottom-left", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("bottom-left");
            this.orientationMenu.closeMenu();
        });
        LayoutCreatorScreen.colorizeCreatorButton(o3);
        AdvancedButton o4 = new AdvancedButton(0, 0, 0, 16, "top-centered", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("top-centered");
            this.orientationMenu.closeMenu();
        });
        LayoutCreatorScreen.colorizeCreatorButton(o4);
        AdvancedButton o5 = new AdvancedButton(0, 0, 0, 16, "mid-centered", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("mid-centered");
            this.orientationMenu.closeMenu();
        });
        LayoutCreatorScreen.colorizeCreatorButton(o5);
        AdvancedButton o6 = new AdvancedButton(0, 0, 0, 16, "bottom-centered", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("bottom-centered");
            this.orientationMenu.closeMenu();
        });
        LayoutCreatorScreen.colorizeCreatorButton(o6);
        AdvancedButton o7 = new AdvancedButton(0, 0, 0, 16, "top-right", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("top-right");
            this.orientationMenu.closeMenu();
        });
        LayoutCreatorScreen.colorizeCreatorButton(o7);
        AdvancedButton o8 = new AdvancedButton(0, 0, 0, 16, "mid-right", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("mid-right");
            this.orientationMenu.closeMenu();
        });
        LayoutCreatorScreen.colorizeCreatorButton(o8);
        AdvancedButton o9 = new AdvancedButton(0, 0, 0, 16, "bottom-right", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("bottom-right");
            this.orientationMenu.closeMenu();
        });
        LayoutCreatorScreen.colorizeCreatorButton(o9);
        this.orientationMenu = new PopupMenu(100, 16, -1);
        this.orientationMenu.addContent(o1);
        this.orientationMenu.addContent(o2);
        this.orientationMenu.addContent(o3);
        this.orientationMenu.addContent(o4);
        this.orientationMenu.addContent(o5);
        this.orientationMenu.addContent(o6);
        this.orientationMenu.addContent(o7);
        this.orientationMenu.addContent(o8);
        this.orientationMenu.addContent(o9);
        this.orientationButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.items.setorientation", (String[])new String[0]), true, press -> this.orientationMenu.openMenuAt(press.field_146128_h + press.field_146120_f, press.field_146129_i));
        LayoutCreatorScreen.colorizeCreatorButton(this.orientationButton);
        this.layersButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.items.chooselayer", (String[])new String[0]), true, press -> {
            if (this.layersPopup != null) {
                this.rightclickMenu.removeChild(this.layersPopup);
            }
            this.layersPopup = new PopupMenu(100, 16, -1);
            for (LayoutObject o : this.hoveredLayers) {
                String label = o.object.value;
                if (label == null) {
                    label = "Object";
                } else if (Minecraft.func_71410_x().field_71466_p.func_78256_a(label) > 90) {
                    label = Minecraft.func_71410_x().field_71466_p.func_78269_a(label, 85) + "..";
                }
                AdvancedButton btn = new AdvancedButton(0, 0, 0, 0, label, press2 -> this.handler.setObjectFocused(o, true, true));
                LayoutCreatorScreen.colorizeCreatorButton(btn);
                this.layersPopup.addContent(btn);
            }
            this.rightclickMenu.addChild(this.layersPopup);
            this.layersPopup.openMenuAt(press.field_146128_h + press.field_146120_f, press.field_146129_i);
        });
        LayoutCreatorScreen.colorizeCreatorButton(this.layersButton);
        this.rightclickMenu = new PopupMenu(110, 16, -1);
        this.rightclickMenu.addContent(this.layersButton);
        this.rightclickMenu.addContent(this.orientationButton);
        this.rightclickMenu.addChild(this.orientationMenu);
        if (this.destroyable) {
            AdvancedButton destroy = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.items.delete", (String[])new String[0]), true, press -> this.destroyObject());
            LayoutCreatorScreen.colorizeCreatorButton(destroy);
            this.rightclickMenu.addContent(destroy);
        }
        this.handler.addMenu((IMenu)this.orientationMenu);
        this.handler.addMenu((IMenu)this.rightclickMenu);
    }

    protected void setOrientation(String pos) {
        this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
        if (pos.equals("mid-left")) {
            this.object.orientation = pos;
            this.object.posX = 0;
            this.object.posY = -(this.object.height / 2);
        } else if (pos.equals("bottom-left")) {
            this.object.orientation = pos;
            this.object.posX = 0;
            this.object.posY = -this.object.height;
        } else if (pos.equals("top-centered")) {
            this.object.orientation = pos;
            this.object.posX = -(this.object.width / 2);
            this.object.posY = 0;
        } else if (pos.equals("mid-centered")) {
            this.object.orientation = pos;
            this.object.posX = -(this.object.width / 2);
            this.object.posY = -(this.object.height / 2);
        } else if (pos.equals("bottom-centered")) {
            this.object.orientation = pos;
            this.object.posX = -(this.object.width / 2);
            this.object.posY = -this.object.height;
        } else if (pos.equals("top-right")) {
            this.object.orientation = pos;
            this.object.posX = -this.object.width;
            this.object.posY = 0;
        } else if (pos.equals("mid-right")) {
            this.object.orientation = pos;
            this.object.posX = -this.object.width;
            this.object.posY = -(this.object.height / 2);
        } else if (pos.equals("bottom-right")) {
            this.object.orientation = pos;
            this.object.posX = -this.object.width;
            this.object.posY = -this.object.height;
        } else {
            this.object.orientation = pos;
            this.object.posX = 0;
            this.object.posY = 0;
        }
    }

    protected int orientationMouseX(int mouseX) {
        if (this.object.orientation.endsWith("-centered")) {
            return mouseX - this.handler.field_146294_l / 2;
        }
        if (this.object.orientation.endsWith("-right")) {
            return mouseX - this.handler.field_146294_l;
        }
        return mouseX;
    }

    protected int orientationMouseY(int mouseY) {
        if (this.object.orientation.startsWith("mid-")) {
            return mouseY - this.handler.field_146295_m / 2;
        }
        if (this.object.orientation.startsWith("bottom-")) {
            return mouseY - this.handler.field_146295_m;
        }
        return mouseY;
    }

    public void render(int mouseX, int mouseY) {
        this.updateHovered(mouseX, mouseY);
        try {
            this.object.render(this.handler);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.handler.isFocused(this)) {
            this.renderBorder(mouseX, mouseY);
        } else {
            LayoutObject f = this.handler.getFocusedObject();
            if (!(this.handler.getTopHoverObject() != this || this.handler.isObjectFocused() && (f.isHovered() || f.isDragged() || f.isGettingResized() || f.isGrabberPressed()))) {
                this.renderHighlightBorder();
            }
        }
        if (this.activeGrabber == -1 && (!MouseInput.isLeftMouseDown() || PopupHandler.isPopupActive())) {
            MouseInput.resetCursor();
        }
        if (this.isLeftClicked() && !this.resizing && !this.isGrabberPressed()) {
            this.dragging = true;
        } else if (!MouseInput.isLeftMouseDown()) {
            this.dragging = false;
        }
        if ((this.isGrabberPressed() || this.resizing) && !this.isDragged() && this.handler.isFocused(this)) {
            if (!this.resizing) {
                this.cachedSnapshot = this.handler.history.createSnapshot();
                this.lastGrabber = this.getActiveResizeGrabber();
            }
            this.resizing = true;
            this.handleResize(this.orientationMouseX(mouseX), this.orientationMouseY(mouseY));
        }
        if (this.isDragged() && this.handler.isFocused(this)) {
            if (!this.moving) {
                this.cachedSnapshot = this.handler.history.createSnapshot();
            }
            this.moving = true;
            if (mouseX >= 5 && mouseX <= this.handler.field_146294_l - 5) {
                this.object.posX = this.orientationMouseX(mouseX) - this.startDiffX;
            }
            if (mouseY >= 5 && mouseY <= this.handler.field_146295_m - 5) {
                this.object.posY = this.orientationMouseY(mouseY) - this.startDiffY;
            }
        }
        if (!this.isDragged()) {
            this.startDiffX = this.orientationMouseX(mouseX) - this.object.posX;
            this.startDiffY = this.orientationMouseY(mouseY) - this.object.posY;
            if ((this.startX != this.object.posX || this.startY != this.object.posY) && this.moving && this.cachedSnapshot != null) {
                this.handler.history.saveSnapshot(this.cachedSnapshot);
            }
            this.moving = false;
        }
        if (!MouseInput.isLeftMouseDown()) {
            if ((this.startWidth != this.object.width || this.startHeight != this.object.height) && this.resizing && this.cachedSnapshot != null) {
                this.handler.history.saveSnapshot(this.cachedSnapshot);
            }
            this.startX = this.object.posX;
            this.startY = this.object.posY;
            this.startWidth = this.object.width;
            this.startHeight = this.object.height;
            this.resizing = false;
        }
        if (this.rightclickMenu != null) {
            if (this.isRightClicked() && this.handler.isFocused(this)) {
                this.rightclickMenu.openMenuAt(mouseX, mouseY);
                this.hoveredLayers.clear();
                for (LayoutObject o : this.handler.getContent()) {
                    if (!o.isHovered()) continue;
                    this.hoveredLayers.add(o);
                }
            }
            this.rightclickMenu.render(mouseX, mouseY);
            if ((this.isLeftClicked() || (MouseInput.isRightMouseDown() || MouseInput.isLeftMouseDown()) && !this.isHovered()) && !this.rightclickMenu.isHovered()) {
                this.rightclickMenu.closeMenu();
            }
        }
        if (this.orientationMenu != null && (this.isLeftClicked() || (MouseInput.isRightMouseDown() || MouseInput.isLeftMouseDown()) && !this.isHovered()) && !this.orientationMenu.isHovered() && !this.orientationButton.func_146115_a()) {
            this.orientationMenu.closeMenu();
        }
        if (this.layersPopup != null && (this.isLeftClicked() || (MouseInput.isRightMouseDown() || MouseInput.isLeftMouseDown()) && !this.isHovered()) && !this.layersPopup.isHovered() && !this.layersButton.func_146115_a()) {
            this.layersPopup.closeMenu();
        }
        if (!this.handler.isFocusChangeBlocked() || !MouseInput.isLeftMouseDown() && !MouseInput.isRightMouseDown()) {
            if (this.layersPopup != null && this.layersPopup.isOpen() || this.orientationMenu != null && this.orientationMenu.isOpen() || this.rightclickMenu.isOpen()) {
                this.handler.setFocusChangeBlocked(this.objectId, true);
            } else {
                this.handler.setFocusChangeBlocked(this.objectId, false);
            }
        }
    }

    protected void renderBorder(int mouseX, int mouseY) {
        GuiScreen.func_73734_a((int)this.object.getPosX(this.handler), (int)this.object.getPosY(this.handler), (int)(this.object.getPosX(this.handler) + this.object.width), (int)(this.object.getPosY(this.handler) + 1), (int)Color.BLUE.getRGB());
        GuiScreen.func_73734_a((int)this.object.getPosX(this.handler), (int)(this.object.getPosY(this.handler) + this.object.height - 1), (int)(this.object.getPosX(this.handler) + this.object.width), (int)(this.object.getPosY(this.handler) + this.object.height), (int)Color.BLUE.getRGB());
        GuiScreen.func_73734_a((int)this.object.getPosX(this.handler), (int)this.object.getPosY(this.handler), (int)(this.object.getPosX(this.handler) + 1), (int)(this.object.getPosY(this.handler) + this.object.height), (int)Color.BLUE.getRGB());
        GuiScreen.func_73734_a((int)(this.object.getPosX(this.handler) + this.object.width - 1), (int)this.object.getPosY(this.handler), (int)(this.object.getPosX(this.handler) + this.object.width), (int)(this.object.getPosY(this.handler) + this.object.height), (int)Color.BLUE.getRGB());
        int w = 4;
        int h = 4;
        int yHorizontal = this.object.getPosY(this.handler) + this.object.height / 2 - h / 2;
        int xHorizontalLeft = this.object.getPosX(this.handler) - w / 2;
        int xHorizontalRight = this.object.getPosX(this.handler) + this.object.width - w / 2;
        int xVertical = this.object.getPosX(this.handler) + this.object.width / 2 - w / 2;
        int yVerticalTop = this.object.getPosY(this.handler) - h / 2;
        int yVerticalBottom = this.object.getPosY(this.handler) + this.object.height - h / 2;
        GuiScreen.func_73734_a((int)xHorizontalLeft, (int)yHorizontal, (int)(xHorizontalLeft + w), (int)(yHorizontal + h), (int)Color.BLUE.getRGB());
        GuiScreen.func_73734_a((int)xHorizontalRight, (int)yHorizontal, (int)(xHorizontalRight + w), (int)(yHorizontal + h), (int)Color.BLUE.getRGB());
        GuiScreen.func_73734_a((int)xVertical, (int)yVerticalTop, (int)(xVertical + w), (int)(yVerticalTop + h), (int)Color.BLUE.getRGB());
        GuiScreen.func_73734_a((int)xVertical, (int)yVerticalBottom, (int)(xVertical + w), (int)(yVerticalBottom + h), (int)Color.BLUE.getRGB());
        if (mouseX >= xHorizontalLeft && mouseX <= xHorizontalLeft + w && mouseY >= yHorizontal && mouseY <= yHorizontal + h) {
            MouseInput.setCursor((MouseInput.CursorType)MouseInput.CursorType.HRESIZE);
            this.activeGrabber = 0;
        } else if (mouseX >= xHorizontalRight && mouseX <= xHorizontalRight + w && mouseY >= yHorizontal && mouseY <= yHorizontal + h) {
            MouseInput.setCursor((MouseInput.CursorType)MouseInput.CursorType.HRESIZE);
            this.activeGrabber = 1;
        } else if (mouseX >= xVertical && mouseX <= xVertical + w && mouseY >= yVerticalTop && mouseY <= yVerticalTop + h) {
            MouseInput.setCursor((MouseInput.CursorType)MouseInput.CursorType.VRESIZE);
            this.activeGrabber = 2;
        } else if (mouseX >= xVertical && mouseX <= xVertical + w && mouseY >= yVerticalBottom && mouseY <= yVerticalBottom + h) {
            MouseInput.setCursor((MouseInput.CursorType)MouseInput.CursorType.VRESIZE);
            this.activeGrabber = 3;
        } else {
            this.activeGrabber = -1;
        }
        RenderUtils.setScale((float)0.5f);
        this.func_73731_b(Minecraft.func_71410_x().field_71466_p, Locals.localize((String)"helper.creator.items.border.orientation", (String[])new String[0]) + ": " + this.object.orientation, this.object.getPosX(this.handler) * 2, this.object.getPosY(this.handler) * 2 - 26, Color.WHITE.getRGB());
        this.func_73731_b(Minecraft.func_71410_x().field_71466_p, Locals.localize((String)"helper.creator.items.border.posx", (String[])new String[0]) + ": " + this.object.getPosX(this.handler), this.object.getPosX(this.handler) * 2, this.object.getPosY(this.handler) * 2 - 17, Color.WHITE.getRGB());
        this.func_73731_b(Minecraft.func_71410_x().field_71466_p, Locals.localize((String)"helper.creator.items.border.width", (String[])new String[0]) + ": " + this.object.width, this.object.getPosX(this.handler) * 2, this.object.getPosY(this.handler) * 2 - 8, Color.WHITE.getRGB());
        this.func_73731_b(Minecraft.func_71410_x().field_71466_p, Locals.localize((String)"helper.creator.items.border.posy", (String[])new String[0]) + ": " + this.object.getPosY(this.handler), (this.object.getPosX(this.handler) + this.object.width) * 2 + 3, (this.object.getPosY(this.handler) + this.object.height) * 2 - 14, Color.WHITE.getRGB());
        this.func_73731_b(Minecraft.func_71410_x().field_71466_p, Locals.localize((String)"helper.creator.items.border.height", (String[])new String[0]) + ": " + this.object.height, (this.object.getPosX(this.handler) + this.object.width) * 2 + 3, (this.object.getPosY(this.handler) + this.object.height) * 2 - 5, Color.WHITE.getRGB());
        RenderUtils.postScale();
    }

    protected void renderHighlightBorder() {
        Color c = new Color(0, 200, 255, 255);
        Gui.func_73734_a((int)this.object.getPosX(this.handler), (int)this.object.getPosY(this.handler), (int)(this.object.getPosX(this.handler) + this.object.width), (int)(this.object.getPosY(this.handler) + 1), (int)c.getRGB());
        Gui.func_73734_a((int)this.object.getPosX(this.handler), (int)(this.object.getPosY(this.handler) + this.object.height - 1), (int)(this.object.getPosX(this.handler) + this.object.width), (int)(this.object.getPosY(this.handler) + this.object.height), (int)c.getRGB());
        Gui.func_73734_a((int)this.object.getPosX(this.handler), (int)this.object.getPosY(this.handler), (int)(this.object.getPosX(this.handler) + 1), (int)(this.object.getPosY(this.handler) + this.object.height), (int)c.getRGB());
        Gui.func_73734_a((int)(this.object.getPosX(this.handler) + this.object.width - 1), (int)this.object.getPosY(this.handler), (int)(this.object.getPosX(this.handler) + this.object.width), (int)(this.object.getPosY(this.handler) + this.object.height), (int)c.getRGB());
    }

    public int getActiveResizeGrabber() {
        return this.activeGrabber;
    }

    public boolean isGrabberPressed() {
        return this.getActiveResizeGrabber() != -1 && MouseInput.isLeftMouseDown();
    }

    protected int getAspectWidth(int startW, int startH, int height) {
        double ratio = (double)startW / (double)startH;
        return (int)((double)height * ratio);
    }

    protected int getAspectHeight(int startW, int startH, int width) {
        double ratio = (double)startW / (double)startH;
        return (int)((double)width / ratio);
    }

    protected void handleResize(int mouseX, int mouseY) {
        int w;
        int h;
        int h2;
        int w2;
        int g = this.lastGrabber;
        int diffX = mouseX > this.startX ? Math.abs(mouseX - this.startX) : Math.negateExact(this.startX - mouseX);
        int diffY = mouseY > this.startY ? Math.abs(mouseY - this.startY) : Math.negateExact(this.startY - mouseY);
        if (g == 0 && (w2 = this.startWidth + this.getOpponentInt(diffX)) >= 5) {
            this.object.posX = this.startX + diffX;
            this.object.width = w2;
            if (isShiftPressed && (h2 = this.getAspectHeight(this.startWidth, this.startHeight, w2)) >= 5) {
                this.object.height = h2;
            }
        }
        if (g == 1 && (w2 = this.object.width + (diffX - this.object.width)) >= 5) {
            this.object.width = w2;
            if (isShiftPressed && (h2 = this.getAspectHeight(this.startWidth, this.startHeight, w2)) >= 5) {
                this.object.height = h2;
            }
        }
        if (g == 2 && (h = this.startHeight + this.getOpponentInt(diffY)) >= 5) {
            this.object.posY = this.startY + diffY;
            this.object.height = h;
            if (isShiftPressed && (w = this.getAspectWidth(this.startWidth, this.startHeight, h)) >= 5) {
                this.object.width = w;
            }
        }
        if (g == 3 && (h = this.object.height + (diffY - this.object.height)) >= 5) {
            this.object.height = h;
            if (isShiftPressed && (w = this.getAspectWidth(this.startWidth, this.startHeight, h)) >= 5) {
                this.object.width = w;
            }
        }
    }

    private int getOpponentInt(int i) {
        if (Math.abs(i) == i) {
            return Math.negateExact(i);
        }
        return Math.abs(i);
    }

    protected void updateHovered(int mouseX, int mouseY) {
        this.hovered = mouseX >= this.object.getPosX(this.handler) && mouseX <= this.object.getPosX(this.handler) + this.object.width && mouseY >= this.object.getPosY(this.handler) && mouseY <= this.object.getPosY(this.handler) + this.object.height;
    }

    public boolean isDragged() {
        return this.dragging;
    }

    public boolean isGettingResized() {
        return this.resizing;
    }

    public boolean isLeftClicked() {
        return this.isHovered() && MouseInput.isLeftMouseDown();
    }

    public boolean isRightClicked() {
        return this.isHovered() && MouseInput.isRightMouseDown();
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public void setX(int x) {
        this.object.posX = x;
    }

    public void setY(int y) {
        this.object.posY = y;
    }

    public int getX() {
        return this.object.getPosX(this.handler);
    }

    public int getY() {
        return this.object.getPosY(this.handler);
    }

    public void setWidth(int width) {
        this.object.width = width;
    }

    public void setHeight(int height) {
        this.object.height = height;
    }

    public int getWidth() {
        return this.object.width;
    }

    public int getHeight() {
        return this.object.height;
    }

    public boolean isDestroyable() {
        return this.destroyable;
    }

    public void destroyObject() {
        if (!this.destroyable) {
            return;
        }
        this.handler.setMenusUseable(false);
        PopupHandler.displayPopup((Popup)new YesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
            if (call.booleanValue()) {
                this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
                this.handler.removeContent(this);
            }
            this.handler.setMenusUseable(true);
        }, new String[]{"\u00a7c\u00a7l" + Locals.localize((String)"helper.creator.messages.sure", (String[])new String[0]), "", Locals.localize((String)"helper.creator.deleteobject", (String[])new String[0]), "", "", "", "", ""}));
    }

    public void resetObjectStates() {
        this.hovered = false;
        this.dragging = false;
        this.resizing = false;
        this.activeGrabber = -1;
        if (this.orientationMenu != null) {
            this.orientationMenu.closeMenu();
        }
        if (this.rightclickMenu != null) {
            this.rightclickMenu.closeMenu();
        }
        if (this.layersPopup != null) {
            this.layersPopup.closeMenu();
        }
        this.handler.setFocusChangeBlocked(this.objectId, false);
        this.handler.setObjectFocused(this, false, true);
    }

    public abstract List<PropertiesSection> getProperties();
}

