/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item;

import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;

public abstract class CustomizationItemBase {
    public String value;
    public String action;
    public int posX = 0;
    public int posY = 0;
    public String orientation = "top-left";
    public int width = -1;
    public int height = -1;

    public CustomizationItemBase(PropertiesSection item) {
        String h;
        String w;
        String o;
        this.action = item.getEntryValue("action");
        String x = item.getEntryValue("x");
        String y = item.getEntryValue("y");
        if (x != null) {
            x = MenuCustomization.convertString(x);
            this.posX = (int)MathUtils.calculateFromString((String)x);
        }
        if (y != null) {
            y = MenuCustomization.convertString(y);
            this.posY = (int)MathUtils.calculateFromString((String)y);
        }
        if ((o = item.getEntryValue("orientation")) != null) {
            this.orientation = o;
        }
        if ((w = item.getEntryValue("width")) != null) {
            w = MenuCustomization.convertString(w);
            this.width = (int)MathUtils.calculateFromString((String)w);
            if (this.width < 0) {
                this.width = 0;
            }
        }
        if ((h = item.getEntryValue("height")) != null) {
            h = MenuCustomization.convertString(h);
            this.height = (int)MathUtils.calculateFromString((String)h);
            if (this.height < 0) {
                this.height = 0;
            }
        }
    }

    public abstract void render(GuiScreen var1) throws IOException;

    public int getPosX(GuiScreen menu) {
        int w = menu.field_146294_l;
        int x = this.posX;
        if (this.orientation.equalsIgnoreCase("top-centered")) {
            x += w / 2;
        }
        if (this.orientation.equalsIgnoreCase("mid-centered")) {
            x += w / 2;
        }
        if (this.orientation.equalsIgnoreCase("bottom-centered")) {
            x += w / 2;
        }
        if (this.orientation.equalsIgnoreCase("top-right")) {
            x += w;
        }
        if (this.orientation.equalsIgnoreCase("mid-right")) {
            x += w;
        }
        if (this.orientation.equalsIgnoreCase("bottom-right")) {
            x += w;
        }
        return x;
    }

    public int getPosY(GuiScreen menu) {
        int h = menu.field_146295_m;
        int y = this.posY;
        if (this.orientation.equalsIgnoreCase("mid-left")) {
            y += h / 2;
        }
        if (this.orientation.equalsIgnoreCase("bottom-left")) {
            y += h;
        }
        if (this.orientation.equalsIgnoreCase("mid-centered")) {
            y += h / 2;
        }
        if (this.orientation.equalsIgnoreCase("bottom-centered")) {
            y += h;
        }
        if (this.orientation.equalsIgnoreCase("top-right")) {
            // empty if block
        }
        if (this.orientation.equalsIgnoreCase("mid-right")) {
            y += h / 2;
        }
        if (this.orientation.equalsIgnoreCase("bottom-right")) {
            y += h;
        }
        return y;
    }

    public boolean shouldRender() {
        return this.value != null;
    }

    public CustomizationItemBase clone() {
        CustomizationItemBase item = new CustomizationItemBase(new PropertiesSection("")){

            @Override
            public void render(GuiScreen menu) throws IOException {
            }
        };
        item.height = this.height;
        item.orientation = this.orientation;
        item.posX = this.posX;
        item.posY = this.posY;
        item.value = this.value;
        item.width = this.width;
        item.action = this.action;
        return item;
    }
}

