/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item;

import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;

public class StringCustomizationItem
extends CustomizationItemBase {
    public float scale = 1.0f;
    public boolean shadow = false;
    public boolean centered = false;

    public StringCustomizationItem(PropertiesSection item) {
        super(item);
        if (this.action != null && this.action.equalsIgnoreCase("addtext")) {
            String sc;
            String ce;
            String sh;
            this.value = item.getEntryValue("value");
            if (this.value != null) {
                this.value = MenuCustomization.convertString(this.value);
            }
            if ((sh = item.getEntryValue("shadow")) != null && sh.equalsIgnoreCase("true")) {
                this.shadow = true;
            }
            if ((ce = item.getEntryValue("centered")) != null && ce.equalsIgnoreCase("true")) {
                this.centered = true;
            }
            if ((sc = item.getEntryValue("scale")) != null && MathUtils.isFloat((String)sc)) {
                this.scale = Float.parseFloat(sc);
            }
        }
    }

    @Override
    public void render(GuiScreen menu) throws IOException {
        if (!this.shouldRender()) {
            return;
        }
        int x = this.getPosX(menu);
        int y = this.getPosY(menu);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        RenderUtils.setScale((float)this.scale);
        if (this.shadow) {
            font.func_175063_a("\u00a7f" + this.value, (float)x, (float)y, 0);
        } else {
            font.func_78276_b("\u00a7f" + this.value, x, y, 0);
        }
        RenderUtils.postScale();
    }

    @Override
    public int getPosX(GuiScreen menu) {
        int x = super.getPosX(menu);
        if (this.centered) {
            x -= (int)((float)(Minecraft.func_71410_x().field_71466_p.func_78256_a(this.value) / 2) * this.scale);
        }
        x = (int)((float)x / this.scale);
        return x;
    }

    @Override
    public int getPosY(GuiScreen menu) {
        return (int)((float)super.getPosY(menu) / this.scale);
    }

    @Override
    public StringCustomizationItem clone() {
        StringCustomizationItem item = new StringCustomizationItem(new PropertiesSection(""));
        item.centered = this.centered;
        item.height = this.height;
        item.orientation = this.orientation;
        item.posX = this.posX;
        item.posY = this.posY;
        item.scale = this.scale;
        item.shadow = this.shadow;
        item.value = this.value;
        item.width = this.width;
        item.action = this.action;
        return item;
    }
}

