/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item;

import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;

public class WebStringCustomizationItem
extends CustomizationItemBase {
    public volatile List<String> lines = new ArrayList<String>();
    private volatile boolean updating = false;
    public boolean multiline = false;
    public boolean shadow = false;
    public float scale = 1.0f;

    public WebStringCustomizationItem(PropertiesSection item) {
        super(item);
        if (this.action != null && this.action.equalsIgnoreCase("addwebtext")) {
            String sc;
            String sh;
            String multi;
            this.value = item.getEntryValue("url");
            if (this.value != null) {
                this.value = MenuCustomization.convertString(this.value);
            }
            if ((multi = item.getEntryValue("multiline")) != null && multi.equalsIgnoreCase("true")) {
                this.multiline = true;
            }
            if ((sh = item.getEntryValue("shadow")) != null && sh.equalsIgnoreCase("true")) {
                this.shadow = true;
            }
            if ((sc = item.getEntryValue("scale")) != null && MathUtils.isFloat((String)sc)) {
                this.scale = Float.parseFloat(sc);
            }
            this.updateContent(this.value);
        }
    }

    @Override
    public void render(GuiScreen menu) throws IOException {
        if (!this.shouldRender()) {
            return;
        }
        if (!this.updating) {
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            GlStateManager.func_179147_l();
            int w = 0;
            int i = 0;
            for (String s : this.lines) {
                int sw;
                float sc = this.scale;
                if (s.startsWith("# ")) {
                    s = s.substring(2);
                    this.scale += 1.3f;
                }
                if (s.startsWith("## ")) {
                    s = s.substring(3);
                    this.scale += 1.0f;
                }
                if (s.startsWith("### ")) {
                    s = s.substring(4);
                    this.scale += 0.5f;
                }
                if (s.startsWith("#### ")) {
                    s = s.substring(5);
                    this.scale += 0.2f;
                }
                if (w < (sw = (int)((float)font.func_78256_a(s) * this.scale))) {
                    w = sw;
                }
                int x = this.getPosX(menu);
                int y = this.getPosY(menu);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
                if (this.shadow) {
                    font.func_175063_a(s, (float)x, (float)y + (float)i / this.scale, Color.WHITE.getRGB());
                } else {
                    font.func_78276_b(s, x, (int)((float)y + (float)i / this.scale), Color.WHITE.getRGB());
                }
                GlStateManager.func_179121_F();
                i = (int)((float)i + 10.0f * this.scale);
                this.scale = sc;
            }
            this.height = i;
            this.width = w;
            GlStateManager.func_179084_k();
        }
    }

    @Override
    public int getPosX(GuiScreen menu) {
        int x = super.getPosX(menu);
        x = (int)((float)x / this.scale);
        return x;
    }

    @Override
    public int getPosY(GuiScreen menu) {
        return (int)((float)super.getPosY(menu) / this.scale);
    }

    @Override
    public boolean shouldRender() {
        if (this.lines == null || this.lines.isEmpty()) {
            return false;
        }
        return super.shouldRender();
    }

    public void updateContent(final String url) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                WebStringCustomizationItem.this.updating = true;
                String old = WebStringCustomizationItem.this.value;
                WebStringCustomizationItem.this.value = url;
                if (WebStringCustomizationItem.this.isValidUrl()) {
                    String path;
                    if (WebStringCustomizationItem.this.value.toLowerCase().contains("/blob/") && (WebStringCustomizationItem.this.value.toLowerCase().startsWith("http://github.com/") || WebStringCustomizationItem.this.value.toLowerCase().startsWith("https://github.com/") || WebStringCustomizationItem.this.value.toLowerCase().startsWith("http://www.github.com/") || WebStringCustomizationItem.this.value.toLowerCase().startsWith("https://www.github.com/"))) {
                        path = WebStringCustomizationItem.this.value.replace("//", "").split("/", 2)[1].replace("/blob/", "/");
                        WebStringCustomizationItem.this.value = "https://raw.githubusercontent.com/" + path;
                    }
                    if (!WebStringCustomizationItem.this.value.toLowerCase().contains("/raw/") && (WebStringCustomizationItem.this.value.toLowerCase().startsWith("http://pastebin.com/") || WebStringCustomizationItem.this.value.toLowerCase().startsWith("https://pastebin.com/") || WebStringCustomizationItem.this.value.toLowerCase().startsWith("http://www.pastebin.com/") || WebStringCustomizationItem.this.value.toLowerCase().startsWith("https://www.pastebin.com/"))) {
                        path = WebStringCustomizationItem.this.value.replace("//", "").split("/", 2)[1];
                        WebStringCustomizationItem.this.value = "https://pastebin.com/raw/" + path;
                    }
                    try {
                        WebStringCustomizationItem.this.lines.clear();
                        URL u = new URL(WebStringCustomizationItem.this.value);
                        BufferedReader r = new BufferedReader(new InputStreamReader(u.openStream(), StandardCharsets.UTF_8));
                        String s = r.readLine();
                        while (s != null) {
                            WebStringCustomizationItem.this.lines.add(StringUtils.convertFormatCodes((String)s, (String)"&", (String)"\u00a7"));
                            if (!WebStringCustomizationItem.this.multiline) break;
                            s = r.readLine();
                        }
                        r.close();
                    }
                    catch (Exception e) {
                        WebStringCustomizationItem.this.lines.clear();
                        WebStringCustomizationItem.this.lines.add(Locals.localize((String)"customization.items.webstring.unabletoload", (String[])new String[0]));
                        e.printStackTrace();
                    }
                } else {
                    WebStringCustomizationItem.this.lines.clear();
                    WebStringCustomizationItem.this.lines.add(Locals.localize((String)"customization.items.webstring.unabletoload", (String[])new String[0]));
                    System.out.println("########################## ERROR ##########################");
                    System.out.println("[FM] Cannot load text content from " + WebStringCustomizationItem.this.value + "! Invalid URL!");
                    System.out.println("###########################################################");
                    WebStringCustomizationItem.this.value = old;
                }
                WebStringCustomizationItem.this.updating = false;
            }
        }).start();
    }

    private boolean isValidUrl() {
        if (this.value == null || !this.value.startsWith("http://") && !this.value.startsWith("https://")) {
            return false;
        }
        try {
            URL url = new URL(this.value);
            HttpURLConnection c = (HttpURLConnection)url.openConnection();
            c.setRequestMethod("HEAD");
            int r = c.getResponseCode();
            if (r == 200) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Trying alternative method to check for existing url..");
            try {
                URL url = new URL(this.value);
                HttpURLConnection c = (HttpURLConnection)url.openConnection();
                int r = c.getResponseCode();
                if (r == 200) {
                    return true;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return false;
    }
}

