/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.diggusmaximus;

import java.util.ArrayDeque;
import java.util.Deque;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.kyrptonaught.diggusmaximus.DiggingPlayerEntity;
import net.kyrptonaught.diggusmaximus.DiggusMaximusMod;
import net.kyrptonaught.diggusmaximus.ExcavateHelper;
import net.kyrptonaught.diggusmaximus.ExcavateTypes;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class Excavate {
    private final class_2338 startPos;
    private final class_1657 player;
    private class_2960 startID;
    private final class_1792 startTool;
    private int mined = 0;
    private final class_1937 world;
    private final Deque<class_2338> points = new ArrayDeque<class_2338>();
    private final class_2350 facing;
    private int shapeSelection = -1;

    public Excavate(class_2338 pos, class_2960 blockID, class_1657 player, class_2350 facing) {
        this.startPos = pos;
        this.player = player;
        this.world = player.method_5770();
        if (ExcavateHelper.configAllowsMining(blockID.toString())) {
            this.startID = blockID;
        }
        this.startTool = player.method_6047().method_7909();
        this.facing = facing;
    }

    public void startExcavate(int shapeSelection) {
        this.shapeSelection = shapeSelection;
        this.forceExcavateAt(this.startPos);
        if (this.startID == null) {
            return;
        }
        ((DiggingPlayerEntity)this.player).setExcavating(true);
        while (!this.points.isEmpty()) {
            this.spread(this.points.remove());
        }
        ((DiggingPlayerEntity)this.player).setExcavating(false);
    }

    private void spread(class_2338 pos) {
        for (class_2338 dirPos : ExcavateTypes.getSpreadType(this.shapeSelection, this.facing, this.startPos, pos)) {
            if (!ExcavateHelper.isValidPos(dirPos)) continue;
            this.excavateAt(pos.method_10081((class_2382)dirPos));
        }
    }

    private void excavateAt(class_2338 pos) {
        if (this.mined >= ExcavateHelper.maxMined) {
            return;
        }
        class_2960 block = class_2378.field_11146.method_10221((Object)ExcavateHelper.getBlockAt(this.world, pos));
        if (ExcavateHelper.isTheSameBlock(this.startID, block, this.world, this.shapeSelection) && ExcavateHelper.canMine(this.player, this.startTool, this.world, this.startPos, pos) && this.isExcavatingAllowed(pos)) {
            this.points.add(pos);
            ++this.mined;
            if (DiggusMaximusMod.getOptions().autoPickup) {
                ExcavateHelper.pickupDrops(this.world, pos, this.player);
            }
        }
    }

    private boolean isExcavatingAllowed(class_2338 pos) {
        return ((PlayerBlockBreakEvents.Before)PlayerBlockBreakEvents.BEFORE.invoker()).beforeBlockBreak(this.world, this.player, pos, this.world.method_8320(pos), this.world.method_8321(pos)) && ((class_3222)this.player).field_13974.method_14266(pos);
    }

    private void forceExcavateAt(class_2338 pos) {
        this.points.add(pos);
        ++this.mined;
        if (DiggusMaximusMod.getOptions().autoPickup) {
            ExcavateHelper.pickupDrops(this.world, pos, this.player);
        }
    }
}

