/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.tracker.nearby;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.ArrayList;
import me.jellysquid.mods.lithium.common.entity.tracker.EntityTrackerEngine;
import me.jellysquid.mods.lithium.common.entity.tracker.EntityTrackerSection;
import me.jellysquid.mods.lithium.common.entity.tracker.nearby.MovementTrackerCache;
import me.jellysquid.mods.lithium.common.util.tuples.WorldSectionBox;
import me.jellysquid.mods.lithium.mixin.ai.nearby_entity_tracking.ServerEntityManagerAccessor;
import me.jellysquid.mods.lithium.mixin.ai.nearby_entity_tracking.ServerWorldAccessor;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.class_5568;
import net.minecraft.class_5572;
import net.minecraft.class_5573;

public abstract class SectionedEntityMovementTracker<E extends class_5568, S> {
    final WorldSectionBox trackedWorldSections;
    final Class<S> clazz;
    private final int trackedClass;
    ArrayList<class_5572<E>> sortedSections;
    boolean[] sectionVisible;
    private int timesRegistered;
    private ArrayList<long[]> sectionChangeCounters;
    private long maxChangeTime;

    public SectionedEntityMovementTracker(WorldSectionBox interactionChunks, Class<S> clazz) {
        this.clazz = clazz;
        this.trackedWorldSections = interactionChunks;
        this.trackedClass = EntityTrackerEngine.MOVEMENT_NOTIFYING_ENTITY_CLASSES.indexOf(clazz);
        assert (this.trackedClass != -1);
    }

    public int hashCode() {
        return HashCommon.mix((int)this.trackedWorldSections.hashCode()) ^ HashCommon.mix((int)this.trackedClass) ^ this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return obj.getClass() == this.getClass() && this.clazz == ((SectionedEntityMovementTracker)obj).clazz && this.trackedWorldSections.equals(((SectionedEntityMovementTracker)obj).trackedWorldSections);
    }

    public boolean isUnchangedSince(long lastCheckedTime) {
        if (lastCheckedTime <= this.maxChangeTime) {
            return false;
        }
        ArrayList<long[]> sectionChangeCounters = this.sectionChangeCounters;
        int trackedClass = this.trackedClass;
        int numCounters = sectionChangeCounters.size();
        for (int i = 0; i < numCounters; ++i) {
            long sectionChangeTime = sectionChangeCounters.get(i)[trackedClass];
            if (lastCheckedTime > sectionChangeTime) continue;
            this.setChanged(sectionChangeTime);
            return false;
        }
        return true;
    }

    public void register(class_3218 world) {
        assert (world == this.trackedWorldSections.world());
        if (this.timesRegistered == 0) {
            class_5573 cache = ((ServerEntityManagerAccessor)((ServerWorldAccessor)world).getEntityManager()).getCache();
            this.sectionChangeCounters = new ArrayList();
            WorldSectionBox trackedSections = this.trackedWorldSections;
            int size = trackedSections.numSections();
            assert (size > 0);
            this.sortedSections = new ArrayList(size);
            this.sectionVisible = new boolean[size];
            for (int x = trackedSections.chunkX1(); x < trackedSections.chunkX2(); ++x) {
                for (int z = trackedSections.chunkZ1(); z < trackedSections.chunkZ2(); ++z) {
                    for (int y = trackedSections.chunkY1(); y < trackedSections.chunkY2(); ++y) {
                        class_5572 section = cache.method_31784(class_4076.method_18685((int)x, (int)y, (int)z));
                        EntityTrackerSection sectionAccess = (EntityTrackerSection)section;
                        this.sortedSections.add(section);
                        sectionAccess.addListener(this);
                    }
                }
            }
            this.setChanged(world.method_8510());
        }
        ++this.timesRegistered;
    }

    public void unRegister(class_3218 world) {
        assert (world == this.trackedWorldSections.world());
        if (--this.timesRegistered > 0) {
            return;
        }
        assert (this.timesRegistered == 0);
        class_5573 cache = ((ServerEntityManagerAccessor)((ServerWorldAccessor)world).getEntityManager()).getCache();
        MovementTrackerCache storage = (MovementTrackerCache)cache;
        storage.remove(this);
        ArrayList<class_5572<E>> sections = this.sortedSections;
        for (int i = sections.size() - 1; i >= 0; --i) {
            class_5572<E> section = sections.get(i);
            EntityTrackerSection sectionAccess = (EntityTrackerSection)section;
            sectionAccess.removeListener(cache, this);
        }
        this.setChanged(world.method_8510());
    }

    public void onSectionEnteredRange(EntityTrackerSection section) {
        this.setChanged(this.trackedWorldSections.world().method_8510());
        this.sectionVisible[this.sortedSections.lastIndexOf((Object)section)] = true;
        this.sectionChangeCounters.add(section.getMovementTimestampArray());
    }

    public void onSectionLeftRange(EntityTrackerSection section) {
        this.setChanged(this.trackedWorldSections.world().method_8510());
        this.sectionVisible[this.sortedSections.indexOf((Object)section)] = false;
        this.sectionChangeCounters.remove(section.getMovementTimestampArray());
    }

    private void setChanged(long atTime) {
        if (atTime > this.maxChangeTime) {
            this.maxChangeTime = atTime;
        }
    }
}

