/*
 * Decompiled with CFR 0.152.
 */
package schauweg.smoothswapping;

import java.util.List;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_310;
import schauweg.smoothswapping.config.Config;
import schauweg.smoothswapping.swaps.InventorySwap;

public class SwapUtil {
    public static boolean hasArrived(InventorySwap swap) {
        int quadrant = SwapUtil.getQuadrant(swap.getAngle());
        double x = swap.getX();
        double y = swap.getY();
        if (quadrant == 0 && x > 0.0 && y > 0.0) {
            return true;
        }
        if (quadrant == 1 && x < 0.0 && y > 0.0) {
            return true;
        }
        if (quadrant == 2 && x < 0.0 && y < 0.0) {
            return true;
        }
        return quadrant == 3 && x > 0.0 && y < 0.0;
    }

    public static int getSlotIndex(class_1799 stack) {
        if (class_310.method_1551().field_1724 == null) {
            return -1;
        }
        class_1703 handler = class_310.method_1551().field_1724.field_7512;
        class_2371 stacks = handler.method_7602();
        return stacks.indexOf((Object)stack);
    }

    public static void setRenderToTrue(List<InventorySwap> swapList) {
        for (InventorySwap swap : swapList) {
            swap.setRenderDestinationSlot(true);
        }
    }

    private static int getQuadrant(float angle) {
        return (int)(Math.floor((double)(2.0f * angle) / Math.PI) % 4.0 + 4.0) % 4;
    }

    public static float bezierBlend(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    public static float map(float in, float inMin, float inMax, float outMax, float outMin) {
        return (in - inMin) / (inMax - inMin) * (outMax - outMin) + outMin;
    }

    public static float getEase(Config config, float progress) {
        switch (config.getEaseMode()) {
            case "linear": {
                progress = 1.0f;
                break;
            }
            case "ease-in": {
                progress -= 1.0f;
                break;
            }
            case "ease-in-out": {
                progress = progress >= 0.5f ? 1.0f - progress : progress;
            }
        }
        return SwapUtil.bezierBlend(progress) * config.getEaseSpeedFormatted();
    }
}

