/*
 * Decompiled with CFR 0.152.
 */
package schauweg.smoothswapping.mixin;

import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_809;
import net.minecraft.class_918;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import schauweg.smoothswapping.SmoothSwapping;
import schauweg.smoothswapping.SwapUtil;
import schauweg.smoothswapping.config.Config;
import schauweg.smoothswapping.config.ConfigManager;
import schauweg.smoothswapping.swaps.InventorySwap;

@Mixin(value={class_918.class})
public abstract class ItemRendererMixin {
    @Shadow
    public float field_4730;

    @Inject(method={"renderItem(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/render/model/json/ModelTransformation$Mode;ZLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;IILnet/minecraft/client/render/model/BakedModel;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onRenderItem(class_1799 stack, class_809.class_811 renderMode, boolean leftHanded, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_1087 model, CallbackInfo cbi) {
        if (this.field_4730 < 100.0f) {
            return;
        }
        if (renderMode == class_809.class_811.field_4317) {
            class_310 client = class_310.method_1551();
            if (client.field_1724 == null) {
                return;
            }
            this.doSwap(client, stack, renderMode, leftHanded, matrices, vertexConsumers, light, overlay, model, this.field_4730, cbi);
        }
    }

    @Inject(method={"renderGuiItemOverlay(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderOverlay(class_327 renderer, class_1799 stack, int x, int y, String countLabel, CallbackInfo ci) {
        if (this.field_4730 < 100.0f) {
            return;
        }
        this.doOverlayRender((class_918)this, stack, renderer, x, y, ci);
    }

    private void doSwap(class_310 client, class_1799 stack, class_809.class_811 renderMode, boolean leftHanded, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_1087 model, float zOffset, CallbackInfo ci) {
        float lastFrameDuration = client.method_1534();
        class_918 renderer = client.method_1480();
        int index = SwapUtil.getSlotIndex(stack);
        try {
            if (SmoothSwapping.swaps.containsKey(index)) {
                List<InventorySwap> swapList = SmoothSwapping.swaps.get(index);
                boolean renderDestinationSlot = true;
                for (int i = 0; i < swapList.size(); ++i) {
                    InventorySwap swap = swapList.get(i);
                    if (!swap.isChecked() && class_1799.method_7987((class_1799)((class_1799)SmoothSwapping.oldStacks.get(index)), (class_1799)stack)) {
                        swap.setChecked(true);
                        swap.setRenderDestinationSlot(true);
                    } else if (!swap.isChecked()) {
                        swap.setChecked(true);
                    }
                    if (!swap.renderDestinationSlot()) {
                        renderDestinationSlot = false;
                    }
                    ItemRendererMixin.renderSwap(renderer, swap, lastFrameDuration, stack.method_7972(), leftHanded, vertexConsumers, light, overlay, model, zOffset);
                    if (!SwapUtil.hasArrived(swap)) continue;
                    SwapUtil.setRenderToTrue(swapList);
                    swapList.remove(swap);
                }
                if (renderDestinationSlot) {
                    renderer.method_23179(stack.method_7972(), renderMode, leftHanded, matrices, vertexConsumers, light, overlay, model);
                }
                if (swapList.size() == 0) {
                    SmoothSwapping.swaps.remove(index);
                }
                ci.cancel();
            }
        }
        catch (StackOverflowError e) {
            SmoothSwapping.LOGGER.warn("StackOverflowError just happened while trying to render an item swap. This message is a reminder to properly fix an issue #4 described on SmoothSwapping's GitHub");
            SmoothSwapping.swaps.remove(index);
        }
    }

    private void doOverlayRender(class_918 itemRenderer, class_1799 stack, class_327 renderer, int x, int y, CallbackInfo cbi) {
        int index = SwapUtil.getSlotIndex(stack);
        try {
            if (SmoothSwapping.swaps.containsKey(index)) {
                List<InventorySwap> swapList = SmoothSwapping.swaps.get(index);
                int stackCount = stack.method_7947();
                boolean renderToSlot = true;
                for (InventorySwap swap : swapList) {
                    stackCount -= swap.getAmount();
                    if (!swap.renderDestinationSlot()) {
                        renderToSlot = false;
                    }
                    if (swap.getAmount() <= 1) continue;
                    String amount = String.valueOf(swap.getAmount());
                    class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
                    class_4587 textStack = new class_4587();
                    textStack.method_22903();
                    textStack.method_22904(-swap.getX(), -swap.getY(), (double)(this.field_4730 + 250.0f));
                    renderer.method_27521(amount, (float)(x + 19 - 2 - renderer.method_1727(amount)), (float)(y + 6 + 3), 0xFFFFFF, true, textStack.method_23760().method_23761(), (class_4597)immediate, false, 0, 0xF000F0);
                    immediate.method_22993();
                    textStack.method_22909();
                }
                if (renderToSlot && stackCount > 1) {
                    itemRenderer.method_4022(renderer, stack.method_7972(), x, y, String.valueOf(stackCount));
                }
                cbi.cancel();
            }
        }
        catch (StackOverflowError e) {
            SmoothSwapping.LOGGER.warn("StackOverflowError just happened while trying to render an overlay. This message is a reminder to properly fix an issue #4 described on SmoothSwapping's GitHub");
            SmoothSwapping.swaps.remove(index);
        }
    }

    private static void renderSwap(class_918 itemRenderer, InventorySwap swap, float lastFrameDuration, class_1799 stack, boolean leftHanded, class_4597 vertexConsumers, int light, int overlay, class_1087 model, float zOffset) {
        Config config = ConfigManager.getConfig();
        class_4587 matrices = new class_4587();
        matrices.method_22903();
        double x = swap.getX();
        double y = swap.getY();
        float angle = swap.getAngle();
        float progress = SwapUtil.map((float)Math.hypot(x, y), 0.0f, (float)swap.getDistance(), 0.95f, 0.05f);
        matrices.method_22904(-x / 16.0, y / 16.0, (double)(zOffset - 145.0f));
        itemRenderer.method_23179(stack, class_809.class_811.field_4317, leftHanded, matrices, vertexConsumers, light, overlay, model);
        float ease = SwapUtil.getEase(config, progress);
        double speed = swap.getDistance() / 10.0 * (double)ease * (double)config.getAnimationSpeedFormatted();
        swap.setX(x + (double)lastFrameDuration * speed * Math.cos(angle));
        swap.setY(y + (double)lastFrameDuration * speed * Math.sin(angle));
        matrices.method_22909();
    }
}

