/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.client.gui.screens.inventory;

import com.google.common.collect.Lists;
import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ServerConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1718;
import net.minecraft.class_1735;
import net.minecraft.class_1889;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_4587;
import net.minecraft.class_486;
import org.jetbrains.annotations.Nullable;

public class ModEnchantmentScreen
extends class_486 {
    private static final class_2561 REROLL_ENCHANTMENTS_TOOLTIP = new class_2588("container.enchant.reroll").method_27692(class_124.field_1080);
    private final List<List<class_1889>> slotData = IntStream.range(0, 3).mapToObj(i -> Lists.newArrayList()).collect(Collectors.toList());

    public ModEnchantmentScreen(class_1718 container, class_1661 playerInventory, class_2561 textComponent) {
        super(container, playerInventory, textComponent);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (((ServerConfig)EasyMagic.CONFIG.server()).rerollEnchantments == ServerConfig.ReRollEnchantments.WITH_COST) {
            int startX = this.field_2776 + 15;
            int startY = this.field_2800 + 14;
            if ((double)startX <= mouseX && mouseX < (double)(startX + 36) && (double)startY <= mouseY && mouseY < (double)(startY + 31) && ((class_1718)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, 4)) {
                this.field_22787.field_1761.method_2900(((class_1718)this.field_2797).field_7763, 4);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        int slot = this.getEnchantingSlot(mouseX, mouseY);
        if (slot != -1) {
            if (!this.slotData.get(slot).isEmpty()) {
                ArrayList tooltip = Lists.newArrayList();
                this.addSlotEnchantments(slot, this.slotData.get(slot), tooltip);
                this.method_30901(matrixStack, tooltip, mouseX, mouseY);
            }
        } else if (((ServerConfig)EasyMagic.CONFIG.server()).rerollEnchantments == ServerConfig.ReRollEnchantments.WITH_COST) {
            int startX = this.field_2776 + 15;
            int startY = this.field_2800 + 14;
            if (startX <= mouseX && mouseX < startX + 36 && startY <= mouseY && mouseY < startY + 31) {
                ArrayList tooltip = Lists.newArrayList();
                this.addRerollTooltipInfo(tooltip);
                this.method_30901(matrixStack, tooltip, mouseX, mouseY);
            }
        }
    }

    protected boolean method_2378(int x, int y, int width, int height, double mouseX, double mouseY) {
        if (this.getSelectedSlot(mouseX, mouseY) != null) {
            return super.method_2378(x, y, width, height, mouseX, mouseY);
        }
        return false;
    }

    @Nullable
    private class_1735 getSelectedSlot(double mouseX, double mouseY) {
        for (int i = 0; i < ((class_1718)this.field_2797).field_7761.size(); ++i) {
            class_1735 slot = (class_1735)((class_1718)this.field_2797).field_7761.get(i);
            if (!this.isSlotSelected(slot, mouseX, mouseY) || !slot.method_7682()) continue;
            return slot;
        }
        return null;
    }

    private boolean isSlotSelected(class_1735 slotIn, double mouseX, double mouseY) {
        return super.method_2378(slotIn.field_7873, slotIn.field_7872, 16, 16, mouseX, mouseY);
    }

    private int getEnchantingSlot(int mouseX, int mouseY) {
        for (int j = 0; j < 3; ++j) {
            int levels = ((class_1718)this.field_2797).field_7808[j];
            if (!super.method_2378(60, 14 + 19 * j, 108, 17, (double)mouseX, (double)mouseY) || levels <= 0) continue;
            return j;
        }
        return -1;
    }

    public void setSlotData(int slot, List<class_1889> data) {
        this.slotData.set(slot, data);
    }

    private void addSlotEnchantments(int slot, List<class_1889> slotData, List<class_2561> slotTooltip) {
        boolean hasValidEnchantment = slotData.isEmpty();
        for (class_1889 data : slotData) {
            if (data.field_9093 == null) continue;
            slotTooltip.add((class_2561)new class_2588("container.enchant.clue", new Object[]{data.field_9093.method_8179(data.field_9094)}).method_27692(class_124.field_1080));
            hasValidEnchantment = true;
        }
        this.addSlotInfo(slot, slotTooltip, hasValidEnchantment);
    }

    private void addSlotInfo(int slot, List<class_2561> slotTooltip, boolean hasValidEnchantment) {
        ArrayList additionalTooltip = Lists.newArrayList();
        if (hasValidEnchantment && !this.field_22787.field_1724.method_31549().field_7477) {
            int enchantLevels = ((class_1718)this.field_2797).field_7808[slot];
            if (this.field_22787.field_1724.field_7520 < enchantLevels) {
                additionalTooltip.add(new class_2588("container.enchant.level.requirement", new Object[]{enchantLevels}).method_27692(class_124.field_1061));
            } else {
                this.addLapisComponent(++slot, additionalTooltip);
                this.addLevelComponent(slot, additionalTooltip);
            }
        }
        if (!additionalTooltip.isEmpty()) {
            if (!slotTooltip.isEmpty()) {
                slotTooltip.add(class_2585.field_24366);
            }
            slotTooltip.addAll(additionalTooltip);
        }
    }

    private void addLapisComponent(int amount, List<class_2561> tooltip) {
        class_2588 component = amount == 1 ? new class_2588("container.enchant.lapis.one") : new class_2588("container.enchant.lapis.many", new Object[]{amount});
        tooltip.add((class_2561)component.method_27692(((class_1718)this.field_2797).method_7638() >= amount ? class_124.field_1080 : class_124.field_1061));
    }

    private void addLevelComponent(int amount, List<class_2561> tooltip) {
        class_2588 component = amount == 1 ? new class_2588("container.enchant.level.one") : new class_2588("container.enchant.level.many", new Object[]{amount});
        tooltip.add((class_2561)component.method_27692(this.field_22787.field_1724.field_7520 >= amount ? class_124.field_1080 : class_124.field_1061));
    }

    private void addRerollTooltipInfo(List<class_2561> tooltip) {
        tooltip.add(REROLL_ENCHANTMENTS_TOOLTIP);
        ArrayList additionalTooltip = Lists.newArrayList();
        if (!this.field_22787.field_1724.method_31549().field_7477) {
            if (((ServerConfig)EasyMagic.CONFIG.server()).rerollLapisCost > 0) {
                this.addLapisComponent(((ServerConfig)EasyMagic.CONFIG.server()).rerollLapisCost, additionalTooltip);
            }
            if (((ServerConfig)EasyMagic.CONFIG.server()).rerollLevelCost > 0) {
                this.addLevelComponent(((ServerConfig)EasyMagic.CONFIG.server()).rerollLevelCost, additionalTooltip);
            }
        }
        if (!additionalTooltip.isEmpty()) {
            tooltip.add(class_2585.field_24366);
            tooltip.addAll(additionalTooltip);
        }
    }
}

