/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.client.renderer.blockentity;

import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_1160;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2605;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_809;
import net.minecraft.class_828;
import org.jetbrains.annotations.Nullable;

public class ModEnchantTableRenderer
extends class_828 {
    public ModEnchantTableRenderer(class_5614.class_5615 pContext) {
        super(pContext);
    }

    public void method_3571(class_2605 tileEntityIn, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        super.method_3571(tileEntityIn, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        class_1799 itemToEnchant = ((class_1263)tileEntityIn).method_5438(0);
        class_1799 catalystItem = ((class_1263)tileEntityIn).method_5438(1);
        int catalystCount = Math.min(catalystItem.method_7947(), 3);
        int posData = (int)tileEntityIn.method_11016().method_10063();
        switch (((ClientConfig)EasyMagic.CONFIG.client()).renderContentsType) {
            case FLAT: {
                List<class_1799> flatItems = this.getInventoryItemList(itemToEnchant, catalystItem, catalystCount);
                this.renderFlatItemList(flatItems, tileEntityIn.method_11016(), matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, posData);
                break;
            }
            case FLOATING: {
                List<class_1799> floatingItems = this.getInventoryItemList(itemToEnchant, catalystItem, catalystCount);
                this.renderHoveringItemList(floatingItems, (float)tileEntityIn.field_11961 + partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, false, posData);
                break;
            }
            case FANCY_FLOATING: {
                List<class_1799> fancyFloatingItems = this.getInventoryItemList(class_1799.field_8037, catalystItem, catalystCount);
                this.renderHoveringItem(itemToEnchant, tileEntityIn.method_10997(), (float)tileEntityIn.field_11961 + partialTicks, matrixStackIn, bufferIn, combinedLightIn);
                this.renderHoveringItemList(fancyFloatingItems, (float)tileEntityIn.field_11961 + partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, true, posData);
            }
        }
    }

    private List<class_1799> getInventoryItemList(class_1799 itemToEnchant, class_1799 catalystItem, int catalystCount) {
        ArrayList<class_1799> inventoryItems = new ArrayList<class_1799>(4);
        inventoryItems.add(itemToEnchant);
        for (int i = 0; i < catalystCount; ++i) {
            inventoryItems.add(catalystItem);
        }
        inventoryItems.removeIf(class_1799::method_7960);
        return inventoryItems;
    }

    private void renderFlatItemList(List<class_1799> inventoryItems, class_2338 pos, class_4587 matrixStackIn, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn, int posData) {
        int randomDirection = Math.abs(pos.method_10263() + pos.method_10260()) % 4;
        for (int i = 0; i < inventoryItems.size(); ++i) {
            matrixStackIn.method_22903();
            matrixStackIn.method_22904(0.5, 0.76171875, 0.5);
            class_2350 direction = class_2350.method_10139((int)((i + randomDirection) % 4));
            float horizontalAngle = -direction.method_10144();
            matrixStackIn.method_22907(class_1160.field_20705.method_23214(horizontalAngle));
            matrixStackIn.method_22907(class_1160.field_20703.method_23214(90.0f));
            matrixStackIn.method_22904(-0.3125, -0.3125, 0.0);
            matrixStackIn.method_22905(0.375f, 0.375f, 0.375f);
            class_1799 renderStack = inventoryItems.get(i);
            class_310.method_1551().method_1480().method_23178(renderStack, class_809.class_811.field_4319, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, posData + i);
            matrixStackIn.method_22909();
        }
    }

    private void renderHoveringItemList(List<class_1799> inventoryItems, float age, class_4587 matrixStackIn, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn, boolean rotateItems, int posData) {
        float itemRenderAngle = 360.0f / (float)inventoryItems.size();
        for (int i = 0; i < inventoryItems.size(); ++i) {
            matrixStackIn.method_22903();
            matrixStackIn.method_22904(0.5, 1.0, 0.5);
            matrixStackIn.method_22907(class_1160.field_20705.method_23214((float)i * itemRenderAngle + age));
            matrixStackIn.method_22904(0.75, 0.0, 0.25);
            matrixStackIn.method_22907(class_1160.field_20705.method_23214(rotateItems ? age % 360.0f : 90.0f));
            matrixStackIn.method_22904(0.0, 0.075 * Math.sin(((double)age + (double)i * 10.0) / 5.0), 0.0);
            class_310.method_1551().method_1480().method_23178(inventoryItems.get(i), class_809.class_811.field_4318, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, posData + i);
            matrixStackIn.method_22909();
        }
    }

    private void renderHoveringItem(class_1799 itemToEnchant, @Nullable class_1937 worldIn, float age, class_4587 matrixStackIn, class_4597 bufferIn, int combinedLightIn) {
        matrixStackIn.method_22903();
        matrixStackIn.method_22904(0.5, 1.0, 0.5);
        class_1087 model = class_310.method_1551().method_1480().method_4019(itemToEnchant, worldIn, null, 0);
        float hoverOffset = class_3532.method_15374((float)(age / 10.0f)) * 0.1f + 0.1f;
        float modelYScale = model.method_4709().method_3503((class_809.class_811)class_809.class_811.field_4318).field_4285.method_4945();
        matrixStackIn.method_22904(0.0, (double)(hoverOffset + 0.25f * modelYScale), 0.0);
        matrixStackIn.method_22907(class_1160.field_20705.method_23626(age / 20.0f));
        class_310.method_1551().method_1480().method_23179(itemToEnchant, class_809.class_811.field_4318, false, matrixStackIn, bufferIn, combinedLightIn, class_4608.field_21444, model);
        matrixStackIn.method_22909();
    }
}

