/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.world.inventory;

import com.google.common.collect.Lists;
import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ServerConfig;
import fuzs.easymagic.mixin.accessor.EnchantmentMenuAccessor;
import fuzs.easymagic.mixin.accessor.PlayerAccessor;
import fuzs.easymagic.network.message.S2CEnchantingDataMessage;
import fuzs.easymagic.registry.ModRegistry;
import fuzs.puzzleslib.network.message.Message;
import fuzs.puzzleslib.util.PuzzlesUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1718;
import net.minecraft.class_1735;
import net.minecraft.class_1751;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2331;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;

public class ModEnchantmentMenu
extends class_1718
implements class_1712 {
    private final class_1263 enchantSlots;
    private final class_3914 access;
    private final class_1657 player;
    private final Random random;
    private final class_3915 enchantmentSeed;

    public ModEnchantmentMenu(int id, class_1661 playerInventory) {
        this(id, playerInventory, (class_1263)new class_1277(2), class_3914.field_17304);
    }

    public ModEnchantmentMenu(int id, class_1661 playerInventory, class_1263 inventory, class_3914 worldPosCallable) {
        super(id, playerInventory, worldPosCallable);
        this.enchantSlots = inventory;
        this.access = worldPosCallable;
        this.player = playerInventory.field_7546;
        this.random = ((EnchantmentMenuAccessor)((Object)this)).getRandom();
        this.enchantmentSeed = ((EnchantmentMenuAccessor)((Object)this)).getEnchantmentSeed();
        ((EnchantmentMenuAccessor)((Object)this)).setEnchantSlots(inventory);
        this.field_7761.set(0, (Object)((class_1735)PuzzlesUtil.make((Object)((Object)new EnchantableSlot(inventory, 0, 15, 47)), slot -> {
            slot.field_7874 = 0;
        })));
        this.field_7761.set(1, (Object)((class_1735)PuzzlesUtil.make((Object)((Object)new LapisSlot(inventory, 1, 35, 47)), slot -> {
            slot.field_7874 = 1;
        })));
        this.method_7596(this);
    }

    public class_3917<?> method_17358() {
        return ModRegistry.ENCHANTMENT_MENU_TYPE;
    }

    public void method_7609(class_1263 inventory) {
        if (inventory == this.enchantSlots) {
            class_1799 enchantedItem = inventory.method_5438(0);
            if (!enchantedItem.method_7960() && enchantedItem.method_7923()) {
                this.access.method_17393((world, pos) -> {
                    int power = ((ServerConfig)EasyMagic.CONFIG.server()).maxPower == 0 ? 15 : this.getEnchantingPower((class_1937)world, (class_2338)pos) * 15 / ((ServerConfig)EasyMagic.CONFIG.server()).maxPower;
                    this.random.setSeed(this.enchantmentSeed.method_17407());
                    this.updateLevels(enchantedItem, (class_1937)world, (class_2338)pos, power);
                    this.createClues(enchantedItem);
                    this.method_7623();
                    this.sendEnchantingData(enchantedItem);
                });
            } else {
                this.resetLevelsAndClues();
            }
        }
    }

    public void method_7635(class_1703 abstractContainerMenu, int i, class_1799 itemStack) {
        if (abstractContainerMenu == this) {
            this.access.method_17393((Level, BlockPos) -> {
                if (i == 0 && !itemStack.method_7960() && ((ServerConfig)EasyMagic.CONFIG.server()).rerollEnchantments == ServerConfig.ReRollEnchantments.FREE) {
                    this.reRollEnchantments(false);
                }
                if (i >= 0 && i < 2) {
                    this.method_7609(this.enchantSlots);
                }
            });
        }
    }

    private void reRollEnchantments(boolean setPlayerSeed) {
        this.enchantmentSeed.method_17404(this.player.method_6051().nextInt());
        if (setPlayerSeed) {
            ((PlayerAccessor)this.player).setEnchantmentSeed(this.enchantmentSeed.method_17407());
        }
    }

    public void method_7633(class_1703 abstractContainerMenu, int i, int j) {
    }

    private void resetLevelsAndClues() {
        for (int i = 0; i < 3; ++i) {
            this.field_7808[i] = 0;
            this.field_7812[i] = -1;
            this.field_7810[i] = -1;
        }
    }

    private void updateLevels(class_1799 itemstack, class_1937 world, class_2338 pos, int power) {
        for (int i1 = 0; i1 < 3; ++i1) {
            this.field_7808[i1] = class_1890.method_8227((Random)this.random, (int)i1, (int)power, (class_1799)itemstack);
            if (this.field_7808[i1] >= i1 + 1) continue;
            this.field_7808[i1] = 0;
        }
    }

    private void createClues(class_1799 itemstack) {
        for (int j1 = 0; j1 < 3; ++j1) {
            List<class_1889> list;
            if (this.field_7808[j1] <= 0 || (list = this.createEnchantmentInstance(itemstack, j1)) == null || list.isEmpty()) continue;
            class_1889 enchantmentdata = list.get(this.random.nextInt(list.size()));
            this.field_7812[j1] = class_2378.field_11160.method_10206((Object)enchantmentdata.field_9093);
            this.field_7810[j1] = enchantmentdata.field_9094;
        }
    }

    private List<class_1889> createEnchantmentInstance(class_1799 enchantedItem, int enchantSlot) {
        return ((EnchantmentMenuAccessor)((Object)this)).callGetEnchantmentList(enchantedItem, enchantSlot, this.field_7808[enchantSlot]);
    }

    private List<class_1889> getEnchantmentHint(class_1799 enchantedItem, int enchantSlot, ServerConfig.ShowEnchantments showEnchantments) {
        return switch (showEnchantments) {
            default -> throw new IncompatibleClassChangeError();
            case ServerConfig.ShowEnchantments.NONE -> Lists.newArrayList();
            case ServerConfig.ShowEnchantments.SINGLE -> {
                List<class_1889> enchantmentData = this.createEnchantmentInstance(enchantedItem, enchantSlot);
                if (enchantmentData.isEmpty()) {
                    yield Lists.newArrayList();
                }
                yield Lists.newArrayList((Object[])new class_1889[]{enchantmentData.get(this.random.nextInt(enchantmentData.size()))});
            }
            case ServerConfig.ShowEnchantments.ALL -> this.createEnchantmentInstance(enchantedItem, enchantSlot);
        };
    }

    private void sendEnchantingData(class_1799 enchantedItem) {
        ServerConfig.ShowEnchantments showEnchantments = ((ServerConfig)EasyMagic.CONFIG.server()).showEnchantments;
        List<class_1889> firstSlotData = this.getEnchantmentHint(enchantedItem, 0, showEnchantments);
        List<class_1889> secondSlotData = this.getEnchantmentHint(enchantedItem, 1, showEnchantments);
        List<class_1889> thirdSlotData = this.getEnchantmentHint(enchantedItem, 2, showEnchantments);
        EasyMagic.NETWORK.sendTo((Message)new S2CEnchantingDataMessage(this.field_7763, firstSlotData, secondSlotData, thirdSlotData), (class_3222)this.player);
    }

    private int getEnchantingPower(class_1937 level, class_2338 pos) {
        float j = 0.0f;
        for (class_2338 blockpos : class_2331.field_36535) {
            if (!class_2331.method_40445((class_1937)level, (class_2338)pos, (class_2338)blockpos)) continue;
            j += ModEnchantmentMenu.getEnchantPowerBonus(level.method_8320(pos.method_10081((class_2382)blockpos)), level, pos.method_10081((class_2382)blockpos));
        }
        return (int)j;
    }

    public static boolean isBlockEmpty(class_1937 world, class_2338 pos) {
        if (((ServerConfig)EasyMagic.CONFIG.server()).lenientBookshelves) {
            return world.method_8320(pos).method_26220((class_1922)world, pos).method_1110();
        }
        return world.method_22347(pos);
    }

    public static float getEnchantPowerBonus(class_2680 state, class_1937 level, class_2338 pos) {
        return state.method_27852(class_2246.field_10504) ? 1.0f : 0.0f;
    }

    public boolean method_7604(class_1657 player, int data) {
        if (data == 4) {
            class_1799 itemstack;
            if (((ServerConfig)EasyMagic.CONFIG.server()).rerollEnchantments == ServerConfig.ReRollEnchantments.WITH_COST && ((itemstack = this.enchantSlots.method_5438(1)).method_7947() >= ((ServerConfig)EasyMagic.CONFIG.server()).rerollLapisCost && player.field_7520 >= ((ServerConfig)EasyMagic.CONFIG.server()).rerollLevelCost || player.method_31549().field_7477)) {
                this.access.method_17393((level, pos) -> {
                    this.reRollEnchantments(true);
                    if (!player.method_31549().field_7477) {
                        if (((ServerConfig)EasyMagic.CONFIG.server()).rerollLapisCost > 0) {
                            itemstack.method_7934(((ServerConfig)EasyMagic.CONFIG.server()).rerollLapisCost);
                            if (itemstack.method_7960()) {
                                this.enchantSlots.method_5447(1, class_1799.field_8037);
                            }
                        }
                        if (((ServerConfig)EasyMagic.CONFIG.server()).rerollLevelCost > 0) {
                            player.method_7316(-((ServerConfig)EasyMagic.CONFIG.server()).rerollLevelCost);
                        }
                    }
                    this.enchantSlots.method_5431();
                    this.method_7609(this.enchantSlots);
                    level.method_8396(null, pos, class_3417.field_15119, class_3419.field_15245, 1.0f, level.field_9229.nextFloat() * 0.1f + 0.9f);
                });
                return true;
            }
            return false;
        }
        return super.method_7604(player, data);
    }

    public boolean method_7597(class_1657 playerIn) {
        return this.enchantSlots.method_5443(playerIn);
    }

    public void method_7595(class_1657 playerIn) {
        class_1799 itemstack;
        if (playerIn instanceof class_3222 && !(itemstack = this.method_34255()).method_7960()) {
            if (playerIn.method_5805() && !((class_3222)playerIn).method_14239()) {
                playerIn.method_31548().method_7398(itemstack);
            } else {
                playerIn.method_7328(itemstack, false);
            }
            this.method_34254(class_1799.field_8037);
        }
    }

    private static class EnchantableSlot
    extends class_1735 {
        public EnchantableSlot(class_1263 inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean method_7680(class_1799 stack) {
            if (((ServerConfig)EasyMagic.CONFIG.server()).filterTable) {
                return stack.method_7923() || stack.method_7909() instanceof class_1751 && !this.method_7681();
            }
            return true;
        }

        public int method_7675() {
            return 1;
        }
    }

    private static class LapisSlot
    extends class_1735 {
        public LapisSlot(class_1263 inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean method_7680(class_1799 stack) {
            return stack.method_31574(class_1802.field_8759);
        }
    }
}

