/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.icker.factions.database.Ally;
import io.icker.factions.database.Faction;
import io.icker.factions.database.Member;
import io.icker.factions.util.Message;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_3222;

public class AllyCommand {
    public static int add(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(context, (String)"player");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        Faction sourceFaction = Member.get(player.method_5667()).getFaction();
        Faction targetFaction = Member.get(target.method_5667()).getFaction();
        if (Ally.checkIfAlly(sourceFaction.name, targetFaction.name) || Ally.checkIfAllyInvite(sourceFaction.name, targetFaction.name)) {
            new Message(targetFaction.name + " is already allied or invited").format(class_124.field_1061).send((class_1657)player, false);
        } else if (sourceFaction.name == targetFaction.name) {
            new Message("You can't ally yourself").format(class_124.field_1061).send((class_1657)player, false);
        } else {
            Ally.add(sourceFaction.name, targetFaction.name);
            new Message(targetFaction.name + " is now invited to be an ally").send((class_1657)player, false);
            new Message("You have been invited to be an ally with " + sourceFaction.name).format(class_124.field_1054).hover("Click to accept the invitation").click("/factions ally accept " + source.method_9214()).send((class_1657)target, false);
        }
        return 1;
    }

    public static int accept(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(context, (String)"player");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        Faction targetFaction = Member.get(player.method_5667()).getFaction();
        Faction sourceFaction = Member.get(target.method_5667()).getFaction();
        if (Ally.checkIfAlly(sourceFaction.name, targetFaction.name) || !Ally.checkIfAllyInvite(sourceFaction.name, targetFaction.name)) {
            new Message(targetFaction.name + " is already allied or has not invited you").format(class_124.field_1061).send((class_1657)player, false);
        } else if (sourceFaction.name == targetFaction.name) {
            new Message("You can't ally yourself").format(class_124.field_1061).send((class_1657)player, false);
        } else {
            Ally.accept(sourceFaction.name, targetFaction.name);
            new Message(targetFaction.name + " is now an ally").send((class_1657)player, false);
            new Message("You are now allies with " + sourceFaction.name).format(class_124.field_1054).send((class_1657)target, false);
        }
        return 1;
    }

    public static int list(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        Faction faction = Member.get(player.method_5667()).getFaction();
        ArrayList<Ally> invites = Ally.getAllyInvites(faction.name);
        for (Ally ally : invites) {
            new Message(ally.source + " has invited you").format(class_124.field_1054).hover("Click to accept them as an ally").click("/factions ally accept " + ally.source).send((class_1657)player, false);
        }
        return 1;
    }

    public static int remove(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(context, (String)"player");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        Faction sourceFaction = Member.get(player.method_5667()).getFaction();
        Faction targetFaction = Member.get(target.method_5667()).getFaction();
        if (!Ally.checkIfAlly(sourceFaction.name, targetFaction.name)) {
            new Message(targetFaction.name + " is not allied").format(class_124.field_1061).send((class_1657)player, false);
        } else {
            Ally.remove(sourceFaction.name, targetFaction.name);
            new Message(target.method_5477().getString() + " is no longer allied").send(sourceFaction);
            new Message("You are no longer allies with " + sourceFaction.name).format(class_124.field_1054).send((class_1657)target, false);
        }
        return 1;
    }
}

