/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.icker.factions.database.Claim;
import io.icker.factions.database.Faction;
import io.icker.factions.database.Member;
import io.icker.factions.database.PlayerConfig;
import io.icker.factions.util.Message;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ClaimCommand {
    public static int list(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        ArrayList<Claim> claims = Member.get(player.method_5667()).getFaction().getClaims();
        int count = claims.size();
        new Message("You have ").add(new Message(String.valueOf(count)).format(class_124.field_1054)).add(" claim%s", count == 1 ? "" : "s").send((class_1657)source.method_9207(), false);
        if (count == 0) {
            return 1;
        }
        String claimText = claims.stream().map(claim -> String.format("(%d, %d)", claim.x, claim.z)).collect(Collectors.joining(", "));
        new Message(claimText).format(class_124.field_1056).send((class_1657)source.method_9207(), false);
        return 1;
    }

    public static int add(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        class_3218 world = player.method_14220();
        class_1923 chunkPos = world.method_22350(player.method_24515()).method_12004();
        String dimension = world.method_27983().method_29177().toString();
        Member member = Member.get(player.method_5667());
        Claim existingClaim = Claim.get(chunkPos.field_9181, chunkPos.field_9180, dimension);
        if (existingClaim == null) {
            Faction faction = member.getFaction();
            faction.addClaim(chunkPos.field_9181, chunkPos.field_9180, dimension);
            new Message("%s claimed chunk (%d, %d)", player.method_5477().method_10851(), chunkPos.field_9181, chunkPos.field_9180).send(faction);
            return 1;
        }
        String owner = existingClaim.getFaction().name == member.getFaction().name ? "Your" : "Another";
        new Message(owner + " faction already owns this chunk").fail().send((class_1657)player, false);
        return 0;
    }

    public static int remove(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        class_3218 world = player.method_14220();
        class_1923 chunkPos = world.method_22350(player.method_24515()).method_12004();
        String dimension = world.method_27983().method_29177().toString();
        Claim existingClaim = Claim.get(chunkPos.field_9181, chunkPos.field_9180, dimension);
        if (existingClaim == null) {
            new Message("Cannot remove a claim on an unclaimed chunk").fail().send((class_1657)player, false);
            return 0;
        }
        Faction faction = Member.get(player.method_5667()).getFaction();
        PlayerConfig config = PlayerConfig.get(player.method_5667());
        if (existingClaim.getFaction().name != faction.name && !config.bypass) {
            new Message("Cannot remove a claim owned by another faction").fail().send((class_1657)player, false);
            return 0;
        }
        existingClaim.remove();
        new Message("%s removed claim at chunk (%d, %d)", player.method_5477().method_10851(), existingClaim.x, existingClaim.z).send(faction);
        return 1;
    }

    public static int removeAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        Faction faction = Member.get(player.method_5667()).getFaction();
        faction.removeAllClaims();
        new Message("%s removed all claims", player.method_5477().method_10851()).send(faction);
        return 1;
    }
}

