/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.icker.factions.command.AdminCommand;
import io.icker.factions.command.AllyCommand;
import io.icker.factions.command.BypassCommand;
import io.icker.factions.command.ChatCommand;
import io.icker.factions.command.ClaimCommand;
import io.icker.factions.command.CreateCommand;
import io.icker.factions.command.DisbandCommand;
import io.icker.factions.command.HomeCommand;
import io.icker.factions.command.InfoCommand;
import io.icker.factions.command.InviteCommand;
import io.icker.factions.command.JoinCommand;
import io.icker.factions.command.KickMemberCommand;
import io.icker.factions.command.LeaveCommand;
import io.icker.factions.command.ListCommand;
import io.icker.factions.command.MapCommand;
import io.icker.factions.command.ModifyCommand;
import io.icker.factions.command.RankCommand;
import io.icker.factions.command.TransferOwnerCommand;
import io.icker.factions.config.Config;
import io.icker.factions.database.Member;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2177;
import net.minecraft.class_2186;
import net.minecraft.class_3222;

public class CommandRegistry {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralCommandNode factions = class_2170.method_9247((String)"factions").build();
        LiteralCommandNode alias = ((LiteralArgumentBuilder)class_2170.method_9247((String)"f").redirect((CommandNode)factions)).build();
        LiteralCommandNode create = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"create").requires(CommandRegistry::isFactionless)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes((Command)new CreateCommand()))).build();
        LiteralCommandNode disband = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"disband").requires(CommandRegistry::isOwner)).executes((Command)new DisbandCommand())).build();
        LiteralCommandNode join = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"join").requires(CommandRegistry::isFactionless)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes((Command)new JoinCommand()))).build();
        LiteralCommandNode leave = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"leave").requires(s -> CommandRegistry.isFactionMember(s) && !CommandRegistry.isOwner(s))).executes((Command)new LeaveCommand())).build();
        LiteralCommandNode info = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"info").executes(InfoCommand::self)).then(class_2170.method_9244((String)"faction", (ArgumentType)StringArgumentType.greedyString()).executes(InfoCommand::any))).build();
        LiteralCommandNode list = ((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes((Command)new ListCommand())).build();
        LiteralCommandNode chat = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"chat").then(class_2170.method_9247((String)"global").executes(ChatCommand::global))).then(class_2170.method_9247((String)"faction").executes(ChatCommand::faction))).then(class_2170.method_9247((String)"focus").executes(ChatCommand::focus))).build();
        LiteralCommandNode modify = ((LiteralArgumentBuilder)class_2170.method_9247((String)"modify").requires(CommandRegistry::isRankAboveOfficer)).build();
        LiteralCommandNode description = ((LiteralArgumentBuilder)class_2170.method_9247((String)"description").then(class_2170.method_9244((String)"description", (ArgumentType)StringArgumentType.greedyString()).executes(ModifyCommand::description))).build();
        LiteralCommandNode color = ((LiteralArgumentBuilder)class_2170.method_9247((String)"color").then(class_2170.method_9244((String)"color", (ArgumentType)class_2177.method_9276()).executes(ModifyCommand::color))).build();
        LiteralCommandNode open = ((LiteralArgumentBuilder)class_2170.method_9247((String)"open").then(class_2170.method_9244((String)"open", (ArgumentType)BoolArgumentType.bool()).executes(ModifyCommand::open))).build();
        LiteralCommandNode invite = ((LiteralArgumentBuilder)class_2170.method_9247((String)"invite").requires(CommandRegistry::isRankAboveCivilian)).build();
        LiteralCommandNode listInvites = ((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(InviteCommand::list)).build();
        LiteralCommandNode addInvite = ((LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(InviteCommand::add))).build();
        LiteralCommandNode removeInvite = ((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(InviteCommand::remove))).build();
        LiteralCommandNode ally = ((LiteralArgumentBuilder)class_2170.method_9247((String)"ally").requires(CommandRegistry::isRankAboveCivilian)).build();
        LiteralCommandNode addAlly = ((LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(AllyCommand::add))).build();
        LiteralCommandNode acceptAlly = ((LiteralArgumentBuilder)class_2170.method_9247((String)"accept").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(AllyCommand::accept))).build();
        LiteralCommandNode listAlly = ((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(AllyCommand::list)).build();
        LiteralCommandNode removeAlly = ((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(AllyCommand::remove))).build();
        LiteralCommandNode claim = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"claim").requires(CommandRegistry::isRankAboveCivilian)).executes(ClaimCommand::add)).build();
        LiteralCommandNode listClaim = ((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(ClaimCommand::list)).build();
        LiteralCommandNode removeClaim = ((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").executes(ClaimCommand::remove)).build();
        LiteralCommandNode removeAllClaims = ((LiteralArgumentBuilder)class_2170.method_9247((String)"all").executes(ClaimCommand::removeAll)).build();
        LiteralCommandNode home = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"home").requires(s -> CommandRegistry.isFactionMember(s) && Config.HOME != Config.HomeOptions.DISABLED)).executes(HomeCommand::go)).build();
        LiteralCommandNode setHome = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(CommandRegistry::isRankAboveOfficer)).executes(HomeCommand::set)).build();
        LiteralCommandNode map = ((LiteralArgumentBuilder)class_2170.method_9247((String)"map").executes(MapCommand::show)).build();
        LiteralCommandNode adminBypass = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"bypass").requires(s -> s.method_9259(Config.REQUIRED_BYPASS_LEVEL))).executes((Command)new BypassCommand())).build();
        LiteralCommandNode admin = class_2170.method_9247((String)"admin").build();
        LiteralCommandNode migrateAlly = ((LiteralArgumentBuilder)class_2170.method_9247((String)"migrate").executes(AdminCommand::migrateAlly)).build();
        LiteralCommandNode rank = ((LiteralArgumentBuilder)class_2170.method_9247((String)"rank").requires(CommandRegistry::isRankAboveOfficer)).build();
        LiteralCommandNode promote = ((LiteralArgumentBuilder)class_2170.method_9247((String)"promote").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(RankCommand::promote))).build();
        LiteralCommandNode demote = ((LiteralArgumentBuilder)class_2170.method_9247((String)"demote").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(RankCommand::demote))).build();
        LiteralCommandNode transferOwner = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"transferOwner").requires(CommandRegistry::isOwner)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(c -> new TransferOwnerCommand().run((CommandContext<class_2168>)c)))).build();
        LiteralCommandNode kickMember = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"kickMember").requires(CommandRegistry::isRankAboveOfficer)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(c -> new KickMemberCommand().run((CommandContext<class_2168>)c)))).build();
        dispatcher.getRoot().addChild((CommandNode)factions);
        dispatcher.getRoot().addChild((CommandNode)alias);
        factions.addChild((CommandNode)create);
        factions.addChild((CommandNode)disband);
        factions.addChild((CommandNode)join);
        factions.addChild((CommandNode)leave);
        factions.addChild((CommandNode)info);
        factions.addChild((CommandNode)list);
        factions.addChild((CommandNode)chat);
        factions.addChild((CommandNode)modify);
        modify.addChild((CommandNode)description);
        modify.addChild((CommandNode)color);
        modify.addChild((CommandNode)open);
        factions.addChild((CommandNode)invite);
        invite.addChild((CommandNode)listInvites);
        invite.addChild((CommandNode)addInvite);
        invite.addChild((CommandNode)removeInvite);
        factions.addChild((CommandNode)ally);
        ally.addChild((CommandNode)addAlly);
        ally.addChild((CommandNode)acceptAlly);
        ally.addChild((CommandNode)listAlly);
        ally.addChild((CommandNode)removeAlly);
        factions.addChild((CommandNode)admin);
        admin.addChild((CommandNode)adminBypass);
        factions.addChild((CommandNode)claim);
        claim.addChild((CommandNode)listClaim);
        claim.addChild((CommandNode)removeClaim);
        removeClaim.addChild((CommandNode)removeAllClaims);
        factions.addChild((CommandNode)map);
        factions.addChild((CommandNode)home);
        factions.addChild((CommandNode)rank);
        rank.addChild((CommandNode)promote);
        rank.addChild((CommandNode)demote);
        factions.addChild((CommandNode)transferOwner);
        factions.addChild((CommandNode)kickMember);
        home.addChild((CommandNode)setHome);
    }

    public static boolean isFactionMember(class_2168 source) {
        try {
            class_3222 player = source.method_9207();
            return Member.get(player.method_5667()) != null;
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    public static boolean isFactionless(class_2168 source) {
        return !CommandRegistry.isFactionMember(source);
    }

    public static boolean isCivilian(class_2168 source) {
        try {
            class_3222 player = source.method_9207();
            return CommandRegistry.isFactionMember(source) && Member.get(player.method_5667()).getRank() == Member.Rank.CIVILIAN;
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    public static boolean isOfficer(class_2168 source) {
        try {
            class_3222 player = source.method_9207();
            return CommandRegistry.isFactionMember(source) && Member.get(player.method_5667()).getRank() == Member.Rank.OFFICER;
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    public static boolean isCoOwner(class_2168 source) {
        try {
            class_3222 player = source.method_9207();
            return CommandRegistry.isFactionMember(source) && Member.get(player.method_5667()).getRank() == Member.Rank.CO_OWNER;
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    public static boolean isOwner(class_2168 source) {
        try {
            class_3222 player = source.method_9207();
            return CommandRegistry.isFactionMember(source) && Member.get(player.method_5667()).getRank() == Member.Rank.OWNER;
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    public static boolean isRankAboveOfficer(class_2168 source) {
        return CommandRegistry.isOwner(source) || CommandRegistry.isCoOwner(source);
    }

    public static boolean isRankAboveCivilian(class_2168 source) {
        return CommandRegistry.isOwner(source) || CommandRegistry.isCoOwner(source) || CommandRegistry.isOfficer(source);
    }
}

