/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.icker.factions.config.Config;
import io.icker.factions.database.Claim;
import io.icker.factions.database.Faction;
import io.icker.factions.database.Home;
import io.icker.factions.database.Member;
import io.icker.factions.util.Message;
import net.minecraft.class_1283;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class HomeCommand {
    public static int go(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        Faction faction = Member.get(player.method_5667()).getFaction();
        Home home = faction.getHome();
        if (home == null) {
            new Message("No faction home set").fail().send((class_1657)player, false);
            return 0;
        }
        class_3218 world = player.method_5682().method_3847(class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(home.level)));
        if (HomeCommand.checkLimitToClaim(faction, world, new class_2338(home.x, home.y, home.z))) {
            new Message("Cannot warp home to an unclaimed chunk").fail().send((class_1657)player, false);
            return 0;
        }
        class_1283 tracker = player.method_6066();
        if (tracker.method_35041() == null || tracker.method_5546() > Config.SAFE_TICKS_TO_WARP) {
            player.method_14251(world, home.x, home.y, home.z, home.yaw, home.pitch);
            new Message("Warped to faction home").send((class_1657)player, false);
        } else {
            new Message("Cannot warp while in combat").fail().send((class_1657)player, false);
        }
        return 1;
    }

    public static int set(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        Faction faction = Member.get(player.method_5667()).getFaction();
        if (HomeCommand.checkLimitToClaim(faction, player.method_14220(), player.method_24515())) {
            new Message("Cannot set home to an unclaimed chunk").fail().send((class_1657)player, false);
            return 0;
        }
        Home home = faction.setHome(player.method_23317(), player.method_23318(), player.method_23321(), player.method_5791(), player.method_36455(), player.method_14220().method_27983().method_29177().toString());
        new Message("%s set home to %.2f, %.2f, %.2f", player.method_5477().method_10851(), home.x, home.y, home.z).send(faction);
        return 1;
    }

    private static boolean checkLimitToClaim(Faction faction, class_3218 world, class_2338 pos) {
        if (Config.HOME != Config.HomeOptions.CLAIMS) {
            return false;
        }
        class_1923 chunkPos = world.method_22350(pos).method_12004();
        String dimension = world.method_27983().method_29177().toString();
        Claim possibleClaim = Claim.get(chunkPos.field_9181, chunkPos.field_9180, dimension);
        return possibleClaim == null || possibleClaim.getFaction().name != faction.name;
    }
}

