/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.icker.factions.FactionsMod;
import io.icker.factions.config.Config;
import io.icker.factions.database.Ally;
import io.icker.factions.database.Faction;
import io.icker.factions.database.Member;
import io.icker.factions.util.Message;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_3312;

public class InfoCommand {
    public static int self(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        Member member = Member.get(player.method_5667());
        if (member == null) {
            new Message("Command can only be used whilst in a faction").fail().send((class_1657)player, false);
            return 0;
        }
        return InfoCommand.info(player, member.getFaction());
    }

    public static int any(CommandContext<class_2168> context) throws CommandSyntaxException {
        String factionName = StringArgumentType.getString(context, (String)"faction");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        Faction faction = Faction.get(factionName);
        if (faction == null) {
            new Message("Faction does not exist").fail().send((class_1657)player, false);
            return 0;
        }
        return InfoCommand.info(player, faction);
    }

    public static int info(class_3222 player, Faction faction) {
        ArrayList<Member> members = faction.getMembers();
        ArrayList<Ally> allies = Ally.getAllies(faction.name);
        String memberText = members.size() + (Config.MAX_FACTION_SIZE != -1 ? "/" + Config.MAX_FACTION_SIZE : " member" + (members.size() != 1 ? "s" : ""));
        String allyText = allies.size() + (allies.size() != 1 ? " allies" : " ally");
        class_3312 cache = player.method_5682().method_3793();
        String membersList = members.stream().map(member -> cache.method_14512(member.uuid).orElse(new GameProfile(class_156.field_25140, "{Uncached Player}")).getName()).collect(Collectors.joining(", "));
        String alliesList = allies.stream().map(ally -> ally.target).collect(Collectors.joining(", "));
        int requiredPower = faction.getClaims().size() * Config.CLAIM_WEIGHT;
        int maxPower = Config.BASE_POWER + members.size() * Config.MEMBER_POWER;
        FactionsMod.LOGGER.info(alliesList);
        new Message("").add(new Message(memberText).hover(membersList)).filler("\u00b7").add(new Message(allyText).hover(alliesList)).filler("\u00b7").add(new Message(class_124.field_1060.toString() + faction.power + InfoCommand.slash() + requiredPower + InfoCommand.slash() + maxPower).hover("Current / Required / Max")).prependFaction(faction).send((class_1657)player, false);
        return 1;
    }

    private static String slash() {
        return class_124.field_1080 + " / " + class_124.field_1060;
    }
}

