/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.icker.factions.config.Config;
import io.icker.factions.database.Faction;
import io.icker.factions.database.Invite;
import io.icker.factions.event.FactionEvents;
import io.icker.factions.util.Message;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

public class JoinCommand
implements Command<class_2168> {
    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        Faction faction = Faction.get(name);
        if (faction == null) {
            new Message("Cannot join faction as none exist with that name").fail().send((class_1657)player, false);
            return 0;
        }
        Invite invite = Invite.get(player.method_5667(), faction.name);
        if (!faction.open && invite == null) {
            new Message("Cannot join faction as it is not open and you are not invited").fail().send((class_1657)player, false);
            return 0;
        }
        if (faction.getMembers().size() >= Config.MAX_FACTION_SIZE && Config.MAX_FACTION_SIZE != -1) {
            new Message("Cannot join faction as it is currently full").fail().send((class_1657)player, false);
            return 0;
        }
        if (invite != null) {
            invite.remove();
        }
        faction.addMember(player.method_5667());
        source.method_9211().method_3760().method_14576(player);
        new Message(player.method_5477().method_10851() + " joined").send(faction);
        FactionEvents.adjustPower(faction, Config.MEMBER_POWER);
        return 1;
    }
}

