/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.icker.factions.database.Faction;
import io.icker.factions.database.Member;
import io.icker.factions.util.Message;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_3222;

public class RankCommand {
    public static int promote(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(context, (String)"player");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        if (target.method_5667().equals(player.method_5667())) {
            new Message("You cannot promote yourself").format(class_124.field_1061).send((class_1657)player, false);
            return 0;
        }
        Faction faction = Member.get(player.method_5667()).getFaction();
        for (Member member : faction.getMembers()) {
            if (!member.uuid.equals(target.method_5667())) continue;
            switch (member.getRank()) {
                case CIVILIAN: {
                    member.updateRank(Member.Rank.OFFICER);
                    break;
                }
                case OFFICER: {
                    member.updateRank(Member.Rank.CO_OWNER);
                    break;
                }
                case CO_OWNER: {
                    new Message("You cannot promote a member to owner").format(class_124.field_1061).send((class_1657)player, false);
                    return 0;
                }
                case OWNER: {
                    new Message("You cannot promote the owner").format(class_124.field_1061).send((class_1657)player, false);
                    return 0;
                }
            }
            ((class_2168)context.getSource()).method_9211().method_3760().method_14576(target);
            new Message("Promoted " + target.method_5477().getString() + " to " + Member.get(target.method_5667()).getRank().name().toLowerCase().replace("_", " ")).send((class_1657)player, false);
            return 1;
        }
        new Message(target.method_5477().getString() + " is not in your faction").format(class_124.field_1061).send((class_1657)player, false);
        return 0;
    }

    public static int demote(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(context, (String)"player");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        if (target.method_5667().equals(player.method_5667())) {
            new Message("You cannot demote yourself").format(class_124.field_1061).send((class_1657)player, false);
            return 0;
        }
        Faction faction = Member.get(player.method_5667()).getFaction();
        for (Member member : faction.getMembers()) {
            if (!member.uuid.equals(target.method_5667())) continue;
            switch (member.getRank()) {
                case CIVILIAN: {
                    new Message("You cannot demote a civilian").format(class_124.field_1061).send((class_1657)player, false);
                    return 0;
                }
                case OFFICER: {
                    member.updateRank(Member.Rank.CIVILIAN);
                    break;
                }
                case CO_OWNER: {
                    if (Member.get(player.method_5667()).getRank() == Member.Rank.CO_OWNER) {
                        new Message("You cannot demote a fellow co-owner").format(class_124.field_1061).send((class_1657)player, false);
                        return 0;
                    }
                    member.updateRank(Member.Rank.OFFICER);
                    break;
                }
                case OWNER: {
                    new Message("You cannot demote the owner").format(class_124.field_1061).send((class_1657)player, false);
                    return 0;
                }
            }
            ((class_2168)context.getSource()).method_9211().method_3760().method_14576(target);
            new Message("Demoted " + target.method_5477().getString() + " to " + Member.get(target.method_5667()).getRank().name().toLowerCase().replace("_", " ")).send((class_1657)player, false);
            return 1;
        }
        new Message(target.method_5477().getString() + " is not in your faction").format(class_124.field_1061).send((class_1657)player, false);
        return 0;
    }
}

