/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.database;

import io.icker.factions.FactionsMod;
import io.icker.factions.database.Query;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class Database {
    public static Connection con;

    public static void connect() {
        try {
            con = DriverManager.getConnection("jdbc:h2:./factions/factions");
            new Query("CREATE TABLE IF NOT EXISTS Faction (\n    name VARCHAR(255) PRIMARY KEY,\n    description VARCHAR(255),\n    color VARCHAR(255),\n    open BOOLEAN,\n    power INTEGER\n);\n\nCREATE TABLE IF NOT EXISTS Member (\n    uuid UUID PRIMARY KEY,\n    faction VARCHAR(255),\n    rank ENUM('owner', 'co_owner', 'officer', 'civilian'),\n    FOREIGN KEY(faction) REFERENCES Faction(name) ON DELETE CASCADE\n);\n\nCREATE TABLE IF NOT EXISTS Claim (\n    x INTEGER,\n    z INTEGER,\n    level VARCHAR(255),\n    faction VARCHAR(255),\n    PRIMARY KEY(x, z, level),\n    FOREIGN KEY(faction) REFERENCES Faction(name) ON DELETE CASCADE\n);\n\nCREATE TABLE IF NOT EXISTS Invite (\n    player UUID,\n    faction VARCHAR(255),\n    PRIMARY KEY (player, faction),\n    FOREIGN KEY(faction) REFERENCES Faction(name) ON DELETE CASCADE\n);\n\nCREATE TABLE IF NOT EXISTS Home (\n    faction VARCHAR(255),\n    x DOUBLE,\n    y DOUBLE,\n    z DOUBLE,\n    yaw REAL,\n    pitch REAL,\n    level VARCHAR(255),\n    FOREIGN KEY(faction) REFERENCES Faction(name) ON DELETE CASCADE\n);\n\nCREATE TABLE IF NOT EXISTS PlayerConfig (\n    uuid UUID PRIMARY KEY,\n    chat VARCHAR(255),\n    bypass BOOLEAN\n);\n\nCREATE TABLE IF NOT EXISTS Allies (\n    source VARCHAR(255),\n    target VARCHAR(255),\n    accept BOOL,\n    FOREIGN KEY(source) REFERENCES Faction(name) ON DELETE CASCADE,\n    FOREIGN KEY(target) REFERENCES Faction(name) ON DELETE CASCADE\n);\n").executeUpdate();
            FactionsMod.LOGGER.info("Successfully connected to database");
        }
        catch (SQLException e) {
            e.printStackTrace();
            FactionsMod.LOGGER.error("Error connecting to and setting up database");
        }
    }

    public static void disconnect() {
        try {
            con.close();
            FactionsMod.LOGGER.info("Successfully disconnected from database");
        }
        catch (SQLException e) {
            FactionsMod.LOGGER.error("Error disconnecting from database");
        }
    }
}

