/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.database;

import io.icker.factions.database.Query;
import java.util.UUID;

public class PlayerConfig {
    public UUID uuid;
    public ChatOption chat;
    public boolean bypass;

    public static PlayerConfig get(UUID uuid) {
        ChatOption opt;
        Query query = new Query("SELECT * FROM PlayerConfig WHERE uuid = ?;").set(uuid).executeQuery();
        if (!query.success) {
            return new PlayerConfig(uuid, ChatOption.GLOBAL, false);
        }
        try {
            opt = Enum.valueOf(ChatOption.class, query.getString("chat"));
        }
        catch (IllegalArgumentException e) {
            opt = ChatOption.GLOBAL;
        }
        return new PlayerConfig(uuid, opt, query.getBool("bypass"));
    }

    public PlayerConfig(UUID uuid, ChatOption chat, boolean bypass) {
        this.uuid = uuid;
        this.chat = chat;
        this.bypass = bypass;
    }

    public void setChat(ChatOption chat) {
        new Query("MERGE INTO PlayerConfig KEY (uuid) VALUES (?, ?, ?);").set(this.uuid, chat.toString(), this.bypass).executeUpdate();
    }

    public void setBypass(boolean bypass) {
        new Query("MERGE INTO PlayerConfig KEY (uuid) VALUES (?, ?, ?);").set(this.uuid, this.chat.toString(), bypass).executeUpdate();
    }

    public static enum ChatOption {
        FOCUS,
        FACTION,
        GLOBAL;

    }
}

