/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.database;

import io.icker.factions.FactionsMod;
import io.icker.factions.database.Database;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Query {
    private PreparedStatement statement;
    private ResultSet result;
    private String query;
    private int paramIndex = 1;
    private boolean skippedNext = false;
    boolean success;

    public Query(String query) {
        this.query = query;
        try {
            this.statement = Database.con.prepareStatement(query);
        }
        catch (SQLException e) {
            this.error();
        }
    }

    public Query set(Object ... items) {
        try {
            for (Object item : items) {
                this.statement.setObject(this.paramIndex, item);
                ++this.paramIndex;
            }
        }
        catch (SQLException e) {
            this.error();
        }
        return this;
    }

    public String getString(String columnName) {
        try {
            return this.result.getString(columnName);
        }
        catch (SQLException e) {
            this.error();
            return null;
        }
    }

    public int getInt(String columnName) {
        try {
            return this.result.getInt(columnName);
        }
        catch (SQLException e) {
            this.error();
            return 0;
        }
    }

    public double getDouble(String columnName) {
        try {
            return this.result.getDouble(columnName);
        }
        catch (SQLException e) {
            this.error();
            return 0.0;
        }
    }

    public float getFloat(String columnName) {
        try {
            return this.result.getFloat(columnName);
        }
        catch (SQLException e) {
            this.error();
            return 0.0f;
        }
    }

    public boolean getBool(String columnName) {
        try {
            return this.result.getBoolean(columnName);
        }
        catch (SQLException e) {
            this.error();
            return false;
        }
    }

    public Object getObject(String columnName) {
        try {
            return this.result.getObject(columnName);
        }
        catch (SQLException e) {
            this.error();
            return false;
        }
    }

    public Query executeUpdate() {
        try {
            int affectedRows = this.statement.executeUpdate();
            this.success = affectedRows != 0;
        }
        catch (SQLException e) {
            this.error();
        }
        return this;
    }

    public Query executeQuery() {
        try {
            this.result = this.statement.executeQuery();
            this.success = this.result.next();
        }
        catch (SQLException e) {
            this.error();
        }
        return this;
    }

    public boolean next() {
        try {
            if (this.skippedNext) {
                return this.result.next();
            }
        }
        catch (SQLException e) {
            this.error();
        }
        this.skippedNext = true;
        return this.success;
    }

    public boolean exists() {
        try {
            return this.result.getBoolean(1);
        }
        catch (SQLException e) {
            this.error();
            return false;
        }
    }

    private void error() {
        FactionsMod.LOGGER.error("Error executing database transaction {}", (Object)this.query);
    }
}

