/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.event;

import io.icker.factions.config.Config;
import io.icker.factions.database.Ally;
import io.icker.factions.database.Claim;
import io.icker.factions.database.Faction;
import io.icker.factions.database.Member;
import io.icker.factions.database.PlayerConfig;
import io.icker.factions.mixin.BucketItemMixin;
import io.icker.factions.mixin.ItemMixin;
import io.icker.factions.util.Message;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class PlayerInteractEvents {
    public static boolean preventInteract(class_3222 player, class_1937 world, class_3965 result) {
        class_2338 pos = result.method_17777();
        class_2338 placePos = pos.method_10081(result.method_17780().method_10163());
        return !PlayerInteractEvents.actionPermitted(pos, world, player) || !PlayerInteractEvents.actionPermitted(placePos, world, player);
    }

    public static boolean preventUseItem(class_3222 player, class_1937 world, class_1799 stack) {
        class_3611 fluid;
        class_3959.class_242 handling;
        class_3965 result;
        class_1792 item = stack.method_7909();
        if (item instanceof class_1755 && (result = ItemMixin.invokeRaycast(world, (class_1657)player, handling = (fluid = ((BucketItemMixin)item).getFluid()) == class_3612.field_15906 ? class_3959.class_242.field_1345 : class_3959.class_242.field_1348)).method_17783() != class_239.class_240.field_1333) {
            return PlayerInteractEvents.preventInteract(player, world, result);
        }
        return false;
    }

    public static boolean preventFriendlyFire(class_3222 player, class_3222 target) {
        Member playerMember = Member.get(player.method_5667());
        Member targetMember = Member.get(target.method_5667());
        if (playerMember == null || targetMember == null) {
            return false;
        }
        return playerMember.getFaction().name == targetMember.getFaction().name;
    }

    public static void warnPlayer(class_3222 target, String action) {
        new Message("Cannot %s in this claim", action).fail().send((class_1657)target, true);
    }

    public static boolean actionPermitted(class_2338 pos, class_1937 world, class_3222 player) {
        boolean permitted;
        boolean overclaimed;
        PlayerConfig config = PlayerConfig.get(player.method_5667());
        if (config.bypass) {
            if (player.method_5687(Config.REQUIRED_BYPASS_LEVEL)) {
                return true;
            }
            config.setBypass(false);
        }
        String dimension = world.method_27983().method_29177().toString();
        class_1923 actionPos = world.method_22350(pos).method_12004();
        Claim claim = Claim.get(actionPos.field_9181, actionPos.field_9180, dimension);
        if (claim == null) {
            return true;
        }
        Member member = Member.get(player.method_5667());
        Faction owner = claim.getFaction();
        boolean bl = overclaimed = owner.getClaims().size() * Config.CLAIM_WEIGHT > owner.power;
        boolean validMember = member == null ? false : member.getFaction().name == owner.name;
        boolean allied = Ally.checkIfAlly(owner.name, member.getFaction().name);
        boolean bl2 = permitted = overclaimed || validMember || allied;
        if (!permitted) {
            PlayerInteractEvents.syncBlocks(player, world, pos);
        }
        return permitted;
    }

    public static void syncItem(class_3222 player, class_1799 itemStack, class_1268 hand) {
        player.method_6122(hand, itemStack);
        itemStack.method_7939(itemStack.method_7947());
        if (itemStack.method_7963()) {
            itemStack.method_7974(itemStack.method_7919());
        }
        if (!player.method_6115()) {
            player.field_7498.method_34252();
        }
    }

    public static void syncBlocks(class_3222 player, class_1937 world, class_2338 pos) {
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    player.field_13987.method_14364((class_2596)new class_2626((class_1922)world, pos.method_10069(x, y, z)));
                }
            }
        }
    }
}

