/*
 * Decompiled with CFR 0.152.
 */
package com.github.crimsondawn45.basicshields.util;

import com.github.crimsondawn45.basicshields.util.ModItem;
import com.github.crimsondawn45.basicshields.util.ModRecipe;
import com.github.crimsondawn45.basicshields.util.ModShieldItem;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class ContentModule {
    public static List<ContentModule> loadedModules = new ArrayList<ContentModule>();
    private List<ModRecipe> recipes = new ArrayList<ModRecipe>();
    private List<ModShieldItem> shields = new ArrayList<ModShieldItem>();
    private boolean isLoaded = false;
    private boolean forceLoaded = false;

    public ContentModule(boolean forceLoad, String ... ids) {
        for (String id : ids) {
            if (!FabricLoader.getInstance().isModLoaded(id)) continue;
            this.isLoaded = true;
        }
        if (forceLoad && !this.isLoaded) {
            this.isLoaded = true;
            this.forceLoaded = true;
        }
        if (this.isLoaded) {
            this.registerContent();
            loadedModules.add(this);
        }
    }

    public ContentModule(boolean forceLoad, boolean isVanillaMaterial, String ... ids) {
        for (String id : ids) {
            if (!FabricLoader.getInstance().isModLoaded(id)) continue;
            this.isLoaded = true;
        }
        if (forceLoad && !this.isLoaded) {
            this.isLoaded = true;
            if (!isVanillaMaterial) {
                this.forceLoaded = true;
            }
        }
        if (this.isLoaded) {
            this.registerContent();
            loadedModules.add(this);
        }
    }

    public ContentModule() {
        this.forceLoaded = false;
        this.isLoaded = true;
        this.registerContent();
        loadedModules.add(this);
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public boolean isForceLoaded() {
        return this.forceLoaded;
    }

    public void registerContent() {
    }

    public void addRecipe(ModItem item, JsonObject recipe) {
        this.recipes.add(new ModRecipe(item, recipe));
    }

    public ModRecipe[] getRecipes() {
        return (ModRecipe[])this.recipes.stream().toArray(ModRecipe[]::new);
    }

    public void addShield(ModShieldItem shield) {
        this.shields.add(shield);
    }

    public ModShieldItem[] getShieldItems() {
        return (ModShieldItem[])this.shields.stream().toArray(ModShieldItem[]::new);
    }
}

