/*
 * Decompiled with CFR 0.152.
 */
package com.github.crimsondawn45.basicshields.util;

import com.github.crimsondawn45.basicshields.util.ModItem;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3494;

public class ModRecipe {
    private ModItem item;
    private JsonObject recipe;

    public ModRecipe(ModItem item, JsonObject recipe) {
        this.item = item;
        this.recipe = recipe;
    }

    public ModItem getModItem() {
        return this.item;
    }

    public JsonObject getRecipe() {
        return this.recipe;
    }

    public static JsonObject createShieldRecipe(class_2960 mainItemId, boolean isMainTag, class_2960 output) {
        String mainType = isMainTag ? "tag" : "item";
        return ModRecipe.createShapedRecipe(Lists.newArrayList((Object[])new Character[]{Character.valueOf('#'), Character.valueOf('i')}), Lists.newArrayList((Object[])new class_2960[]{new class_2960("minecraft", "planks"), mainItemId}), Lists.newArrayList((Object[])new String[]{"tag", mainType}), Lists.newArrayList((Object[])new String[]{"#i#", "###", " # "}), output, 1);
    }

    public static JsonObject createShieldRecipe(ArrayList<class_3494<class_1792>> tags, class_2960 output) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shaped");
        JsonArray pattern = new JsonArray();
        pattern.add("#i#");
        pattern.add("###");
        pattern.add(" # ");
        json.add("pattern", (JsonElement)pattern);
        JsonObject keys = new JsonObject();
        JsonObject plankKey = new JsonObject();
        JsonArray ingotKeyList = new JsonArray();
        plankKey.addProperty("tag", "minecraft:planks");
        keys.add("#", (JsonElement)plankKey);
        for (class_3494<class_1792> tag : tags) {
            JsonObject entry = new JsonObject();
            entry.addProperty("tag", tag.toString());
            ingotKeyList.add((JsonElement)entry);
        }
        keys.add("i", (JsonElement)ingotKeyList);
        json.add("key", (JsonElement)keys);
        JsonObject result = new JsonObject();
        result.addProperty("item", output.toString());
        result.addProperty("count", (Number)1);
        json.add("result", (JsonElement)result);
        return json;
    }

    public static JsonObject createShapedRecipe(ArrayList<Character> keys, ArrayList<class_2960> items, ArrayList<String> type, ArrayList<String> pattern, class_2960 output, int count) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shaped");
        JsonArray jsonArray = new JsonArray();
        jsonArray.add(pattern.get(0));
        jsonArray.add(pattern.get(1));
        jsonArray.add(pattern.get(2));
        json.add("pattern", (JsonElement)jsonArray);
        JsonObject keyList = new JsonObject();
        for (int i = 0; i < keys.size(); ++i) {
            JsonObject individualKey = new JsonObject();
            individualKey.addProperty(type.get(i), items.get(i).toString());
            keyList.add("" + keys.get(i), (JsonElement)individualKey);
        }
        json.add("key", (JsonElement)keyList);
        JsonObject result = new JsonObject();
        result.addProperty("item", output.toString());
        result.addProperty("count", (Number)count);
        json.add("result", (JsonElement)result);
        return json;
    }

    public static JsonObject createSmithingRecipe(class_2960 inputId, boolean isInputTag, class_2960 additionId, boolean isAdditionTag, class_2960 outputId) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:smithing");
        JsonObject base = new JsonObject();
        if (isInputTag) {
            base.addProperty("tag", inputId.toString());
        } else {
            base.addProperty("item", inputId.toString());
        }
        json.add("base", (JsonElement)base);
        JsonObject addition = new JsonObject();
        if (isAdditionTag) {
            addition.addProperty("tag", additionId.toString());
        } else {
            addition.addProperty("item", additionId.toString());
        }
        json.add("addition", (JsonElement)addition);
        JsonObject result = new JsonObject();
        result.addProperty("item", outputId.toString());
        json.add("result", (JsonElement)result);
        return json;
    }
}

