/*
 * Decompiled with CFR 0.152.
 */
package com.github.crimsondawn45.basicshields.util;

import com.github.crimsondawn45.basicshields.util.ContentModule;
import com.github.crimsondawn45.basicshields.util.ModItem;
import com.github.crimsondawn45.basicshields.util.ModRef;
import com.github.crimsondawn45.fabricshieldlib.initializers.FabricShieldLibClient;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.event.client.ClientSpriteRegistryCallback;
import net.minecraft.class_1059;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_600;

public class ModShieldItem
extends ModItem {
    private String shieldTexurePath;
    private List<ModRef> modRefs = new ArrayList<ModRef>();
    @Environment(value=EnvType.CLIENT)
    private class_5601 entityModelLayer;
    @Environment(value=EnvType.CLIENT)
    private class_600 shieldEntityModel;
    @Environment(value=EnvType.CLIENT)
    private class_4730 shieldBaseSprite;
    @Environment(value=EnvType.CLIENT)
    private class_4730 shieldNoPatternSprite;

    public ModShieldItem(ContentModule module, String name, class_1792 item, String shieldTexturePath) {
        super(module, name, item);
        module.addShield(this);
        this.shieldTexurePath = shieldTexturePath;
    }

    public ModShieldItem(ContentModule module, String name, class_1792 item, ModRef ... modReferences) {
        super(module, name, item);
        module.addShield(this);
        for (ModRef ref : modReferences) {
            this.modRefs.add(ref);
        }
    }

    private void setTexturePath(String string) {
        this.shieldTexurePath = string.trim();
    }

    @Environment(value=EnvType.CLIENT)
    public String getBaseTexturePath() {
        return this.shieldTexurePath;
    }

    @Environment(value=EnvType.CLIENT)
    public String getNoPatternTexturePath() {
        return this.shieldTexurePath + "_nopattern";
    }

    @Environment(value=EnvType.CLIENT)
    public void clientShieldInit() {
        ModRef ref;
        this.entityModelLayer = new class_5601(new class_2960("basicshields", this.getName()), "main");
        Iterator<ModRef> iterator = this.modRefs.iterator();
        while (iterator.hasNext()) {
            ref = iterator.next();
            if (!ref.isLoaded()) continue;
            this.setTexturePath(ref.getTexturePath());
            break;
        }
        if (this.getBaseTexturePath() == null && (iterator = this.modRefs.iterator()).hasNext()) {
            ref = iterator.next();
            this.setTexturePath(ref.getTexturePath());
        }
        this.shieldBaseSprite = new class_4730(class_1059.field_5275, new class_2960("basicshields", this.getBaseTexturePath()));
        this.shieldNoPatternSprite = new class_4730(class_1059.field_5275, new class_2960("basicshields", this.getNoPatternTexturePath()));
    }

    public class_4730 getBaseSpriteIdentifier() {
        return this.shieldBaseSprite;
    }

    public class_4730 getNoPatternSpriteIdentifier() {
        return this.shieldNoPatternSprite;
    }

    @Environment(value=EnvType.CLIENT)
    public class_5601 getEntityModelLayer() {
        return this.entityModelLayer;
    }

    @Environment(value=EnvType.CLIENT)
    public void RegisterModelLayer() {
        EntityModelLayerRegistry.registerModelLayer((class_5601)this.getEntityModelLayer(), class_600::method_32039);
        ClientSpriteRegistryCallback.event((class_2960)class_1059.field_5275).register((atlasTexture, registry) -> {
            registry.register(new class_2960("basicshields", this.getBaseTexturePath()));
            registry.register(new class_2960("basicshields", this.getNoPatternTexturePath()));
        });
    }

    @Environment(value=EnvType.CLIENT)
    public void setShieldEntityModel(class_5599 modelLoader) {
        this.shieldEntityModel = new class_600(modelLoader.method_32072(this.getEntityModelLayer()));
    }

    @Environment(value=EnvType.CLIENT)
    public class_600 getShieldEntityModel() {
        return this.shieldEntityModel;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderBanner(class_1799 stack, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        if (stack.method_31574(this.getItem())) {
            FabricShieldLibClient.renderBanner((class_1799)stack, (class_4587)matrices, (class_4597)vertexConsumers, (int)light, (int)overlay, (class_600)this.getShieldEntityModel(), (class_4730)this.getBaseSpriteIdentifier(), (class_4730)this.getNoPatternSpriteIdentifier());
        }
    }
}

