/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.alternate_dimension;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2897;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3229;
import net.minecraft.class_3232;
import net.minecraft.class_5216;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7059;
import net.minecraft.server.MinecraftServer;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.peripheral.alternate_dimension.ErrorTerrainGenerator;
import qouteall.imm_ptl.peripheral.alternate_dimension.NormalSkylandGenerator;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.DimensionAPI;

public class AlternateDimensions {
    public static final class_5321<class_2874> surfaceType = class_5321.method_29179((class_5321)class_2378.field_25095, (class_2960)new class_2960("immersive_portals:surface_type"));
    public static final class_5321<class_1937> alternate1 = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960("immersive_portals:alternate1"));
    public static final class_5321<class_1937> alternate2 = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960("immersive_portals:alternate2"));
    public static final class_5321<class_1937> alternate3 = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960("immersive_portals:alternate3"));
    public static final class_5321<class_1937> alternate4 = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960("immersive_portals:alternate4"));
    public static final class_5321<class_1937> alternate5 = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960("immersive_portals:alternate5"));

    public static void init() {
        DimensionAPI.serverDimensionsLoadEvent.register(AlternateDimensions::initializeAlternateDimensions);
        IPGlobal.postServerTickSignal.connect(AlternateDimensions::tick);
    }

    private static void initializeAlternateDimensions(class_5285 generatorOptions, class_5455 registryManager) {
        class_2378 registry = generatorOptions.method_28609();
        long seed = generatorOptions.method_28028();
        if (!IPGlobal.enableAlternateDimensions) {
            return;
        }
        class_5321 resourceKey = class_5321.method_29179((class_5321)class_2378.field_25095, (class_2960)new class_2960("immersive_portals:surface_type"));
        class_6880 surfaceTypeHolder = (class_6880)registryManager.method_30530(class_2378.field_25095).method_40264(resourceKey).orElseThrow(() -> new RuntimeException("Missing immersive_portals:surface_type"));
        if (surfaceTypeHolder == null) {
            Helper.err((Object)"Missing dimension type immersive_portals:surface_type");
            return;
        }
        DimensionAPI.addDimension((class_2378)registry, (class_2960)alternate1.method_29177(), (class_6880)surfaceTypeHolder, (class_2794)AlternateDimensions.createSkylandGenerator(seed + 1L, registryManager));
        DimensionAPI.markDimensionNonPersistent((class_2960)alternate1.method_29177());
        DimensionAPI.addDimension((class_2378)registry, (class_2960)alternate2.method_29177(), (class_6880)surfaceTypeHolder, (class_2794)AlternateDimensions.createSkylandGenerator(seed, registryManager));
        DimensionAPI.markDimensionNonPersistent((class_2960)alternate2.method_29177());
        DimensionAPI.addDimension((class_2378)registry, (class_2960)alternate3.method_29177(), (class_6880)surfaceTypeHolder, (class_2794)AlternateDimensions.createErrorTerrainGenerator(seed + 1L, registryManager));
        DimensionAPI.markDimensionNonPersistent((class_2960)alternate3.method_29177());
        DimensionAPI.addDimension((class_2378)registry, (class_2960)alternate4.method_29177(), (class_6880)surfaceTypeHolder, (class_2794)AlternateDimensions.createErrorTerrainGenerator(seed, registryManager));
        DimensionAPI.markDimensionNonPersistent((class_2960)alternate4.method_29177());
        DimensionAPI.addDimension((class_2378)registry, (class_2960)alternate5.method_29177(), (class_6880)surfaceTypeHolder, (class_2794)AlternateDimensions.createVoidGenerator(registryManager));
        DimensionAPI.markDimensionNonPersistent((class_2960)alternate5.method_29177());
    }

    public static boolean isAlternateDimension(class_1937 world) {
        class_5321 key = world.method_27983();
        return key == alternate1 || key == alternate2 || key == alternate3 || key == alternate4 || key == alternate5;
    }

    private static void syncWithOverworldTimeWeather(@Nullable class_3218 world, class_3218 overworld) {
        if (world == null) {
            return;
        }
        ((IEWorld)world).portal_setWeather(overworld.method_8430(1.0f), overworld.method_8430(1.0f), overworld.method_8478(1.0f), overworld.method_8478(1.0f));
    }

    public static class_2794 createSkylandGenerator(long seed, class_5455 rm) {
        return NormalSkylandGenerator.create(seed, (class_2378<class_7059>)rm.method_30530(class_2378.field_37227), (class_2378<class_1959>)rm.method_30530(class_2378.field_25114), (class_2378<class_5216.class_5487>)rm.method_30530(class_2378.field_35433));
    }

    public static class_2794 createErrorTerrainGenerator(long seed, class_5455 rm) {
        return ErrorTerrainGenerator.create(seed, (class_2378<class_7059>)rm.method_30530(class_2378.field_37227), (class_2378<class_1959>)rm.method_30530(class_2378.field_25114), (class_2378<class_5216.class_5487>)rm.method_30530(class_2378.field_35433));
    }

    public static class_2794 createVoidGenerator(class_5455 rm) {
        class_2378 biomeRegistry = rm.method_30530(class_2378.field_25114);
        class_2378 structureSets = rm.method_30530(class_2378.field_37227);
        class_3232 flatChunkGeneratorConfig = new class_3232(Optional.empty(), biomeRegistry);
        flatChunkGeneratorConfig.method_14327().add(new class_3229(1, class_2246.field_10124));
        flatChunkGeneratorConfig.method_14330();
        return new class_2897(structureSets, flatChunkGeneratorConfig);
    }

    private static void tick() {
        if (!IPGlobal.enableAlternateDimensions) {
            return;
        }
        class_3218 overworld = McHelper.getServerWorld((class_5321)class_1937.field_25179);
        MinecraftServer server = MiscHelper.getServer();
        AlternateDimensions.syncWithOverworldTimeWeather(server.method_3847(alternate1), overworld);
        AlternateDimensions.syncWithOverworldTimeWeather(server.method_3847(alternate2), overworld);
        AlternateDimensions.syncWithOverworldTimeWeather(server.method_3847(alternate3), overworld);
        AlternateDimensions.syncWithOverworldTimeWeather(server.method_3847(alternate4), overworld);
        AlternateDimensions.syncWithOverworldTimeWeather(server.method_3847(alternate5), overworld);
    }
}

