/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.alternate_dimension;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2826;
import net.minecraft.class_2839;
import net.minecraft.class_2902;
import net.minecraft.class_3754;
import net.minecraft.class_5138;
import net.minecraft.class_5216;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6903;
import net.minecraft.class_7059;
import qouteall.imm_ptl.peripheral.alternate_dimension.ChaosBiomeSource;
import qouteall.imm_ptl.peripheral.alternate_dimension.DelegatedChunkGenerator;
import qouteall.imm_ptl.peripheral.alternate_dimension.RegionErrorTerrainGenerator;
import qouteall.imm_ptl.peripheral.mixin.common.alternate_dimension.IENoiseGeneratorSettings;
import qouteall.q_misc_util.Helper;

public class ErrorTerrainGenerator
extends DelegatedChunkGenerator {
    public static final Codec<ErrorTerrainGenerator> codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(g -> g.seed), (App)class_6903.method_40419((class_5321)class_2378.field_37227).forGetter(g -> g.field_37053), (App)class_6903.method_40419((class_5321)class_2378.field_25114).forGetter(g -> g.biomeRegistry), (App)class_6903.method_40419((class_5321)class_2378.field_35433).forGetter(g -> g.noiseRegistry)).apply((Applicative)instance, ErrorTerrainGenerator::create));
    public static final int regionChunkNum = 4;
    public static final int averageY = 64;
    public static final int maxY = 128;
    private final class_2680 air = class_2246.field_10124.method_9564();
    private final class_2680 defaultBlock = class_2246.field_10340.method_9564();
    private final class_2680 defaultFluid = class_2246.field_10382.method_9564();
    private final LoadingCache<class_1923, RegionErrorTerrainGenerator> cache;
    public final long seed;
    public final class_2378<class_1959> biomeRegistry;
    public final class_2378<class_5216.class_5487> noiseRegistry;

    public static ErrorTerrainGenerator create(Long seed, class_2378<class_7059> structureSets, class_2378<class_1959> biomeRegistry, class_2378<class_5216.class_5487> noiseRegistry) {
        List biomeHolderList = biomeRegistry.method_40270().filter(holder -> holder.method_40237().method_29177().method_12836().equals("minecraft")).collect(Collectors.toList());
        ChaosBiomeSource chaosBiomeSource = new ChaosBiomeSource((class_6885<class_1959>)class_6885.method_40242(biomeHolderList));
        class_5284 skylandSetting = IENoiseGeneratorSettings.ip_floatingIslands();
        class_3754 islandChunkGenerator = new class_3754(structureSets, noiseRegistry, (class_1966)chaosBiomeSource, seed.longValue(), class_6880.method_40223((Object)skylandSetting));
        return new ErrorTerrainGenerator(seed, structureSets, chaosBiomeSource, (class_2794)islandChunkGenerator, biomeRegistry, noiseRegistry);
    }

    public ErrorTerrainGenerator(final long seed, class_2378<class_7059> structureSets, class_1966 biomeSource, class_2794 delegate, class_2378<class_1959> biomeRegistry, class_2378<class_5216.class_5487> noiseRegistry) {
        super(structureSets, biomeSource, delegate);
        this.cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<class_1923, RegionErrorTerrainGenerator>(){

            public RegionErrorTerrainGenerator load(class_1923 key) {
                return new RegionErrorTerrainGenerator(key.field_9181, key.field_9180, seed);
            }
        });
        this.seed = seed;
        this.biomeRegistry = biomeRegistry;
        this.noiseRegistry = noiseRegistry;
    }

    protected Codec<? extends class_2794> method_28506() {
        return codec;
    }

    public class_2794 method_27997(long seed) {
        return new ErrorTerrainGenerator(seed, (class_2378<class_7059>)this.field_37053, this.biomeSource_.method_27985(seed), this.delegate.method_27997(seed), this.biomeRegistry, this.noiseRegistry);
    }

    @Override
    public CompletableFuture<class_2791> method_12088(Executor executor, class_6748 arg, class_5138 structureAccessor, class_2791 chunk) {
        class_2826[] sectionArray = chunk.method_12006();
        ArrayList<class_2826> locked = new ArrayList<class_2826>();
        for (class_2826 chunkSection : sectionArray) {
            if (chunkSection == null) continue;
            chunkSection.method_16676();
            locked.add(chunkSection);
        }
        return CompletableFuture.supplyAsync(() -> {
            this.doPopulateNoise(chunk);
            return chunk;
        }, executor).thenApplyAsync(chunkx -> {
            for (class_2826 chunkSection : locked) {
                chunkSection.method_16677();
            }
            return chunkx;
        }, executor);
    }

    public void doPopulateNoise(class_2791 chunk) {
        class_2839 protoChunk = (class_2839)chunk;
        class_1923 pos = chunk.method_12004();
        class_2902 oceanFloorHeightMap = protoChunk.method_12032(class_2902.class_2903.field_13195);
        class_2902 surfaceHeightMap = protoChunk.method_12032(class_2902.class_2903.field_13194);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int regionX = Math.floorDiv(pos.field_9181, 4);
        int regionZ = Math.floorDiv(pos.field_9180, 4);
        RegionErrorTerrainGenerator generator = (RegionErrorTerrainGenerator)Helper.noError(() -> (RegionErrorTerrainGenerator)this.cache.get((Object)new class_1923(regionX, regionZ)));
        for (int sectionY = 0; sectionY < 16; ++sectionY) {
            class_2826 section = protoChunk.method_38259(sectionY);
            for (int localX = 0; localX < 16; ++localX) {
                for (int localZ = 0; localZ < 16; ++localZ) {
                    for (int localY = 0; localY < 16; ++localY) {
                        int worldX = pos.field_9181 * 16 + localX;
                        int worldY = sectionY * 16 + localY;
                        int worldZ = pos.field_9180 * 16 + localZ;
                        class_2680 currBlockState = generator.getBlockComposition(worldX, worldY, worldZ);
                        if (currBlockState == this.air) continue;
                        section.method_12256(localX, localY, localZ, currBlockState, false);
                        oceanFloorHeightMap.method_12597(localX, worldY, localZ, currBlockState);
                        surfaceHeightMap.method_12597(localX, worldY, localZ, currBlockState);
                    }
                }
            }
        }
    }
}

