/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.altius_world;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.portal.global_portals.VerticalConnectingPortal;
import qouteall.imm_ptl.peripheral.altius_world.AltiusEntry;
import qouteall.imm_ptl.peripheral.altius_world.AltiusManagement;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;

public class AltiusInfo {
    public final boolean loop;
    public final boolean gravityChange;
    public final List<AltiusEntry> entries;

    public AltiusInfo(List<AltiusEntry> entries, boolean loop, boolean gravityChange) {
        this.entries = entries;
        this.loop = loop;
        this.gravityChange = gravityChange;
    }

    public static void initializeFuseViewProperty(Portal portal) {
        if (portal.getNormal().field_1351 < 0.0) {
            portal.fuseView = true;
        }
    }

    public static void createConnectionBetween(AltiusEntry a, AltiusEntry b, boolean gravityChange) {
        class_3218 fromWorld = McHelper.getServerWorld(a.dimension);
        class_3218 toWorld = McHelper.getServerWorld(b.dimension);
        boolean xorFlipped = a.flipped ^ b.flipped;
        int fromWorldMinY = McHelper.getMinY((class_1936)fromWorld);
        if (a.bottomY != null) {
            fromWorldMinY = a.bottomY;
        }
        int fromWorldMaxY = McHelper.getMaxContentYExclusive((class_1936)fromWorld);
        if (a.topY != null) {
            fromWorldMaxY = a.topY;
        }
        int toWorldMinY = McHelper.getMinY((class_1936)toWorld);
        if (b.bottomY != null) {
            toWorldMinY = b.bottomY;
        }
        int toWorldMaxY = McHelper.getMaxContentYExclusive((class_1936)toWorld);
        if (b.topY != null) {
            toWorldMaxY = b.topY;
        }
        VerticalConnectingPortal connectingPortal = VerticalConnectingPortal.createConnectingPortal((class_3218)fromWorld, (VerticalConnectingPortal.ConnectorType)(a.flipped ? VerticalConnectingPortal.ConnectorType.ceil : VerticalConnectingPortal.ConnectorType.floor), (class_3218)toWorld, (double)(b.scale / a.scale), (boolean)xorFlipped, (double)(b.horizontalRotation - a.horizontalRotation), (int)fromWorldMinY, (int)fromWorldMaxY, (int)toWorldMinY, (int)toWorldMaxY);
        VerticalConnectingPortal reverse = (VerticalConnectingPortal)PortalAPI.createReversePortal((Portal)connectingPortal);
        AltiusInfo.initializeFuseViewProperty((Portal)connectingPortal);
        AltiusInfo.initializeFuseViewProperty((Portal)reverse);
        if (gravityChange) {
            connectingPortal.setTeleportChangesGravity(true);
            reverse.setTeleportChangesGravity(true);
        }
        PortalAPI.addGlobalPortal((class_3218)fromWorld, (Portal)connectingPortal);
        PortalAPI.addGlobalPortal((class_3218)toWorld, (Portal)reverse);
    }

    public void apply() {
        if (this.entries.isEmpty()) {
            McHelper.sendMessageToFirstLoggedPlayer((class_2561)new class_2585("Error: No dimension for dimension stack"));
            return;
        }
        MinecraftServer server = MiscHelper.getServer();
        for (AltiusEntry entry : this.entries) {
            if (server.method_3847(entry.dimension) != null) continue;
            McHelper.sendMessageToFirstLoggedPlayer((class_2561)new class_2585("Failed to apply dimension stack. Missing dimension " + entry.dimension.method_29177()));
            return;
        }
        if (!GlobalPortalStorage.getGlobalPortals((class_1937)McHelper.getServerWorld(this.entries.get((int)0).dimension)).isEmpty()) {
            Helper.err((Object)"There are already global portals when initializing dimension stack");
            return;
        }
        Helper.wrapAdjacentAndMap(this.entries.stream(), (before, after) -> {
            AltiusInfo.createConnectionBetween(before, after, this.gravityChange);
            return null;
        }).forEach(k -> {});
        if (this.loop) {
            AltiusInfo.createConnectionBetween(this.entries.get(this.entries.size() - 1), this.entries.get(0), this.gravityChange);
        }
        HashMap<class_5321<class_1937>, class_2680> bedrockReplacementMap = new HashMap<class_5321<class_1937>, class_2680>();
        for (AltiusEntry entry : this.entries) {
            String bedrockReplacementStr = entry.bedrockReplacementStr;
            class_2680 bedrockReplacement = AltiusInfo.parseBlockString(bedrockReplacementStr);
            if (bedrockReplacement != null) {
                bedrockReplacementMap.put(entry.dimension, bedrockReplacement);
            }
            GlobalPortalStorage gps = GlobalPortalStorage.get((class_3218)McHelper.getServerWorld(entry.dimension));
            gps.bedrockReplacement = bedrockReplacement;
            gps.onDataChanged();
        }
        AltiusManagement.bedrockReplacementMap = bedrockReplacementMap;
        McHelper.sendMessageToFirstLoggedPlayer((class_2561)new class_2588("imm_ptl.dim_stack_initialized"));
    }

    public class_2487 toNbt() {
        class_2487 nbtCompound = new class_2487();
        nbtCompound.method_10556("loop", this.loop);
        nbtCompound.method_10556("gravityChange", this.gravityChange);
        class_2499 list = new class_2499();
        for (AltiusEntry entry : this.entries) {
            list.add((Object)entry.toNbt());
        }
        nbtCompound.method_10566("entries", (class_2520)list);
        return nbtCompound;
    }

    public static AltiusInfo fromNbt(class_2487 compound) {
        boolean loop = compound.method_10577("loop");
        boolean gravityChange = compound.method_10577("gravityChange");
        class_2499 list = compound.method_10554("entries", (int)new class_2487().method_10711());
        List<AltiusEntry> entries = list.stream().map(n -> AltiusEntry.fromNbt((class_2487)n)).collect(Collectors.toList());
        return new AltiusInfo(entries, loop, gravityChange);
    }

    @Nullable
    public static class_2680 parseBlockString(@Nullable String str) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return null;
        }
        try {
            Optional block = class_2378.field_11146.method_17966(new class_2960(str));
            return block.map(class_2248::method_9564).orElse(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

