/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.altius_world;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.portal.global_portals.VerticalConnectingPortal;
import qouteall.imm_ptl.peripheral.altius_world.AltiusEntry;
import qouteall.imm_ptl.peripheral.altius_world.AltiusGameRule;
import qouteall.imm_ptl.peripheral.altius_world.AltiusInfo;
import qouteall.imm_ptl.peripheral.altius_world.AltiusScreen;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.dimension.DimId;

public class AltiusManagement {
    public static AltiusInfo dimStackToApply = null;
    public static Map<class_5321<class_1937>, class_2680> bedrockReplacementMap = new HashMap<class_5321<class_1937>, class_2680>();

    public static void init() {
    }

    public static void onServerEarlyInit(MinecraftServer server) {
        HashMap<class_5321<class_1937>, class_2680> newMap = new HashMap<class_5321<class_1937>, class_2680>();
        if (dimStackToApply != null) {
            for (AltiusEntry entry : AltiusManagement.dimStackToApply.entries) {
                newMap.put(entry.dimension, AltiusInfo.parseBlockString(entry.bedrockReplacementStr));
            }
        }
        bedrockReplacementMap = newMap;
    }

    public static void onServerCreatedWorlds(MinecraftServer server) {
        if (dimStackToApply != null) {
            dimStackToApply.apply();
            dimStackToApply = null;
        } else {
            AltiusManagement.updateBedrockReplacementFromStorage(server);
            class_1928 gameRules = server.method_3767();
            class_1928.class_4310 o = (class_1928.class_4310)gameRules.method_20746(AltiusGameRule.dimensionStackKey);
            if (o.method_20753()) {
                o.method_20758(false, server);
                AltiusManagement.upgradeLegacyDimensionStack(server);
            }
        }
    }

    private static void updateBedrockReplacementFromStorage(MinecraftServer server) {
        HashMap<class_5321<class_1937>, class_2680> newMap = new HashMap<class_5321<class_1937>, class_2680>();
        for (class_3218 world : server.method_3738()) {
            class_2680 replacement = GlobalPortalStorage.get((class_3218)world).bedrockReplacement;
            newMap.put((class_5321<class_1937>)world.method_27983(), replacement);
            Helper.log((Object)String.format("Bedrock Replacement %s %s", world.method_27983().method_29177(), replacement != null ? class_2378.field_11146.method_10221((Object)replacement.method_26204()) : "null"));
        }
        bedrockReplacementMap = newMap;
    }

    public static void upgradeLegacyDimensionStack(MinecraftServer server) {
        for (class_3218 world : server.method_3738()) {
            GlobalPortalStorage gps = GlobalPortalStorage.get((class_3218)world);
            gps.bedrockReplacement = class_2246.field_10540.method_9564();
            gps.onDataChanged();
        }
        AltiusManagement.updateBedrockReplacementFromStorage(server);
        Helper.log((Object)"Legacy Dimension Stack Upgraded");
    }

    public static void replaceBedrock(class_3218 world, class_2791 chunk) {
        if (bedrockReplacementMap == null) {
            Helper.err((Object)"Dimension Stack Bedrock Replacement Abnormal");
            return;
        }
        class_2680 replacement = bedrockReplacementMap.get(world.method_27983());
        if (replacement != null) {
            class_2338.class_2339 mutable = new class_2338.class_2339();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = chunk.method_31607(); y < chunk.method_31600(); ++y) {
                        mutable.method_10103(x, y, z);
                        class_2680 blockState = chunk.method_8320((class_2338)mutable);
                        if (blockState.method_26204() != class_2246.field_9987) continue;
                        chunk.method_12010((class_2338)mutable, replacement, false);
                    }
                }
            }
        }
    }

    private static void clearDimStackPortals() {
        MinecraftServer server = MiscHelper.getServer();
        for (class_3218 world : server.method_3738()) {
            GlobalPortalStorage gps = GlobalPortalStorage.get((class_3218)world);
            gps.data.removeIf(p -> p instanceof VerticalConnectingPortal);
            gps.bedrockReplacement = null;
            gps.onDataChanged();
        }
        AltiusManagement.updateBedrockReplacementFromStorage(server);
    }

    public static class RemoteCallables {
        @Environment(value=EnvType.CLIENT)
        public static void clientOpenScreen(List<String> dimensions) {
            List dimensionList = dimensions.stream().map(DimId::idToKey).collect(Collectors.toList());
            class_310.method_1551().method_1507((class_437)new AltiusScreen(null, screen -> dimensionList, altiusInfo -> {
                if (altiusInfo != null) {
                    McRemoteProcedureCall.tellServerToInvoke((String)"qouteall.imm_ptl.peripheral.altius_world.AltiusManagement.RemoteCallables.serverSetupDimStack", (Object[])new Object[]{altiusInfo.toNbt()});
                } else {
                    McRemoteProcedureCall.tellServerToInvoke((String)"qouteall.imm_ptl.peripheral.altius_world.AltiusManagement.RemoteCallables.serverRemoveDimStack", (Object[])new Object[0]);
                }
            }));
        }

        public static void serverSetupDimStack(class_3222 player, class_2487 infoTag) {
            if (!player.method_5687(2)) {
                Helper.err((Object)"one player without permission tries to change dimension stack");
                return;
            }
            AltiusInfo altiusInfo = AltiusInfo.fromNbt(infoTag);
            AltiusManagement.clearDimStackPortals();
            altiusInfo.apply();
            player.method_7353((class_2561)new class_2588("imm_ptl.dim_stack_established"), false);
        }

        public static void serverRemoveDimStack(class_3222 player) {
            if (!player.method_5687(2)) {
                Helper.err((Object)"one player without permission tries to change dimension stack");
                return;
            }
            AltiusManagement.clearDimStackPortals();
            player.method_7353((class_2561)new class_2588("imm_ptl.dim_stack_removed"), false);
        }
    }
}

