/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.guide;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.network.IPCommonNetworkClient;
import qouteall.q_misc_util.my_util.MyTaskList;

@Environment(value=EnvType.CLIENT)
public class IPGuide {
    private static GuideInfo guideInfo = new GuideInfo();

    private static GuideInfo readFromFile() {
        File storageFile = IPGuide.getStorageFile();
        if (storageFile.exists()) {
            GuideInfo result = null;
            try (FileReader fileReader = new FileReader(storageFile);){
                result = (GuideInfo)IPGlobal.gson.fromJson((Reader)fileReader, GuideInfo.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                return new GuideInfo();
            }
            if (result == null) {
                return new GuideInfo();
            }
            return result;
        }
        return new GuideInfo();
    }

    private static File getStorageFile() {
        return new File(class_310.method_1551().field_1697, "imm_ptl_state.json");
    }

    private static void writeToFile(GuideInfo guideInfo) {
        try (FileWriter fileWriter = new FileWriter(IPGuide.getStorageFile());){
            IPGlobal.gson.toJson((Object)guideInfo, (Appendable)fileWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void initClient() {
        guideInfo = IPGuide.readFromFile();
        IPCommonNetworkClient.clientPortalSpawnSignal.connect(p -> {
            class_746 player = class_310.method_1551().field_1724;
            if (!IPGuide.guideInfo.wikiInformed && player != null && player.method_7337()) {
                IPGuide.guideInfo.wikiInformed = true;
                IPGuide.writeToFile(guideInfo);
                IPGuide.informWithURL("https://qouteall.fun/immptl/wiki/Portal-Customization", (class_5250)new class_2588("imm_ptl.inform_wiki"));
            }
            if (!IPGuide.guideInfo.lagInformed && player != null) {
                IPGuide.guideInfo.lagInformed = true;
                IPGuide.writeToFile(guideInfo);
                IPGlobal.clientTaskList.addTask(MyTaskList.withDelay((int)100, () -> {
                    class_310.method_1551().field_1705.method_1755(class_2556.field_11735, (class_2561)new class_2588("imm_ptl.about_lag"), class_156.field_25140);
                    return true;
                }));
            }
        });
    }

    public static void onClientPlacePortalHelper() {
        if (!IPGuide.guideInfo.portalHelperInformed) {
            IPGuide.guideInfo.portalHelperInformed = true;
            IPGuide.writeToFile(guideInfo);
            IPGuide.informWithURL("https://qouteall.fun/immptl/wiki/Portal-Customization#portal-helper-block", (class_5250)new class_2588("imm_ptl.inform_portal_helper"));
        }
    }

    private static void informWithURL(String link, class_5250 text) {
        class_310.method_1551().field_1705.method_1755(class_2556.field_11735, (class_2561)text.method_10852((class_2561)McHelper.getLinkText((String)link)), class_156.field_25140);
    }

    public static class GuideInfo {
        public boolean wikiInformed = false;
        public boolean portalHelperInformed = false;
        public boolean lagInformed = false;
    }

    @Environment(value=EnvType.CLIENT)
    public static class RemoteCallables {
        public static void showWiki() {
            IPGuide.informWithURL("https://qouteall.fun/immptl/wiki/Commands-Reference", (class_5250)new class_2585(""));
        }
    }
}

