/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.ithaka.digraph;

import de.odysseus.ithaka.digraph.Digraph;
import de.odysseus.ithaka.digraph.DigraphFactory;
import de.odysseus.ithaka.digraph.Digraphs;
import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeMap;

public class MapDigraph<V>
implements Digraph<V> {
    private static final int INVALID_WEIGHT = Integer.MIN_VALUE;
    private final VertexMapFactory<V> vertexMapFactory;
    private final EdgeMapFactory<V> edgeMapFactory;
    private final Map<V, Object2IntMap<V>> vertexMap;
    private int edgeCount;

    public static <V> DigraphFactory<MapDigraph<V>> getDefaultDigraphFactory() {
        return MapDigraph.getMapDigraphFactory(MapDigraph.getDefaultVertexMapFactory(null), MapDigraph.getDefaultEdgeMapFactory(null));
    }

    public static <V> DigraphFactory<MapDigraph<V>> getMapDigraphFactory(VertexMapFactory<V> vertexMapFactory, EdgeMapFactory<V> edgeMapFactory) {
        return () -> new MapDigraph(vertexMapFactory, edgeMapFactory);
    }

    private static <V> VertexMapFactory<V> getDefaultVertexMapFactory(final Comparator<? super V> comparator) {
        return new VertexMapFactory<V>(){

            @Override
            public Map<V, Object2IntMap<V>> create() {
                if (comparator == null) {
                    return new LinkedHashMap(16);
                }
                return new TreeMap(comparator);
            }
        };
    }

    private static <V> EdgeMapFactory<V> getDefaultEdgeMapFactory(final Comparator<? super V> comparator) {
        return new EdgeMapFactory<V>(){

            @Override
            public Object2IntMap<V> create(V v) {
                Object object = comparator == null ? new Object2IntLinkedOpenHashMap(16) : new Object2IntAVLTreeMap(comparator);
                object.defaultReturnValue(Integer.MIN_VALUE);
                return object;
            }
        };
    }

    private static <V> Object2IntMap<V> createEmptyMap() {
        return Object2IntMaps.emptyMap();
    }

    public MapDigraph() {
        this(null);
    }

    public MapDigraph(Comparator<? super V> comparator) {
        this(comparator, comparator);
    }

    public MapDigraph(Comparator<? super V> comparator, Comparator<? super V> comparator2) {
        this(MapDigraph.getDefaultVertexMapFactory(comparator), MapDigraph.getDefaultEdgeMapFactory(comparator2));
    }

    public MapDigraph(VertexMapFactory<V> vertexMapFactory, EdgeMapFactory<V> edgeMapFactory) {
        this.vertexMapFactory = vertexMapFactory;
        this.edgeMapFactory = edgeMapFactory;
        this.vertexMap = vertexMapFactory.create();
    }

    @Override
    public boolean add(V v) {
        if (!this.vertexMap.containsKey(v)) {
            this.vertexMap.put((Object2IntMap<V>)v, (Object2IntMap<Object2IntMap<V>>)MapDigraph.createEmptyMap());
            return true;
        }
        return false;
    }

    @Override
    public OptionalInt put(V v, V v2, int n) {
        OptionalInt optionalInt;
        int n2;
        if (n == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Invalid weight " + n);
        }
        Object2IntMap<V> object2IntMap = this.vertexMap.get(v);
        if (object2IntMap == null || object2IntMap.isEmpty()) {
            object2IntMap = this.edgeMapFactory.create(v);
            this.vertexMap.put((Object2IntMap<V>)v, (Object2IntMap<Object2IntMap<V>>)object2IntMap);
        }
        if ((n2 = object2IntMap.put(v2, n)) != Integer.MIN_VALUE) {
            optionalInt = OptionalInt.of(n2);
        } else {
            optionalInt = OptionalInt.empty();
            this.add(v2);
            ++this.edgeCount;
        }
        return optionalInt;
    }

    @Override
    public OptionalInt get(V v, V v2) {
        Object2IntMap<V> object2IntMap = this.vertexMap.get(v);
        if (object2IntMap == null || object2IntMap.isEmpty()) {
            return OptionalInt.empty();
        }
        int n = object2IntMap.getInt(v2);
        return n == Integer.MIN_VALUE ? OptionalInt.empty() : OptionalInt.of(n);
    }

    @Override
    public OptionalInt remove(V v, V v2) {
        Object2IntMap<V> object2IntMap = this.vertexMap.get(v);
        if (object2IntMap == null || !object2IntMap.containsKey(v2)) {
            return OptionalInt.empty();
        }
        int n = object2IntMap.removeInt(v2);
        --this.edgeCount;
        if (object2IntMap.isEmpty()) {
            this.vertexMap.put((Object2IntMap<V>)v, (Object2IntMap<Object2IntMap<V>>)MapDigraph.createEmptyMap());
        }
        return n == Integer.MIN_VALUE ? OptionalInt.empty() : OptionalInt.of(n);
    }

    @Override
    public boolean remove(V v) {
        Object2IntMap<V> object2IntMap = this.vertexMap.get(v);
        if (object2IntMap == null) {
            return false;
        }
        this.edgeCount -= object2IntMap.size();
        this.vertexMap.remove(v);
        for (V v2 : this.vertexMap.keySet()) {
            this.remove(v2, v);
        }
        return true;
    }

    @Override
    public void removeAll(Collection<V> collection) {
        Object2IntMap<V> object2IntMap;
        for (V v : collection) {
            object2IntMap = this.vertexMap.get(v);
            if (object2IntMap == null) continue;
            this.edgeCount -= object2IntMap.size();
            this.vertexMap.remove(v);
        }
        for (V v : this.vertexMap.keySet()) {
            object2IntMap = this.vertexMap.get(v);
            ObjectIterator objectIterator = object2IntMap.keySet().iterator();
            while (objectIterator.hasNext()) {
                if (!collection.contains(objectIterator.next())) continue;
                objectIterator.remove();
                --this.edgeCount;
            }
            if (!object2IntMap.isEmpty()) continue;
            this.vertexMap.put((Object2IntMap<V>)v, (Object2IntMap<Object2IntMap<V>>)MapDigraph.createEmptyMap());
        }
    }

    @Override
    public boolean contains(V v, V v2) {
        Object2IntMap<V> object2IntMap = this.vertexMap.get(v);
        if (object2IntMap == null || object2IntMap.isEmpty()) {
            return false;
        }
        return object2IntMap.containsKey(v2);
    }

    @Override
    public boolean contains(V v) {
        return this.vertexMap.containsKey(v);
    }

    @Override
    public Iterable<V> vertices() {
        if (this.vertexMap.isEmpty()) {
            return Collections.emptySet();
        }
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private final Iterator<V> delegate;
                    V vertex;
                    {
                        this.delegate = MapDigraph.this.vertexMap.keySet().iterator();
                        this.vertex = null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegate.hasNext();
                    }

                    @Override
                    public V next() {
                        this.vertex = this.delegate.next();
                        return this.vertex;
                    }

                    @Override
                    public void remove() {
                        Object2IntMap object2IntMap = MapDigraph.this.vertexMap.get(this.vertex);
                        this.delegate.remove();
                        MapDigraph.this.edgeCount -= object2IntMap.size();
                        for (Object v : MapDigraph.this.vertexMap.keySet()) {
                            MapDigraph.this.remove(v, this.vertex);
                        }
                    }
                };
            }

            public String toString() {
                return MapDigraph.this.vertexMap.keySet().toString();
            }
        };
    }

    @Override
    public Iterable<V> targets(final V v) {
        final Object2IntMap<V> object2IntMap = this.vertexMap.get(v);
        if (object2IntMap == null || object2IntMap.isEmpty()) {
            return Collections.emptySet();
        }
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private final Iterator<V> delegate;
                    {
                        this.delegate = object2IntMap.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegate.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.delegate.next();
                    }

                    @Override
                    public void remove() {
                        this.delegate.remove();
                        --MapDigraph.this.edgeCount;
                        if (object2IntMap.isEmpty()) {
                            MapDigraph.this.vertexMap.put(v, MapDigraph.createEmptyMap());
                        }
                    }
                };
            }

            public String toString() {
                return object2IntMap.keySet().toString();
            }
        };
    }

    @Override
    public int getVertexCount() {
        return this.vertexMap.size();
    }

    @Override
    public int totalWeight() {
        int n = 0;
        for (V v : this.vertices()) {
            for (V v2 : this.targets(v)) {
                n += this.get(v, v2).getAsInt();
            }
        }
        return n;
    }

    @Override
    public int getOutDegree(V v) {
        Object2IntMap<V> object2IntMap = this.vertexMap.get(v);
        if (object2IntMap == null) {
            return 0;
        }
        return object2IntMap.size();
    }

    @Override
    public int getEdgeCount() {
        return this.edgeCount;
    }

    public DigraphFactory<? extends MapDigraph<V>> getDigraphFactory() {
        return () -> new MapDigraph<V>(this.vertexMapFactory, this.edgeMapFactory);
    }

    @Override
    public MapDigraph<V> reverse() {
        return Digraphs.reverse(this, this.getDigraphFactory());
    }

    @Override
    public MapDigraph<V> subgraph(Set<V> set) {
        return Digraphs.subgraph(this, set, this.getDigraphFactory());
    }

    @Override
    public boolean isAcyclic() {
        return Digraphs.isAcyclic(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
        stringBuilder.append("(");
        Iterator<V> iterator = this.vertices().iterator();
        while (iterator.hasNext()) {
            V v = iterator.next();
            stringBuilder.append(v);
            stringBuilder.append(this.targets(v));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
            if (stringBuilder.length() <= 1000) continue;
            stringBuilder.append("...");
            break;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static interface VertexMapFactory<V> {
        public Map<V, Object2IntMap<V>> create();
    }

    public static interface EdgeMapFactory<V> {
        public Object2IntMap<V> create(V var1);
    }
}

