/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.shader_overrides;

import java.util.EnumMap;
import java.util.Optional;
import me.jellysquid.mods.sodium.client.gl.GlObject;
import me.jellysquid.mods.sodium.client.gl.shader.GlProgram;
import me.jellysquid.mods.sodium.client.gl.shader.GlShader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderType;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import net.coderbot.iris.Iris;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisChunkShaderInterface;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisShaderTypes;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisTerrainPass;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.ShaderBindingContextExt;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.shadows.ShadowRenderingState;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class IrisChunkProgramOverrides {
    private boolean shadersCreated = false;
    private final EnumMap<IrisTerrainPass, GlProgram<IrisChunkShaderInterface>> programs = new EnumMap(IrisTerrainPass.class);

    private GlShader createVertexShader(IrisTerrainPass irisTerrainPass, SodiumTerrainPipeline sodiumTerrainPipeline) {
        Optional<String> optional;
        if (irisTerrainPass == IrisTerrainPass.SHADOW || irisTerrainPass == IrisTerrainPass.SHADOW_CUTOUT) {
            optional = sodiumTerrainPipeline.getShadowVertexShaderSource();
        } else if (irisTerrainPass == IrisTerrainPass.GBUFFER_SOLID || irisTerrainPass == IrisTerrainPass.GBUFFER_CUTOUT) {
            optional = sodiumTerrainPipeline.getTerrainVertexShaderSource();
        } else if (irisTerrainPass == IrisTerrainPass.GBUFFER_TRANSLUCENT) {
            optional = sodiumTerrainPipeline.getTranslucentVertexShaderSource();
        } else {
            throw new IllegalArgumentException("Unknown pass type " + irisTerrainPass);
        }
        String string = optional.orElse(null);
        if (string == null) {
            return null;
        }
        return new GlShader(ShaderType.VERTEX, new class_2960("iris", "sodium-terrain.vsh"), string);
    }

    private GlShader createGeometryShader(IrisTerrainPass irisTerrainPass, SodiumTerrainPipeline sodiumTerrainPipeline) {
        Optional<String> optional;
        if (irisTerrainPass == IrisTerrainPass.SHADOW || irisTerrainPass == IrisTerrainPass.SHADOW_CUTOUT) {
            optional = sodiumTerrainPipeline.getShadowGeometryShaderSource();
        } else if (irisTerrainPass == IrisTerrainPass.GBUFFER_SOLID || irisTerrainPass == IrisTerrainPass.GBUFFER_CUTOUT) {
            optional = sodiumTerrainPipeline.getTerrainGeometryShaderSource();
        } else if (irisTerrainPass == IrisTerrainPass.GBUFFER_TRANSLUCENT) {
            optional = sodiumTerrainPipeline.getTranslucentGeometryShaderSource();
        } else {
            throw new IllegalArgumentException("Unknown pass type " + irisTerrainPass);
        }
        String string = optional.orElse(null);
        if (string == null) {
            return null;
        }
        return new GlShader(IrisShaderTypes.GEOMETRY, new class_2960("iris", "sodium-terrain.gsh"), string);
    }

    private GlShader createFragmentShader(IrisTerrainPass irisTerrainPass, SodiumTerrainPipeline sodiumTerrainPipeline) {
        Optional<String> optional;
        if (irisTerrainPass == IrisTerrainPass.SHADOW) {
            optional = sodiumTerrainPipeline.getShadowFragmentShaderSource();
        } else if (irisTerrainPass == IrisTerrainPass.SHADOW_CUTOUT) {
            optional = sodiumTerrainPipeline.getShadowCutoutFragmentShaderSource();
        } else if (irisTerrainPass == IrisTerrainPass.GBUFFER_SOLID) {
            optional = sodiumTerrainPipeline.getTerrainFragmentShaderSource();
        } else if (irisTerrainPass == IrisTerrainPass.GBUFFER_CUTOUT) {
            optional = sodiumTerrainPipeline.getTerrainCutoutFragmentShaderSource();
        } else if (irisTerrainPass == IrisTerrainPass.GBUFFER_TRANSLUCENT) {
            optional = sodiumTerrainPipeline.getTranslucentFragmentShaderSource();
        } else {
            throw new IllegalArgumentException("Unknown pass type " + irisTerrainPass);
        }
        String string = optional.orElse(null);
        if (string == null) {
            return null;
        }
        return new GlShader(ShaderType.FRAGMENT, new class_2960("iris", "sodium-terrain.fsh"), string);
    }

    private BlendModeOverride getBlendOverride(IrisTerrainPass irisTerrainPass, SodiumTerrainPipeline sodiumTerrainPipeline) {
        if (irisTerrainPass == IrisTerrainPass.SHADOW || irisTerrainPass == IrisTerrainPass.SHADOW_CUTOUT) {
            return sodiumTerrainPipeline.getShadowBlendOverride();
        }
        if (irisTerrainPass == IrisTerrainPass.GBUFFER_SOLID || irisTerrainPass == IrisTerrainPass.GBUFFER_CUTOUT) {
            return sodiumTerrainPipeline.getTerrainBlendOverride();
        }
        if (irisTerrainPass == IrisTerrainPass.GBUFFER_TRANSLUCENT) {
            return sodiumTerrainPipeline.getTranslucentBlendOverride();
        }
        throw new IllegalArgumentException("Unknown pass type " + irisTerrainPass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private GlProgram<IrisChunkShaderInterface> createShader(IrisTerrainPass irisTerrainPass, SodiumTerrainPipeline sodiumTerrainPipeline) {
        GlShader glShader = this.createVertexShader(irisTerrainPass, sodiumTerrainPipeline);
        GlShader glShader2 = this.createGeometryShader(irisTerrainPass, sodiumTerrainPipeline);
        GlShader glShader3 = this.createFragmentShader(irisTerrainPass, sodiumTerrainPipeline);
        BlendModeOverride blendModeOverride = this.getBlendOverride(irisTerrainPass, sodiumTerrainPipeline);
        if (glShader == null || glShader3 == null) {
            if (glShader != null) {
                glShader.delete();
            }
            if (glShader2 != null) {
                glShader2.delete();
            }
            if (glShader3 != null) {
                glShader3.delete();
            }
            return null;
        }
        try {
            GlProgram.Builder builder = GlProgram.builder((class_2960)new class_2960("sodium", "chunk_shader_for_" + irisTerrainPass.getName()));
            if (glShader2 != null) {
                builder.attachShader(glShader2);
            }
            GlProgram glProgram = builder.attachShader(glShader).attachShader(glShader3).bindAttribute("a_PosId", 1).bindAttribute("a_Color", 2).bindAttribute("a_TexCoord", 3).bindAttribute("a_LightCoord", 4).bindAttribute("mc_Entity", 5).bindAttribute("mc_midTexCoord", 6).bindAttribute("at_tangent", 7).bindAttribute("a_Normal", 8).bindFragmentData("iris_FragData", 0).link(shaderBindingContext -> {
                int n = ((GlObject)shaderBindingContext).handle();
                ShaderBindingContextExt shaderBindingContextExt = (ShaderBindingContextExt)shaderBindingContext;
                return new IrisChunkShaderInterface(n, shaderBindingContextExt, sodiumTerrainPipeline, irisTerrainPass == IrisTerrainPass.SHADOW || irisTerrainPass == IrisTerrainPass.SHADOW_CUTOUT, blendModeOverride);
            });
            return glProgram;
        }
        finally {
            glShader.delete();
            if (glShader2 != null) {
                glShader2.delete();
            }
            glShader3.delete();
        }
    }

    private SodiumTerrainPipeline getSodiumTerrainPipeline() {
        WorldRenderingPipeline worldRenderingPipeline = Iris.getPipelineManager().getPipelineNullable();
        if (worldRenderingPipeline != null) {
            return worldRenderingPipeline.getSodiumTerrainPipeline();
        }
        return null;
    }

    private void createShaders(ChunkVertexType chunkVertexType) {
        SodiumTerrainPipeline sodiumTerrainPipeline = this.getSodiumTerrainPipeline();
        Iris.getPipelineManager().clearSodiumShaderReloadNeeded();
        if (sodiumTerrainPipeline != null) {
            sodiumTerrainPipeline.patchShaders(chunkVertexType);
            for (IrisTerrainPass irisTerrainPass : IrisTerrainPass.values()) {
                this.programs.put(irisTerrainPass, this.createShader(irisTerrainPass, sodiumTerrainPipeline));
            }
        } else {
            this.programs.clear();
        }
        this.shadersCreated = true;
    }

    @Nullable
    public GlProgram<IrisChunkShaderInterface> getProgramOverride(BlockRenderPass blockRenderPass, ChunkVertexType chunkVertexType) {
        if (Iris.getPipelineManager().isSodiumShaderReloadNeeded()) {
            this.deleteShaders();
        }
        if (!this.shadersCreated) {
            this.createShaders(chunkVertexType);
        }
        if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            if (blockRenderPass == BlockRenderPass.CUTOUT || blockRenderPass == BlockRenderPass.CUTOUT_MIPPED) {
                return this.programs.get((Object)IrisTerrainPass.SHADOW_CUTOUT);
            }
            return this.programs.get((Object)IrisTerrainPass.SHADOW);
        }
        if (blockRenderPass == BlockRenderPass.CUTOUT || blockRenderPass == BlockRenderPass.CUTOUT_MIPPED) {
            return this.programs.get((Object)IrisTerrainPass.GBUFFER_CUTOUT);
        }
        if (blockRenderPass.isTranslucent()) {
            return this.programs.get((Object)IrisTerrainPass.GBUFFER_TRANSLUCENT);
        }
        return this.programs.get((Object)IrisTerrainPass.GBUFFER_SOLID);
    }

    public void bindFramebuffer(BlockRenderPass blockRenderPass) {
        GlFramebuffer glFramebuffer;
        SodiumTerrainPipeline sodiumTerrainPipeline = this.getSodiumTerrainPipeline();
        boolean bl = ShadowRenderingState.areShadowsCurrentlyBeingRendered();
        if (sodiumTerrainPipeline != null && (glFramebuffer = bl ? sodiumTerrainPipeline.getShadowFramebuffer() : (blockRenderPass.isTranslucent() ? sodiumTerrainPipeline.getTranslucentFramebuffer() : sodiumTerrainPipeline.getTerrainFramebuffer())) != null) {
            glFramebuffer.bind();
        }
    }

    public void unbindFramebuffer() {
        SodiumTerrainPipeline sodiumTerrainPipeline = this.getSodiumTerrainPipeline();
        if (sodiumTerrainPipeline != null) {
            class_310.method_1551().method_1522().method_1235(false);
        }
    }

    public void deleteShaders() {
        for (GlProgram<IrisChunkShaderInterface> glProgram : this.programs.values()) {
            if (glProgram == null) continue;
            glProgram.delete();
        }
        this.programs.clear();
        this.shadersCreated = false;
    }
}

