/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp;

import java.nio.ByteBuffer;
import net.coderbot.iris.compat.sodium.impl.vertex_format.QuadView;
import org.lwjgl.system.MemoryUtil;

public abstract class QuadViewEntity
extends QuadView {
    long writePointer;
    int stride = 48;

    @Override
    public float x(int n) {
        return this.getFloat(this.writePointer - (long)this.stride * (4L - (long)n));
    }

    @Override
    public float y(int n) {
        return this.getFloat(this.writePointer + 4L - (long)this.stride * (4L - (long)n));
    }

    @Override
    public float z(int n) {
        return this.getFloat(this.writePointer + 8L - (long)this.stride * (4L - (long)n));
    }

    @Override
    public float u(int n) {
        return this.getFloat(this.writePointer + 16L - (long)this.stride * (4L - (long)n));
    }

    @Override
    public float v(int n) {
        return this.getFloat(this.writePointer + 20L - (long)this.stride * (4L - (long)n));
    }

    abstract float getFloat(long var1);

    public static class QuadViewEntityNio
    extends QuadViewEntity {
        ByteBuffer buffer;

        public void setup(ByteBuffer byteBuffer, int n, int n2) {
            this.buffer = byteBuffer;
            this.writePointer = n;
            this.stride = n2;
        }

        @Override
        float getFloat(long l) {
            return this.buffer.getFloat((int)l);
        }
    }

    public static class QuadViewEntityUnsafe
    extends QuadViewEntity {
        public void setup(long l, int n) {
            this.writePointer = l;
            this.stride = n;
        }

        @Override
        float getFloat(long l) {
            return MemoryUtil.memGetFloat((long)l);
        }
    }
}

