/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.framebuffer;

import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import net.coderbot.iris.gl.GlResource;
import net.coderbot.iris.gl.IrisRenderSystem;

public class GlFramebuffer
extends GlResource {
    private final Int2IntMap attachments = new Int2IntArrayMap();
    private final int maxDrawBuffers = GlStateManager._getInteger((int)34852);
    private final int maxColorAttachments = GlStateManager._getInteger((int)36063);

    public GlFramebuffer() {
        super(GlStateManager.glGenFramebuffers());
        this.bind();
    }

    public void addDepthAttachment(int n) {
        this.bind();
        GlStateManager._glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)n, (int)0);
    }

    public void addColorAttachment(int n, int n2) {
        this.bind();
        GlStateManager._glFramebufferTexture2D((int)36160, (int)(36064 + n), (int)3553, (int)n2, (int)0);
        this.attachments.put(n, n2);
    }

    public void drawBuffers(int[] nArray) {
        this.bind();
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        if (nArray.length > this.maxDrawBuffers) {
            throw new IllegalArgumentException("Cannot write to more than " + this.maxDrawBuffers + " draw buffers on this GPU");
        }
        for (int n2 : nArray) {
            if (n2 >= this.maxColorAttachments) {
                throw new IllegalArgumentException("Only " + this.maxColorAttachments + " color attachments are supported on this GPU, but an attempt was made to write to a color attachment with index " + n2);
            }
            nArray2[n++] = 36064 + n2;
        }
        IrisRenderSystem.drawBuffers(nArray2);
    }

    public void readBuffer(int n) {
        this.bind();
        IrisRenderSystem.readBuffer(36064 + n);
    }

    public int getColorAttachment(int n) {
        return this.attachments.get(n);
    }

    public void bind() {
        GlStateManager._glBindFramebuffer((int)36160, (int)this.getGlId());
    }

    public void bindAsReadBuffer() {
        GlStateManager._glBindFramebuffer((int)36008, (int)this.getGlId());
    }

    public void bindAsDrawBuffer() {
        GlStateManager._glBindFramebuffer((int)36009, (int)this.getGlId());
    }

    @Override
    protected void destroyInternal() {
        GlStateManager._glDeleteFramebuffers((int)this.getGlId());
    }

    public boolean isComplete() {
        this.bind();
        int n = GlStateManager.glCheckFramebufferStatus((int)36160);
        return n == 36053;
    }
}

